/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;

public final class OnFailureRestartPolicy
implements ComponentRestartPolicy {
    private static OnFailureRestartPolicy INSTANCE = new OnFailureRestartPolicy();

    private OnFailureRestartPolicy() {
    }

    public static OnFailureRestartPolicy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isLongLived() {
        return false;
    }

    @Override
    public boolean hasCompleted(Component component) {
        return this.hasCompletedSuccessfully(component);
    }

    @Override
    public boolean hasCompletedSuccessfully(Component component) {
        return component.getNumSucceededInstances() == (long)component.getNumDesiredInstances();
    }

    @Override
    public boolean shouldRelaunchInstance(ComponentInstance componentInstance, ContainerStatus containerStatus) {
        return ComponentInstance.hasContainerFailed(containerStatus);
    }

    @Override
    public boolean isReadyForDownStream(Component dependentComponent) {
        return (long)dependentComponent.getNumReadyInstances() + dependentComponent.getNumSucceededInstances() + dependentComponent.getNumFailedInstances() >= (long)dependentComponent.getNumDesiredInstances();
    }

    @Override
    public boolean allowUpgrades() {
        return false;
    }

    @Override
    public boolean shouldTerminate(Component component) {
        long nSucceeded = component.getNumSucceededInstances();
        return nSucceeded >= component.getComponentSpec().getNumberOfContainers();
    }

    @Override
    public boolean allowContainerRetriesForInstance(ComponentInstance componentInstance) {
        return true;
    }
}

