/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.hadoop.shaded.org.mockito.Captor;
import org.apache.hadoop.shaded.org.mockito.InjectMocks;
import org.apache.hadoop.shaded.org.mockito.Mock;
import org.apache.hadoop.shaded.org.mockito.MockSettings;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.Spy;
import org.apache.hadoop.shaded.org.mockito.configuration.AnnotationEngine;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.StringUtil;

public class SpyAnnotationEngine
implements org.apache.hadoop.shaded.org.mockito.plugins.AnnotationEngine,
AnnotationEngine {
    @Override
    public void process(Class<?> context, Object testInstance) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            SpyAnnotationEngine.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, Captor.class);
            field.setAccessible(true);
            try {
                Object instance = field.get(testInstance);
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                if (instance != null) {
                    field.set(testInstance, SpyAnnotationEngine.spyInstance(field, instance));
                    continue;
                }
                field.set(testInstance, SpyAnnotationEngine.spyNewInstance(testInstance, field));
            }
            catch (Exception e) {
                throw new MockitoException("Unable to initialize @Spy annotated field '" + field.getName() + "'.\n" + e.getMessage(), e);
            }
        }
    }

    private static Object spyInstance(Field field, Object instance) {
        return Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName()));
    }

    private static Object spyNewInstance(Object testInstance, Field field) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        MockSettings settings = Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName());
        Class<?> type = field.getType();
        if (type.isInterface()) {
            return Mockito.mock(type, settings.useConstructor(new Object[0]));
        }
        int modifiers = type.getModifiers();
        if (SpyAnnotationEngine.typeIsPrivateAbstractInnerClass(type, modifiers)) {
            throw new MockitoException(StringUtil.join("@Spy annotation can't initialize private abstract inner classes.", "  inner class: '" + type.getSimpleName() + "'", "  outer class: '" + type.getEnclosingClass().getSimpleName() + "'", "", "You should augment the visibility of this inner class"));
        }
        if (SpyAnnotationEngine.typeIsNonStaticInnerClass(type, modifiers)) {
            Class<?> enclosing = type.getEnclosingClass();
            if (!enclosing.isInstance(testInstance)) {
                throw new MockitoException(StringUtil.join("@Spy annotation can only initialize inner classes declared in the test.", "  inner class: '" + type.getSimpleName() + "'", "  outer class: '" + enclosing.getSimpleName() + "'", ""));
            }
            return Mockito.mock(type, settings.useConstructor(new Object[0]).outerInstance(testInstance));
        }
        Constructor<?> constructor = SpyAnnotationEngine.noArgConstructorOf(type);
        if (Modifier.isPrivate(constructor.getModifiers())) {
            constructor.setAccessible(true);
            return Mockito.mock(type, settings.spiedInstance(constructor.newInstance(new Object[0])));
        }
        return Mockito.mock(type, settings.useConstructor(new Object[0]));
    }

    private static Constructor<?> noArgConstructorOf(Class<?> type) {
        Constructor<?> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MockitoException("Please ensure that the type '" + type.getSimpleName() + "' has a no-arg constructor.");
        }
        return constructor;
    }

    private static boolean typeIsNonStaticInnerClass(Class<?> type, int modifiers) {
        return !Modifier.isStatic(modifiers) && type.getEnclosingClass() != null;
    }

    private static boolean typeIsPrivateAbstractInnerClass(Class<?> type, int modifiers) {
        return Modifier.isPrivate(modifiers) && Modifier.isAbstract(modifiers) && type.getEnclosingClass() != null;
    }

    private static void assertNoIncompatibleAnnotations(Class<? extends Annotation> annotation, Field field, Class<? extends Annotation> ... undesiredAnnotations) {
        for (Class<? extends Annotation> u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            throw Reporter.unsupportedCombinationOfAnnotations(annotation.getSimpleName(), u.getSimpleName());
        }
    }
}

