/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.Size;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JAnnotationUse;
import org.apache.hadoop.shaded.com.sun.codemodel.JFieldVar;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;

public class MinItemsMaxItemsRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected MinItemsMaxItemsRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && (node.has("minItems") || node.has("maxItems")) && this.isApplicableType(field)) {
            JAnnotationUse annotation = field.annotate(Size.class);
            if (node.has("minItems")) {
                annotation.param("min", node.get("minItems").asInt());
            }
            if (node.has("maxItems")) {
                annotation.param("max", node.get("maxItems").asInt());
            }
        }
        return field;
    }

    private boolean isApplicableType(JFieldVar field) {
        try {
            Class<?> fieldClass;
            String typeName = field.type().boxify().fullName();
            int genericsPos = typeName.indexOf(60);
            if (genericsPos > -1) {
                typeName = typeName.substring(0, genericsPos);
            }
            return String.class.isAssignableFrom(fieldClass = Class.forName(typeName)) || Collection.class.isAssignableFrom(fieldClass) || Map.class.isAssignableFrom(fieldClass) || Array.class.isAssignableFrom(fieldClass) || field.type().isArray();
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

