/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.format;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.ojalgo.type.format.DateStyle;

public enum DatePart {
    DATE,
    DATETIME,
    TIME;


    public Format getFormat() {
        return this.getFormat(DateStyle.SHORT, Locale.getDefault());
    }

    public Format getFormat(DateStyle style) {
        return this.getFormat(style, Locale.getDefault());
    }

    public Format getFormat(DateStyle style, Locale locale) {
        DateStyle tmpStyle = style != null ? style : DateStyle.SHORT;
        Locale tmpLocale = locale != null ? locale : Locale.getDefault();
        switch (tmpStyle) {
            case SQL: {
                switch (this) {
                    case DATE: {
                        return new SimpleDateFormat("yyyy-MM-dd");
                    }
                    case TIME: {
                        return new SimpleDateFormat("HH:mm:ss");
                    }
                }
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        }
        switch (this) {
            case DATE: {
                return DateFormat.getDateInstance(tmpStyle.intValue(), tmpLocale);
            }
            case TIME: {
                return DateFormat.getTimeInstance(tmpStyle.intValue(), tmpLocale);
            }
        }
        return DateFormat.getDateTimeInstance(tmpStyle.intValue(), tmpStyle.intValue(), tmpLocale);
    }

    public Format getFormat(Locale locale) {
        return this.getFormat(DateStyle.SHORT, locale);
    }
}

