/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.rx.Transformers;
import com.github.davidmoten.rx.util.BackpressureStrategy;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func2;
import rx.functions.Func3;

public final class StateMachine {
    private StateMachine() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class CompletionAlwaysTrueHolder {
        private static final Completion<Object, Object> INSTANCE = new Completion<Object, Object>(){

            @Override
            public Boolean call(Object t1, Subscriber<Object> t2) {
                return true;
            }
        };

        private CompletionAlwaysTrueHolder() {
        }

        static <State, Out> Completion<State, Out> instance() {
            return INSTANCE;
        }
    }

    public static final class Builder3<State, In, Out> {
        private final Func0<State> initialState;
        private final Transition<State, In, Out> transition;
        private Completion<State, Out> completion = CompletionAlwaysTrueHolder.instance();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;
        private int initialRequest = 1;

        private Builder3(Func0<State> initialState, Transition<State, In, Out> transition) {
            this.initialState = initialState;
            this.transition = transition;
        }

        public Builder3<State, In, Out> completion(Completion<State, Out> completion) {
            this.completion = completion;
            return this;
        }

        public Builder3<State, In, Out> backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Builder3<State, In, Out> initialRequest(int value) {
            this.initialRequest = value;
            return this;
        }

        public Observable.Transformer<In, Out> build() {
            return Transformers.stateMachine(this.initialState, this.transition, this.completion, this.backpressureStrategy, this.initialRequest);
        }
    }

    public static final class Builder2<State> {
        private final Func0<State> initialState;

        private Builder2(Func0<State> initialState) {
            this.initialState = initialState;
        }

        public <In, Out> Builder3<State, In, Out> transition(Transition<State, In, Out> transition) {
            return new Builder3(this.initialState, transition);
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public <State> Builder2<State> initialStateFactory(Func0<State> initialState) {
            return new Builder2(initialState);
        }

        public <State> Builder2<State> initialState(State initialState) {
            return new Builder2(Functions.constant0(initialState));
        }
    }

    public static interface Completion<State, Out>
    extends Func2<State, Subscriber<Out>, Boolean> {
        public Boolean call(State var1, Subscriber<Out> var2);
    }

    public static interface Transition<State, In, Out>
    extends Func3<State, In, Subscriber<Out>, State> {
        public State call(State var1, In var2, Subscriber<Out> var3);
    }
}

