/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DistCpContext {
    private final DistCpOptions options;
    private List<Path> sourcePaths;
    private boolean targetPathExists = true;
    private boolean preserveRawXattrs = false;

    public DistCpContext(DistCpOptions options) {
        this.options = options;
        this.sourcePaths = options.getSourcePaths();
    }

    public void setSourcePaths(List<Path> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public List<Path> getSourcePaths() {
        return this.sourcePaths;
    }

    public Path getSourceFileListing() {
        return this.options.getSourceFileListing();
    }

    public Path getTargetPath() {
        return this.options.getTargetPath();
    }

    public boolean shouldAtomicCommit() {
        return this.options.shouldAtomicCommit();
    }

    public boolean shouldSyncFolder() {
        return this.options.shouldSyncFolder();
    }

    public boolean shouldDeleteMissing() {
        return this.options.shouldDeleteMissing();
    }

    public boolean shouldIgnoreFailures() {
        return this.options.shouldIgnoreFailures();
    }

    public boolean shouldOverwrite() {
        return this.options.shouldOverwrite();
    }

    public boolean shouldAppend() {
        return this.options.shouldAppend();
    }

    public boolean shouldSkipCRC() {
        return this.options.shouldSkipCRC();
    }

    public boolean shouldBlock() {
        return this.options.shouldBlock();
    }

    public boolean shouldUseDiff() {
        return this.options.shouldUseDiff();
    }

    public boolean shouldUseRdiff() {
        return this.options.shouldUseRdiff();
    }

    public boolean shouldUseSnapshotDiff() {
        return this.options.shouldUseSnapshotDiff();
    }

    public String getFromSnapshot() {
        return this.options.getFromSnapshot();
    }

    public String getToSnapshot() {
        return this.options.getToSnapshot();
    }

    public final String getFiltersFile() {
        return this.options.getFiltersFile();
    }

    public int getNumListstatusThreads() {
        return this.options.getNumListstatusThreads();
    }

    public int getMaxMaps() {
        return this.options.getMaxMaps();
    }

    public float getMapBandwidth() {
        return this.options.getMapBandwidth();
    }

    public Set<DistCpOptions.FileAttribute> getPreserveAttributes() {
        return this.options.getPreserveAttributes();
    }

    public boolean shouldPreserve(DistCpOptions.FileAttribute attribute) {
        return this.options.shouldPreserve(attribute);
    }

    public boolean shouldPreserveRawXattrs() {
        return this.preserveRawXattrs;
    }

    public void setPreserveRawXattrs(boolean preserveRawXattrs) {
        this.preserveRawXattrs = preserveRawXattrs;
    }

    public Path getAtomicWorkPath() {
        return this.options.getAtomicWorkPath();
    }

    public Path getLogPath() {
        return this.options.getLogPath();
    }

    public String getCopyStrategy() {
        return this.options.getCopyStrategy();
    }

    public int getBlocksPerChunk() {
        return this.options.getBlocksPerChunk();
    }

    public boolean shouldUseIterator() {
        return this.options.shouldUseIterator();
    }

    public boolean shouldUpdateRoot() {
        return this.options.shouldUpdateRoot();
    }

    public final boolean splitLargeFile() {
        return this.options.getBlocksPerChunk() > 0;
    }

    public int getCopyBufferSize() {
        return this.options.getCopyBufferSize();
    }

    public boolean shouldDirectWrite() {
        return this.options.shouldDirectWrite();
    }

    public void setTargetPathExists(boolean targetPathExists) {
        this.targetPathExists = targetPathExists;
    }

    public boolean isTargetPathExists() {
        return this.targetPathExists;
    }

    public void appendToConf(Configuration conf) {
        this.options.appendToConf(conf);
    }

    public String toString() {
        return this.options.toString() + ", sourcePaths=" + this.sourcePaths + ", targetPathExists=" + this.targetPathExists + ", preserveRawXattrs=" + this.preserveRawXattrs;
    }
}

