/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

public final class FairSchedulerUtilities {
    static final String WHITESPACE_TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";

    private FairSchedulerUtilities() {
    }

    private static boolean isWhitespace(char c) {
        for (int i = 0; i < WHITESPACE_TABLE.length(); ++i) {
            if (WHITESPACE_TABLE.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static String trimQueueName(String name) {
        int end;
        int start;
        if (name == null) {
            return null;
        }
        for (start = 0; start < name.length() && FairSchedulerUtilities.isWhitespace(name.charAt(start)) && start < name.length(); ++start) {
        }
        for (end = name.length() - 1; end >= 0 && FairSchedulerUtilities.isWhitespace(name.charAt(end)) && end > start; --end) {
        }
        return name.substring(start, end + 1);
    }
}

