/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTracker;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTrackerUtils;
import org.apache.hadoop.fs.s3a.statistics.PutTrackerStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.util.Preconditions;
import software.amazon.awssdk.services.s3.model.CompletedPart;

public class InMemoryMagicCommitTracker
extends MagicCommitTracker {
    private static final Map<String, List<SinglePendingCommit>> TASK_ATTEMPT_ID_TO_MPU_METADATA = new ConcurrentHashMap<String, List<SinglePendingCommit>>();
    private static final Map<Path, Long> PATH_TO_BYTES_WRITTEN = new ConcurrentHashMap<Path, Long>();
    private static final Map<String, List<Path>> TASK_ATTEMPT_ID_TO_PATH = new ConcurrentHashMap<String, List<Path>>();

    public InMemoryMagicCommitTracker(Path path, String bucket, String originalDestKey, String destKey, String pendingsetKey, WriteOperationHelper writer, PutTrackerStatistics trackerStatistics) {
        super(path, bucket, originalDestKey, destKey, pendingsetKey, writer, trackerStatistics);
    }

    @Override
    public boolean aboutToComplete(String uploadId, List<CompletedPart> parts, long bytesWritten, IOStatistics iostatistics) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)uploadId), (Object)("empty/null upload ID: " + uploadId));
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (Object)"No uploaded parts list");
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0, (Object)"No uploaded parts to save");
        SinglePendingCommit commitData = new SinglePendingCommit();
        commitData.touch(System.currentTimeMillis());
        commitData.setDestinationKey(this.getDestKey());
        commitData.setBucket(this.getBucket());
        commitData.setUri(this.getPath().toUri().toString());
        commitData.setUploadId(uploadId);
        commitData.setText("");
        commitData.setLength(bytesWritten);
        commitData.bindCommitData(parts);
        commitData.setIOStatistics(new IOStatisticsSnapshot(iostatistics));
        String taskAttemptId = MagicCommitTrackerUtils.extractTaskAttemptIdFromPath(this.getPath());
        TASK_ATTEMPT_ID_TO_MPU_METADATA.computeIfAbsent(taskAttemptId, k -> Collections.synchronizedList(new ArrayList())).add(commitData);
        PATH_TO_BYTES_WRITTEN.put(this.getPath(), bytesWritten);
        TASK_ATTEMPT_ID_TO_PATH.computeIfAbsent(taskAttemptId, k -> Collections.synchronizedList(new ArrayList())).add(this.getPath());
        LOG.info("commit metadata for {} parts in {}. size: {} byte(s) for the taskAttemptId: {} is stored in memory", new Object[]{parts.size(), this.getPendingPartKey(), bytesWritten, taskAttemptId});
        LOG.debug("Closed MPU to {}, saved commit information to {}; data=:\n{}", new Object[]{this.getPath(), this.getPendingPartKey(), commitData});
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InMemoryMagicCommitTracker{");
        sb.append(", Number of taskAttempts=").append(TASK_ATTEMPT_ID_TO_MPU_METADATA.size());
        sb.append(", Number of files=").append(PATH_TO_BYTES_WRITTEN.size());
        sb.append('}');
        return sb.toString();
    }

    public static Map<String, List<SinglePendingCommit>> getTaskAttemptIdToMpuMetadata() {
        return TASK_ATTEMPT_ID_TO_MPU_METADATA;
    }

    public static Map<Path, Long> getPathToBytesWritten() {
        return PATH_TO_BYTES_WRITTEN;
    }

    public static Map<String, List<Path>> getTaskAttemptIdToPath() {
        return TASK_ATTEMPT_ID_TO_PATH;
    }
}

