/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.matrix.task.iterative.Equation;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.type.context.NumberContext;

abstract class IterativeSolverTask
implements SolverTask<Double> {
    static final NumberContext DEFAULT = NumberContext.getMath(MathContext.DECIMAL128);
    private BasicLogger.Printer myDebugPrinter = null;
    private int myIterationsLimit = Integer.MAX_VALUE;
    private NumberContext myAccuracyContext = DEFAULT;

    static List<Equation> toListOfRows(Access2D<?> body, Access2D<?> rhs) {
        int tmpDim = (int)body.countRows();
        ArrayList<Equation> retVal = new ArrayList<Equation>(tmpDim);
        for (int i = 0; i < tmpDim; ++i) {
            Equation tmpRow = new Equation(i, tmpDim, rhs.doubleValue(i));
            for (int j = 0; j < tmpDim; ++j) {
                double tmpVal = body.doubleValue(i, j);
                if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                tmpRow.set((long)j, tmpVal);
            }
            retVal.add(tmpRow);
        }
        return retVal;
    }

    IterativeSolverTask() {
    }

    public final Configurator configurator() {
        return new Configurator(this);
    }

    @Override
    public final PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        if (templateRHS.countColumns() != 1L) {
            throw new IllegalArgumentException("The RHS must have precisely 1 column!");
        }
        return (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero(templateRHS.countRows(), 1L);
    }

    @Override
    public final Optional<MatrixStore<Double>> solve(MatrixStore<Double> body, MatrixStore<Double> rhs) {
        try {
            return Optional.of(this.solve(body, rhs, this.preallocate(body, rhs)));
        }
        catch (TaskException xcptn) {
            return Optional.empty();
        }
    }

    protected final void debug(int iteration, Access1D<?> current) {
        if (this.myDebugPrinter != null) {
            this.myDebugPrinter.println("{}: {}", iteration, Array1D.PRIMITIVE64.copy((Access1D)current));
        }
    }

    protected final NumberContext getAccuracyContext() {
        return this.myAccuracyContext;
    }

    protected final int getIterationsLimit() {
        return this.myIterationsLimit;
    }

    protected final boolean isDebugPrinterSet() {
        return this.myDebugPrinter != null;
    }

    protected void setAccuracyContext(NumberContext accuracyContext) {
        this.myAccuracyContext = accuracyContext;
    }

    protected void setDebugPrinter(BasicLogger.Printer debugPrinter) {
        this.myDebugPrinter = debugPrinter;
    }

    protected void setIterationsLimit(int iterationsLimit) {
        this.myIterationsLimit = iterationsLimit;
    }

    static interface SparseDelegate {
        public double resolve(List<Equation> var1, PhysicalStore<Double> var2);
    }

    public static final class Configurator {
        private final IterativeSolverTask mySolver;

        private Configurator() {
            this(null);
        }

        Configurator(IterativeSolverTask solver) {
            this.mySolver = solver;
        }

        public Configurator accuracy(NumberContext accuray) {
            if (accuray != null) {
                this.mySolver.setAccuracyContext(accuray);
            } else {
                this.mySolver.setAccuracyContext(DEFAULT);
            }
            return this;
        }

        public Configurator debug(BasicLogger.Printer printer) {
            this.mySolver.setDebugPrinter(printer);
            return this;
        }

        public Configurator iterations(int iterations) {
            this.mySolver.setIterationsLimit(iterations);
            return this;
        }
    }
}

