/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.AbstractSolver;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.scalar.ComplexNumber;

public interface SolverTask<N extends Number>
extends MatrixTask<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public SolverTask<BigDecimal> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.BIG.make(templateBody);
                }
                return (SolverTask)LU.BIG.make(templateBody);
            }
            if (templateBody.isTall()) {
                return (SolverTask)QR.BIG.make(templateBody);
            }
            return (SolverTask)SingularValue.BIG.make(templateBody);
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public SolverTask<ComplexNumber> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.COMPLEX.make(templateBody);
                }
                return (SolverTask)LU.COMPLEX.make(templateBody);
            }
            if (templateBody.isTall()) {
                return (SolverTask)QR.COMPLEX.make(templateBody);
            }
            return (SolverTask)SingularValue.COMPLEX.make(templateBody);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public SolverTask<Double> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            boolean tmpVectorRHS = templateRHS.countColumns() == 1L;
            long tmpColDim = templateBody.countColumns();
            if (templateBody.isSquare()) {
                if (symmetric) {
                    if (!tmpVectorRHS) {
                        return positiveDefinite ? (SolverTask)Cholesky.PRIMITIVE.make(templateBody) : (SolverTask)LU.PRIMITIVE.make(templateBody);
                    }
                    if (tmpColDim == 1L) {
                        return AbstractSolver.FULL_1X1;
                    }
                    if (tmpColDim == 2L) {
                        return AbstractSolver.SYMMETRIC_2X2;
                    }
                    if (tmpColDim == 3L) {
                        return AbstractSolver.SYMMETRIC_3X3;
                    }
                    if (tmpColDim == 4L) {
                        return AbstractSolver.SYMMETRIC_4X4;
                    }
                    if (tmpColDim == 5L) {
                        return AbstractSolver.SYMMETRIC_5X5;
                    }
                    return positiveDefinite ? (SolverTask)Cholesky.PRIMITIVE.make(templateBody) : (SolverTask)LU.PRIMITIVE.make(templateBody);
                }
                if (!tmpVectorRHS) {
                    return (SolverTask)LU.PRIMITIVE.make(templateBody);
                }
                if (tmpColDim == 1L) {
                    return AbstractSolver.FULL_1X1;
                }
                if (tmpColDim == 2L) {
                    return AbstractSolver.FULL_2X2;
                }
                if (tmpColDim == 3L) {
                    return AbstractSolver.FULL_3X3;
                }
                if (tmpColDim == 4L) {
                    return AbstractSolver.FULL_4X4;
                }
                if (tmpColDim == 5L) {
                    return AbstractSolver.FULL_5X5;
                }
                return (SolverTask)LU.PRIMITIVE.make(templateBody);
            }
            if (templateBody.isTall()) {
                if (tmpVectorRHS && tmpColDim <= 5L) {
                    return AbstractSolver.LEAST_SQUARES;
                }
                return (SolverTask)QR.PRIMITIVE.make(templateBody);
            }
            return (SolverTask)SingularValue.PRIMITIVE.make(templateBody);
        }
    };

    public PhysicalStore<N> preallocate(Structure2D var1, Structure2D var2);

    default public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws TaskException {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    public MatrixStore<N> solve(Access2D<?> var1, Access2D<?> var2, PhysicalStore<N> var3) throws TaskException;

    public static abstract class Factory<N extends Number> {
        public final SolverTask<N> make(MatrixStore<N> templateBody, MatrixStore<N> templateRHS) {
            return this.make(templateBody, templateRHS, MatrixUtils.isHermitian(templateBody), false);
        }

        public abstract SolverTask<N> make(Structure2D var1, Structure2D var2, boolean var3, boolean var4);
    }
}

