/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.stream.LongStream;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.ElementView1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.DenseStrategy;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.StrategyBuilder;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class SparseArray<N extends Number>
extends BasicArray<N> {
    static final NumberContext MATH_CONTEXT = NumberContext.getMath(MathContext.DECIMAL64);
    private int myActualLength = 0;
    private final long myCount;
    private long[] myIndices;
    private final DenseStrategy<N> myStrategy;
    private DenseArray<N> myValues;
    private final N myZeroNumber;
    private final Scalar<N> myZeroScalar;
    private final double myZeroValue;

    public static <N extends Number> SparseFactory<N> factory(DenseArray.Factory<N> denseFactory, long count) {
        return new SparseFactory<N>(denseFactory, count);
    }

    @Deprecated
    public static SparseArray<BigDecimal> makeBig(long count) {
        return ((SparseFactory)SparseArray.factory(BigArray.FACTORY, count).initial(DenseStrategy.capacity(count))).make();
    }

    @Deprecated
    public static SparseArray<BigDecimal> makeBig(long count, int initialCapacity) {
        return ((SparseFactory)SparseArray.factory(BigArray.FACTORY, count).initial(initialCapacity)).make();
    }

    @Deprecated
    public static SparseArray<ComplexNumber> makeComplex(long count) {
        return ((SparseFactory)SparseArray.factory(ComplexArray.FACTORY, count).initial(DenseStrategy.capacity(count))).make();
    }

    @Deprecated
    public static SparseArray<ComplexNumber> makeComplex(long count, int initialCapacity) {
        return ((SparseFactory)SparseArray.factory(ComplexArray.FACTORY, count).initial(initialCapacity)).make();
    }

    @Deprecated
    public static SparseArray<Double> makePrimitive(long count) {
        return ((SparseFactory)SparseArray.factory(Primitive64Array.FACTORY, count).initial(DenseStrategy.capacity(count))).make();
    }

    @Deprecated
    public static SparseArray<Double> makePrimitive(long count, int initialCapacity) {
        return ((SparseFactory)SparseArray.factory(Primitive64Array.FACTORY, count).initial(initialCapacity)).make();
    }

    @Deprecated
    public static SparseArray<Quaternion> makeQuaternion(long count) {
        return ((SparseFactory)SparseArray.factory(QuaternionArray.FACTORY, count).initial(DenseStrategy.capacity(count))).make();
    }

    @Deprecated
    public static SparseArray<Quaternion> makeQuaternion(long count, int initialCapacity) {
        return ((SparseFactory)SparseArray.factory(QuaternionArray.FACTORY, count).initial(initialCapacity)).make();
    }

    @Deprecated
    public static SparseArray<RationalNumber> makeRational(long count) {
        return ((SparseFactory)SparseArray.factory(RationalArray.FACTORY, count).initial(DenseStrategy.capacity(count))).make();
    }

    @Deprecated
    public static SparseArray<RationalNumber> makeRational(long count, int initialCapacity) {
        return ((SparseFactory)SparseArray.factory(RationalArray.FACTORY, count).initial(initialCapacity)).make();
    }

    SparseArray(long count, DenseStrategy<N> strategy) {
        this.myCount = count;
        this.myStrategy = strategy;
        this.myIndices = new long[strategy.initial()];
        this.myValues = strategy.makeInitial();
        this.myZeroScalar = strategy.scalar().zero();
        this.myZeroNumber = this.myZeroScalar.getNumber();
        this.myZeroValue = ((Number)this.myZeroNumber).doubleValue();
    }

    @Override
    public void add(long index, double addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add((long)tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public void add(long index, Number addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add((long)tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public void axpy(double a, Mutate1D y) {
        for (int n = 0; n < this.myActualLength; ++n) {
            y.add(this.myIndices[n], a * this.myValues.doubleValue(n));
        }
    }

    @Override
    public final long count() {
        return this.myCount;
    }

    @Override
    public double dot(Access1D<?> vector) {
        double retVal = PrimitiveMath.ZERO;
        for (int n = 0; n < this.myActualLength; ++n) {
            retVal += this.myValues.doubleValue(n) * vector.doubleValue(this.myIndices[n]);
        }
        return retVal;
    }

    @Override
    public double doubleValue(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.doubleValueInternally(tmpIndex);
        }
        return this.myZeroValue;
    }

    @Override
    public void fillAll(N value) {
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, ((Number)value).doubleValue())) {
            this.myValues.fillAll(this.myZeroNumber);
        } else {
            int tmpSize = (int)this.count();
            if (tmpSize != this.myIndices.length) {
                this.myIndices = AccessUtils.makeIncreasingRange(0L, tmpSize);
                this.myValues = this.myStrategy.make(tmpSize);
                this.myActualLength = tmpSize;
            }
            this.myValues.fillAll(value);
        }
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        int tmpSize = (int)this.count();
        if (tmpSize != this.myIndices.length) {
            this.myIndices = AccessUtils.makeIncreasingRange(0L, tmpSize);
            this.myValues = this.myStrategy.make(tmpSize);
            this.myActualLength = tmpSize;
        }
        this.myValues.fillAll(supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        if (this.isPrimitive()) {
            this.set(index, values.doubleValue(valueIndex));
        } else {
            this.set(index, (Number)values.get(valueIndex));
        }
    }

    @Override
    public void fillOne(long index, N value) {
        this.set(index, (Number)value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.set(index, (Number)supplier.get());
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.fill(first, limit, 1L, supplier);
    }

    public long firstInRange(long rangeFirst, long rangeLimit) {
        int tmpFoundAt = this.index(rangeFirst);
        if (tmpFoundAt < 0) {
            tmpFoundAt = -tmpFoundAt + 1;
        }
        if (tmpFoundAt >= this.myActualLength) {
            return rangeLimit;
        }
        return Math.min(this.myIndices[tmpFoundAt], rangeLimit);
    }

    @Override
    public N get(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.getInternally(tmpIndex);
        }
        return this.myZeroNumber;
    }

    @Override
    public boolean isAbsolute(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.isAbsolute(tmpIndex);
        }
        return true;
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.isSmall(tmpIndex, comparedTo);
        }
        return true;
    }

    public long limitOfRange(long rangeFirst, long rangeLimit) {
        int tmpFoundAt = this.index(rangeLimit - 1L);
        if (tmpFoundAt < 0) {
            tmpFoundAt = -tmpFoundAt;
        }
        if (tmpFoundAt >= this.myActualLength) {
            return rangeFirst;
        }
        return Math.min(this.myIndices[tmpFoundAt] + 1L, rangeLimit);
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        double tmpZeroValue = modifier.invoke(this.myZeroValue);
        if (MATH_CONTEXT.isDifferent(this.myZeroValue, tmpZeroValue)) {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
        this.myValues.modifyAll(modifier);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.set(index, (Number)modifier.invoke(this.get(index)));
    }

    public NonzeroView<N> nonzeros() {
        return new NonzeroView<N>(this.myIndices, this.myValues, this.myActualLength);
    }

    @Override
    public void reset() {
        this.myActualLength = 0;
        this.myValues.reset();
    }

    @Override
    public void set(long index, double value) {
        int tmpIndex = this.index(index);
        this.doSet(index, tmpIndex, value, false);
    }

    @Override
    public void set(long index, Number value) {
        int tmpIndex = this.index(index);
        this.doSet(index, tmpIndex, value, false);
    }

    public void supplyNonZerosTo(Mutate1D consumer) {
        if (this.isPrimitive()) {
            for (int n = 0; n < this.myActualLength; ++n) {
                consumer.set(this.myIndices[n], this.myValues.doubleValue(n));
            }
        } else {
            for (int n = 0; n < this.myActualLength; ++n) {
                consumer.set(this.myIndices[n], (Number)this.myValues.get(n));
            }
        }
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (this.isPrimitive()) {
            visitor.invoke(this.doubleValue(index));
        } else {
            visitor.invoke(this.get(index));
        }
    }

    @Override
    protected void exchange(long firstA, long firstB, long step, long count) {
        if (this.isPrimitive()) {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                double tmpVal = this.doubleValue(tmpIndexA);
                this.set(tmpIndexA, this.doubleValue(tmpIndexB));
                this.set(tmpIndexB, tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        } else {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                N tmpVal = this.get(tmpIndexA);
                this.set(tmpIndexA, (Number)this.get(tmpIndexB));
                this.set(tmpIndexB, (Number)tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, N value) {
        int tmpLimit;
        int tmpFirst = this.index(first);
        if (tmpFirst < 0) {
            tmpFirst = -tmpFirst + 1;
        }
        if ((tmpLimit = this.index(limit)) < 0) {
            tmpLimit = -tmpLimit + 1;
        }
        if (this.isPrimitive()) {
            double tmpValue = ((Number)value).doubleValue();
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set((long)i, tmpValue);
            }
        } else {
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set((long)i, (Number)value);
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, NullaryFunction<N> supplier) {
        int tmpLimit;
        int tmpFirst = this.index(first);
        if (tmpFirst < 0) {
            tmpFirst = -tmpFirst + 1;
        }
        if ((tmpLimit = this.index(limit)) < 0) {
            tmpLimit = -tmpLimit + 1;
        }
        if (this.isPrimitive()) {
            double tmpValue = supplier.doubleValue();
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set((long)i, tmpValue);
            }
        } else {
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set((long)i, (Number)supplier.invoke());
            }
        }
    }

    @Override
    protected long indexOfLargest(long first, long limit, long step) {
        long retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myIndices.length; ++i) {
            double tmpValue;
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L || !((tmpValue = PrimitiveFunction.ABS.invoke(this.myValues.doubleValue(i))) > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isSmall(long first, long limit, long step, double comparedTo) {
        boolean retVal = true;
        for (int i = 0; retVal && i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
            retVal &= this.myValues.isSmall(i, comparedTo);
        }
        return retVal;
    }

    @Override
    protected void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpZeroValue)) {
            for (int i = 0; i < this.myIndices.length; ++i) {
                long tmpIndex = this.myIndices[i];
                if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
                this.myValues.modify(tmpIndex, i, left, function);
            }
        } else {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
    }

    @Override
    protected void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpZeroValue)) {
            for (int i = 0; i < this.myIndices.length; ++i) {
                long tmpIndex = this.myIndices[i];
                if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
                this.myValues.modify(tmpIndex, i, function, right);
            }
        } else {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
    }

    @Override
    protected void modify(long first, long limit, long step, UnaryFunction<N> function) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO);
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpZeroValue)) {
            for (int i = 0; i < this.myIndices.length; ++i) {
                long tmpIndex = this.myIndices[i];
                if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
                this.myValues.modify(tmpIndex, i, function);
            }
        } else {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
    }

    @Override
    protected void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        boolean tmpOnlyOnce = true;
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex >= first && tmpIndex < limit && (tmpIndex - first) % step == 0L) {
                this.myValues.visitOne(i, visitor);
                continue;
            }
            if (!tmpOnlyOnce) continue;
            visitor.invoke(this.myZeroValue);
            tmpOnlyOnce = false;
        }
    }

    long capacity() {
        return this.myValues.count();
    }

    final DenseArray<N> densify() {
        DenseArray<N> retVal = this.myStrategy.make((int)this.count());
        if (this.isPrimitive()) {
            for (int i = 0; i < this.myActualLength; ++i) {
                retVal.set(this.myIndices[i], this.myValues.doubleValue(i));
            }
        } else {
            for (int i = 0; i < this.myActualLength; ++i) {
                retVal.set(this.myIndices[i], (Number)this.myValues.get(i));
            }
        }
        return retVal;
    }

    void doSet(long externalIndex, int internalIndex, double value, boolean shouldStoreZero) {
        if (internalIndex >= 0) {
            this.myValues.set((long)internalIndex, value);
        } else if (shouldStoreZero || Double.compare(value, PrimitiveMath.ZERO) != 0) {
            int tmpInsInd = -(internalIndex + 1);
            if (this.myActualLength + 1 <= this.myIndices.length) {
                for (int i = this.myActualLength; i > tmpInsInd; --i) {
                    this.myIndices[i] = this.myIndices[i - 1];
                    this.myValues.set((long)i, this.myValues.doubleValue(i - 1));
                }
                this.myIndices[tmpInsInd] = externalIndex;
                this.myValues.set((long)tmpInsInd, value);
                ++this.myActualLength;
            } else {
                int i;
                int tmpCapacity = this.myStrategy.grow(this.myIndices.length);
                long[] tmpIndices = new long[tmpCapacity];
                DenseArray<N> tmpValues = this.myStrategy.make(tmpCapacity);
                for (i = 0; i < tmpInsInd; ++i) {
                    tmpIndices[i] = this.myIndices[i];
                    tmpValues.set((long)i, this.myValues.doubleValue(i));
                }
                tmpIndices[tmpInsInd] = externalIndex;
                tmpValues.set((long)tmpInsInd, value);
                for (i = tmpInsInd; i < this.myIndices.length; ++i) {
                    tmpIndices[i + 1] = this.myIndices[i];
                    tmpValues.set((long)(i + 1), this.myValues.doubleValue(i));
                }
                for (i = this.myIndices.length + 1; i < tmpIndices.length; ++i) {
                    tmpIndices[i] = Long.MAX_VALUE;
                }
                this.myIndices = tmpIndices;
                this.myValues = tmpValues;
                ++this.myActualLength;
            }
        }
    }

    void doSet(long externalIndex, int internalIndex, Number value, boolean shouldStoreZero) {
        if (internalIndex >= 0) {
            this.myValues.set((long)internalIndex, value);
        } else if (shouldStoreZero || !value.equals(this.myZeroNumber)) {
            int tmpInsInd = -(internalIndex + 1);
            if (this.myActualLength + 1 <= this.myIndices.length) {
                for (int i = this.myActualLength; i > tmpInsInd; --i) {
                    this.myIndices[i] = this.myIndices[i - 1];
                    this.myValues.set((long)i, (Number)this.myValues.get(i - 1));
                }
                this.myIndices[tmpInsInd] = externalIndex;
                this.myValues.set((long)tmpInsInd, value);
                ++this.myActualLength;
            } else {
                int i;
                int tmpCapacity = this.myStrategy.grow(this.myIndices.length);
                long[] tmpIndices = new long[tmpCapacity];
                DenseArray<N> tmpValues = this.myStrategy.make(tmpCapacity);
                for (i = 0; i < tmpInsInd; ++i) {
                    tmpIndices[i] = this.myIndices[i];
                    tmpValues.set((long)i, (Number)this.myValues.get(i));
                }
                tmpIndices[tmpInsInd] = externalIndex;
                tmpValues.set((long)tmpInsInd, value);
                for (i = tmpInsInd; i < this.myIndices.length; ++i) {
                    tmpIndices[i + 1] = this.myIndices[i];
                    tmpValues.set((long)(i + 1), (Number)this.myValues.get(i));
                }
                for (i = this.myIndices.length + 1; i < tmpIndices.length; ++i) {
                    tmpIndices[i] = Long.MAX_VALUE;
                }
                this.myIndices = tmpIndices;
                this.myValues = tmpValues;
                ++this.myActualLength;
            }
        }
    }

    double doubleValueInternally(int internalIndex) {
        return this.myValues.doubleValue(internalIndex);
    }

    long firstIndex() {
        return this.myIndices[0];
    }

    int getActualLength() {
        return this.myActualLength;
    }

    N getInternally(int internalIndex) {
        return this.myValues.get(internalIndex);
    }

    DenseArray<N> getValues() {
        return this.myValues;
    }

    Access1D<N> getValues(long fromIncl, long toExcl) {
        int tmpFromIncl = this.index(fromIncl);
        if (tmpFromIncl < 0) {
            tmpFromIncl = -(tmpFromIncl + 1);
        }
        final int tmpFirst = tmpFromIncl;
        int tmpToExcl = this.index(toExcl);
        if (tmpToExcl < 0) {
            tmpToExcl = -(tmpToExcl + 1);
        }
        final int tmpLimit = tmpToExcl;
        return new Access1D<N>(){

            @Override
            public long count() {
                return tmpLimit - tmpFirst;
            }

            @Override
            public double doubleValue(long index) {
                return SparseArray.this.myValues.doubleValue((long)tmpFirst + index);
            }

            @Override
            public N get(long index) {
                return SparseArray.this.myValues.get((long)tmpFirst + index);
            }
        };
    }

    final int index(long index) {
        return Arrays.binarySearch(this.myIndices, 0, this.myActualLength, index);
    }

    final LongStream indices() {
        return Arrays.stream(this.myIndices, 0, this.myActualLength);
    }

    @Override
    boolean isPrimitive() {
        return this.myValues.isPrimitive();
    }

    long lastIndex() {
        return this.myIndices[this.myActualLength - 1];
    }

    public static final class SparseFactory<N extends Number>
    extends StrategyBuilder<N, SparseArray<N>, SparseFactory<N>> {
        private final long myCount;

        SparseFactory(DenseArray.Factory<N> denseFactory, long count) {
            super(denseFactory);
            this.myCount = count;
        }

        @Override
        public SparseArray<N> make() {
            return new SparseArray(this.myCount, this.getStrategy());
        }
    }

    public static final class NonzeroView<N extends Number>
    implements ElementView1D<N, NonzeroView<N>> {
        private int myCursor = -1;
        private final long[] myIndices;
        private final int myLastCursor;
        private final DenseArray<N> myValues;

        NonzeroView(long[] indices, DenseArray<N> values, int actualLength) {
            this.myIndices = indices;
            this.myValues = values;
            this.myLastCursor = actualLength - 1;
        }

        @Override
        public double doubleValue() {
            return this.myValues.doubleValue(this.myCursor);
        }

        @Override
        public N getNumber() {
            return this.myValues.get(this.myCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < this.myLastCursor;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0;
        }

        @Override
        public long index() {
            return this.myIndices[this.myCursor];
        }

        @Override
        public NonzeroView<N> next() {
            ++this.myCursor;
            return this;
        }

        @Override
        public NonzeroView<N> previous() {
            --this.myCursor;
            return this;
        }
    }
}

