/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestDelegationTokenRenewer {
    private static final long RENEW_CYCLE = 1000L;
    private DelegationTokenRenewer renewer;
    Configuration conf;
    FileSystem fs;

    @Before
    public void setup() {
        DelegationTokenRenewer.renewCycle = 1000L;
        DelegationTokenRenewer.reset();
        this.renewer = DelegationTokenRenewer.getInstance();
    }

    @Test
    public void testAddRemoveRenewAction() throws IOException, InterruptedException {
        Text service = new Text("myservice");
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Token token = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)service).when((Object)token)).getService();
        ((Token)Mockito.doAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) {
                return Time.now() + 1000L;
            }
        }).when((Object)token)).renew((Configuration)Mockito.any(Configuration.class));
        RenewableFileSystem fs = (RenewableFileSystem)((Object)Mockito.mock(RenewableFileSystem.class));
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)conf).when((Object)fs))).getConf();
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)token).when((Object)fs))).getRenewToken();
        this.renewer.addRenewAction((FileSystem)fs);
        Assert.assertEquals((String)"FileSystem not added to DelegationTokenRenewer", (long)1L, (long)this.renewer.getRenewQueueLength());
        Thread.sleep(2000L);
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeast((int)2))).renew((Configuration)Mockito.eq((Object)conf));
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.atMost((int)3))).renew((Configuration)Mockito.eq((Object)conf));
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.never())).cancel((Configuration)Mockito.any(Configuration.class));
        this.renewer.removeRenewAction((FileSystem)fs);
        ((Token)Mockito.verify((Object)token)).cancel((Configuration)Mockito.eq((Object)conf));
        ((RenewableFileSystem)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.never()))).getDelegationToken(null);
        ((RenewableFileSystem)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.never()))).setDelegationToken((Token)Mockito.any());
        Assert.assertEquals((String)"FileSystem not removed from DelegationTokenRenewer", (long)0L, (long)this.renewer.getRenewQueueLength());
    }

    @Test
    public void testAddRenewActionWithNoToken() throws IOException, InterruptedException {
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        RenewableFileSystem fs = (RenewableFileSystem)((Object)Mockito.mock(RenewableFileSystem.class));
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)conf).when((Object)fs))).getConf();
        ((RenewableFileSystem)((Object)Mockito.doReturn(null).when((Object)fs))).getRenewToken();
        this.renewer.addRenewAction((FileSystem)fs);
        ((RenewableFileSystem)((Object)Mockito.verify((Object)((Object)fs)))).getRenewToken();
        Assert.assertEquals((long)0L, (long)this.renewer.getRenewQueueLength());
    }

    @Test
    public void testGetNewTokenOnRenewFailure() throws IOException, InterruptedException {
        Text service = new Text("myservice");
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Token token1 = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)service).when((Object)token1)).getService();
        ((Token)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("boom")}).when((Object)token1)).renew((Configuration)Mockito.eq((Object)conf));
        final Token token2 = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)service).when((Object)token2)).getService();
        ((Token)Mockito.doAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) {
                return Time.now() + 1000L;
            }
        }).when((Object)token2)).renew((Configuration)Mockito.eq((Object)conf));
        RenewableFileSystem fs = (RenewableFileSystem)((Object)Mockito.mock(RenewableFileSystem.class));
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)conf).when((Object)fs))).getConf();
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)token1).doReturn((Object)token2).when((Object)fs))).getRenewToken();
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)token2).when((Object)fs))).getDelegationToken(null);
        ((RenewableFileSystem)((Object)Mockito.doAnswer((Answer)new Answer<Token<?>[]>(){

            public Token<?>[] answer(InvocationOnMock invocation) {
                return new Token[]{token2};
            }
        }).when((Object)fs))).addDelegationTokens(null, null);
        this.renewer.addRenewAction((FileSystem)fs);
        Assert.assertEquals((long)1L, (long)this.renewer.getRenewQueueLength());
        Thread.sleep(1000L);
        ((RenewableFileSystem)((Object)Mockito.verify((Object)((Object)fs)))).getRenewToken();
        ((Token)Mockito.verify((Object)token1, (VerificationMode)Mockito.atLeast((int)1))).renew((Configuration)Mockito.eq((Object)conf));
        ((Token)Mockito.verify((Object)token1, (VerificationMode)Mockito.atMost((int)2))).renew((Configuration)Mockito.eq((Object)conf));
        ((RenewableFileSystem)((Object)Mockito.verify((Object)((Object)fs)))).addDelegationTokens(null, null);
        ((RenewableFileSystem)((Object)Mockito.verify((Object)((Object)fs)))).setDelegationToken((Token)Mockito.eq((Object)token2));
        Assert.assertEquals((long)1L, (long)this.renewer.getRenewQueueLength());
        this.renewer.removeRenewAction((FileSystem)fs);
        ((Token)Mockito.verify((Object)token2)).cancel((Configuration)Mockito.eq((Object)conf));
        Assert.assertEquals((long)0L, (long)this.renewer.getRenewQueueLength());
    }

    @Test
    public void testStopRenewalWhenFsGone() throws IOException, InterruptedException {
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Token token = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)new Text("myservice")).when((Object)token)).getService();
        ((Token)Mockito.doAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) {
                return Time.now() + 1000L;
            }
        }).when((Object)token)).renew((Configuration)Mockito.any(Configuration.class));
        RenewableFileSystem fs = (RenewableFileSystem)((Object)Mockito.mock(RenewableFileSystem.class));
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)conf).when((Object)fs))).getConf();
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)token).when((Object)fs))).getRenewToken();
        this.renewer.addRenewAction((FileSystem)fs);
        Assert.assertEquals((long)1L, (long)this.renewer.getRenewQueueLength());
        Thread.sleep(1000L);
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeast((int)1))).renew((Configuration)Mockito.eq((Object)conf));
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.atMost((int)2))).renew((Configuration)Mockito.eq((Object)conf));
        fs = null;
        System.gc();
        System.gc();
        System.gc();
        Thread.sleep(1000L);
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeast((int)1))).renew((Configuration)Mockito.eq((Object)conf));
        ((Token)Mockito.verify((Object)token, (VerificationMode)Mockito.atMost((int)2))).renew((Configuration)Mockito.eq((Object)conf));
        Assert.assertEquals((long)0L, (long)this.renewer.getRenewQueueLength());
    }

    @Test(timeout=4000L)
    public void testMultipleTokensDoNotDeadlock() throws IOException, InterruptedException {
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)conf).when((Object)fs)).getConf();
        long distantFuture = Time.now() + 3600000L;
        Token token1 = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)new Text("myservice1")).when((Object)token1)).getService();
        ((Token)Mockito.doReturn((Object)distantFuture).when((Object)token1)).renew((Configuration)Mockito.eq((Object)conf));
        Token token2 = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)new Text("myservice2")).when((Object)token2)).getService();
        ((Token)Mockito.doReturn((Object)distantFuture).when((Object)token2)).renew((Configuration)Mockito.eq((Object)conf));
        RenewableFileSystem fs1 = (RenewableFileSystem)((Object)Mockito.mock(RenewableFileSystem.class));
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)conf).when((Object)fs1))).getConf();
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)token1).when((Object)fs1))).getRenewToken();
        RenewableFileSystem fs2 = (RenewableFileSystem)((Object)Mockito.mock(RenewableFileSystem.class));
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)conf).when((Object)fs2))).getConf();
        ((RenewableFileSystem)((Object)Mockito.doReturn((Object)token2).when((Object)fs2))).getRenewToken();
        this.renewer.addRenewAction((FileSystem)fs1);
        this.renewer.addRenewAction((FileSystem)fs2);
        Assert.assertEquals((long)2L, (long)this.renewer.getRenewQueueLength());
        this.renewer.removeRenewAction((FileSystem)fs1);
        Assert.assertEquals((long)1L, (long)this.renewer.getRenewQueueLength());
        this.renewer.removeRenewAction((FileSystem)fs2);
        Assert.assertEquals((long)0L, (long)this.renewer.getRenewQueueLength());
        ((Token)Mockito.verify((Object)token1)).cancel((Configuration)Mockito.eq((Object)conf));
        ((Token)Mockito.verify((Object)token2)).cancel((Configuration)Mockito.eq((Object)conf));
    }

    public abstract class RenewableFileSystem
    extends FileSystem
    implements DelegationTokenRenewer.Renewable {
    }
}

