/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.fairness.AbstractRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.NoRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.StaticRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestRouterRefreshFairnessPolicyController {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterRefreshFairnessPolicyController.class);
    private final GenericTestUtils.LogCapturer controllerLog = GenericTestUtils.LogCapturer.captureLogs((Logger)AbstractRouterRpcFairnessPolicyController.LOG);
    private StateStoreDFSCluster cluster;

    @BeforeClass
    public static void setLogLevel() {
        GenericTestUtils.setLogLevel((Logger)AbstractRouterRpcFairnessPolicyController.LOG, (Level)Level.DEBUG);
    }

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Before
    public void setupCluster() throws Exception {
        this.cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().rpc().build();
        conf.setClass("dfs.federation.router.fairness.policy.controller.class", StaticRouterRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        conf.setInt("dfs.federation.router.handler.count", 9);
        conf.setBoolean("dfs.federation.router.metrics.enable", true);
        this.cluster.setNumDatanodesPerNameservice(0);
        this.cluster.addRouterOverrides(conf);
        this.cluster.startCluster();
        this.cluster.startRouters();
        this.cluster.waitClusterUp();
    }

    @Test
    public void testRefreshNonexistentHandlerClass() {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        routerContext.getConf().set("dfs.federation.router.fairness.policy.controller.class", "org.apache.hadoop.hdfs.server.federation.fairness.ThisControllerDoesNotExist");
        Assert.assertEquals((Object)StaticRouterRpcFairnessPolicyController.class.getCanonicalName(), (Object)routerContext.getRouterRpcClient().refreshFairnessPolicyController(routerContext.getConf()));
    }

    @Test
    public void testRefreshClassDoesNotImplementControllerInterface() {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        routerContext.getConf().set("dfs.federation.router.fairness.policy.controller.class", "java.lang.String");
        Assert.assertEquals((Object)StaticRouterRpcFairnessPolicyController.class.getCanonicalName(), (Object)routerContext.getRouterRpcClient().refreshFairnessPolicyController(routerContext.getConf()));
    }

    @Test
    public void testRefreshSuccessful() {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        routerContext.getConf().set("dfs.federation.router.fairness.policy.controller.class", StaticRouterRpcFairnessPolicyController.class.getCanonicalName());
        Assert.assertEquals((Object)StaticRouterRpcFairnessPolicyController.class.getCanonicalName(), (Object)routerContext.getRouterRpcClient().refreshFairnessPolicyController(routerContext.getConf()));
        routerContext.getConf().set("dfs.federation.router.fairness.policy.controller.class", NoRouterRpcFairnessPolicyController.class.getCanonicalName());
        Assert.assertEquals((Object)NoRouterRpcFairnessPolicyController.class.getCanonicalName(), (Object)routerContext.getRouterRpcClient().refreshFairnessPolicyController(routerContext.getConf()));
    }

    @Test
    public void testConcurrentRefreshRequests() throws InterruptedException {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        RouterRpcClient client = (RouterRpcClient)Mockito.spy((Object)routerContext.getRouterRpcClient());
        this.controllerLog.clearOutput();
        Thread[] threads = new Thread[100];
        for (int i = 0; i < 100; ++i) {
            threads[i] = new Thread(() -> client.refreshFairnessPolicyController(routerContext.getConf()));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertEquals((long)100L, (long)StringUtils.countMatches((CharSequence)this.controllerLog.getOutput(), (CharSequence)"Shutting down router fairness policy controller"));
        this.controllerLog.clearOutput();
    }

    @Test
    public void testRefreshStaticChangeHandlers() throws Exception {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        RouterRpcClient client = (RouterRpcClient)Mockito.spy((Object)routerContext.getRouterRpcClient());
        long sleepTime = 3000L;
        ((RouterRpcClient)Mockito.doAnswer(invocationOnMock -> {
            Thread.sleep(3000L);
            return null;
        }).when((Object)client)).invokeMethod((UserGroupInformation)Mockito.any(), (List)Mockito.any(), Mockito.anyBoolean(), (Class)Mockito.any(), (Method)Mockito.any(), (Object[])Mockito.any());
        Assert.assertEquals((Object)"{}", (Object)routerContext.getRouterRpcServer().getRPCMetrics().getProxyOpPermitAcceptedPerNs());
        List<Thread> preRefreshInvocations = this.makeDummyInvocations(client, 4, "ns0");
        Thread.sleep(2000L);
        Assert.assertEquals((Object)"{\"ns0\":3}", (Object)routerContext.getRouterRpcServer().getRPCMetrics().getProxyOpPermitAcceptedPerNs());
        Assert.assertEquals((Object)"{\"ns0\":1}", (Object)routerContext.getRouterRpcServer().getRPCMetrics().getProxyOpPermitRejectedPerNs());
        Configuration conf = routerContext.getConf();
        int newNs0Permits = 2;
        int newNs1Permits = 4;
        conf.setInt("dfs.federation.router.fairness.handler.count.ns0", 2);
        conf.setInt("dfs.federation.router.fairness.handler.count.ns1", 4);
        Thread threadRefreshController = new Thread(() -> client.refreshFairnessPolicyController(routerContext.getConf()));
        threadRefreshController.start();
        threadRefreshController.join();
        for (Thread thread : preRefreshInvocations) {
            thread.join();
        }
        StaticRouterRpcFairnessPolicyController controller = (StaticRouterRpcFairnessPolicyController)client.getRouterRpcFairnessPolicyController();
        System.out.println(controller.getAvailableHandlerOnPerNs());
        List<Thread> ns0Invocations = this.makeDummyInvocations(client, 4, "ns0");
        List<Thread> ns1Invocations = this.makeDummyInvocations(client, 6, "ns1");
        for (Thread thread : ns0Invocations) {
            thread.join();
        }
        for (Thread thread : ns1Invocations) {
            thread.join();
        }
        Assert.assertEquals((Object)"{\"ns0\":5,\"ns1\":4}", (Object)routerContext.getRouterRpcServer().getRPCMetrics().getProxyOpPermitAcceptedPerNs());
        Assert.assertEquals((Object)"{\"ns0\":3,\"ns1\":2}", (Object)routerContext.getRouterRpcServer().getRPCMetrics().getProxyOpPermitRejectedPerNs());
    }

    private List<Thread> makeDummyInvocations(RouterRpcClient client, int nThreads, String namespace) {
        RemoteMethod dummyMethod = (RemoteMethod)Mockito.mock(RemoteMethod.class);
        ArrayList<Thread> threadAcquirePermits = new ArrayList<Thread>();
        for (int i = 0; i < nThreads; ++i) {
            Thread threadAcquirePermit = new Thread(() -> {
                try {
                    client.invokeSingle(namespace, dummyMethod);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            threadAcquirePermits.add(threadAcquirePermit);
            threadAcquirePermit.start();
        }
        return threadAcquirePermits;
    }
}

