/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public interface Optimisation {

    public static enum State implements Optimisation
    {
        APPROXIMATE(8),
        DISTINCT(256),
        FAILED(-1),
        FEASIBLE(16),
        INFEASIBLE(-8),
        INVALID(-2),
        OPTIMAL(64),
        UNBOUNDED(-32),
        UNEXPLORED(0),
        VALID(4);

        private final int myValue;

        private State(int aValue) {
            this.myValue = aValue;
        }

        public boolean isApproximate() {
            return this == APPROXIMATE || this.isFeasible();
        }

        public boolean isDistinct() {
            return this.absValue() >= DISTINCT.absValue();
        }

        public boolean isFailure() {
            return this.myValue < 0;
        }

        public boolean isFeasible() {
            return this.absValue() >= FEASIBLE.absValue();
        }

        public boolean isOptimal() {
            return this.absValue() >= OPTIMAL.absValue();
        }

        public boolean isSuccess() {
            return this.myValue > 0;
        }

        public boolean isUnexplored() {
            return this.myValue == 0;
        }

        public boolean isValid() {
            return this.absValue() >= VALID.absValue();
        }

        private int absValue() {
            return Math.abs(this.myValue);
        }
    }

    public static interface Solver
    extends Optimisation {
        default public void dispose() {
        }

        default public Result solve() {
            return this.solve(null);
        }

        public Result solve(Result var1);
    }

    public static final class Result
    implements Optimisation,
    Access1D<BigDecimal>,
    Comparable<Result>,
    Serializable {
        private final Access1D<?> mySolution;
        private final State myState;
        private final double myValue;

        public Result(State state, Access1D<?> solution) {
            this(state, Double.NaN, solution);
        }

        public Result(State state, double value, Access1D<?> solution) {
            Objects.requireNonNull(state);
            Objects.requireNonNull(solution);
            this.myState = state;
            this.myValue = value;
            this.mySolution = solution;
        }

        public Result(State state, Result result) {
            this(state, result.getValue(), result);
        }

        @Override
        public int compareTo(Result reference) {
            return Double.compare(this.myValue, reference.getValue());
        }

        @Override
        public long count() {
            return this.mySolution.count();
        }

        @Override
        public double doubleValue(long index) {
            return this.mySolution.doubleValue(index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.myState != other.myState) {
                return false;
            }
            return Double.doubleToLongBits(this.myValue) == Double.doubleToLongBits(other.myValue);
        }

        @Override
        public BigDecimal get(long index) {
            return TypeUtils.toBigDecimal(this.mySolution.get(index));
        }

        public State getState() {
            return this.myState;
        }

        public double getValue() {
            return this.myValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myState == null ? 0 : this.myState.hashCode());
            long temp = Double.doubleToLongBits(this.myValue);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public int size() {
            return (int)this.count();
        }

        public String toString() {
            return this.myState + " " + this.myValue + " @ " + Array1D.PRIMITIVE64.copy((Access1D)this.mySolution);
        }
    }

    public static final class Options
    implements Optimisation,
    Cloneable {
        public BasicLogger.Printer debug_appender = null;
        public Class<? extends Solver> debug_solver = null;
        public NumberContext integer = new NumberContext(12, 7, RoundingMode.HALF_EVEN);
        public int iterations_abort = Integer.MAX_VALUE;
        public int iterations_suffice = Integer.MAX_VALUE;
        public double mip_gap = 1.0E-4;
        public NumberContext objective = new NumberContext(12, 8, RoundingMode.HALF_EVEN);
        public NumberContext print = NumberContext.getGeneral(8, 10);
        public NumberContext problem = new NumberContext(12, 8, RoundingMode.HALF_EVEN);
        public NumberContext slack = new NumberContext(10, 8, RoundingMode.HALF_DOWN);
        public NumberContext solution = new NumberContext(12, 14, RoundingMode.HALF_DOWN);
        public long time_abort = CalendarDateUnit.MILLENIUM.size();
        public long time_suffice = CalendarDateUnit.DAY.size();
        public boolean validate = false;

        public Options copy() {
            try {
                return (Options)this.clone();
            }
            catch (CloneNotSupportedException anException) {
                return null;
            }
        }

        public void debug(Class<? extends Solver> solver) {
            this.debug_appender = solver != null ? BasicLogger.DEBUG : null;
            this.debug_solver = solver;
            this.validate = solver != null;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static interface Objective
    extends Optimisation {
        public BigDecimal getContributionWeight();

        public boolean isObjective();
    }

    public static interface Model
    extends Optimisation {
        default public void dispose() {
        }

        public Result maximise();

        public Result minimise();

        public boolean validate();
    }

    public static interface Integration<M extends Model, S extends Solver>
    extends Optimisation {
        public S build(M var1);

        public Result extractSolverState(M var1);

        public boolean isCapable(M var1);

        public Result toModelState(Result var1, M var2);

        public Result toSolverState(Result var1, M var2);
    }

    public static interface Constraint
    extends Optimisation {
        public BigDecimal getLowerLimit();

        public BigDecimal getUpperLimit();

        public boolean isConstraint();

        public boolean isEqualityConstraint();

        public boolean isLowerConstraint();

        public boolean isUpperConstraint();
    }
}

