/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationAttemptEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ClusterEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.QueueEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.UserEntity;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestTimelineServiceClientIntegration {
    private static final String ROOT_DIR = new File("target", TestTimelineServiceClientIntegration.class.getSimpleName()).getAbsolutePath();
    private static NodeTimelineCollectorManager collectorManager;
    private static PerNodeTimelineCollectorsAuxService auxService;
    private static Configuration conf;

    @BeforeAll
    public static void setupClass() throws Exception {
        try {
            collectorManager = new MockNodeTimelineCollectorManager();
            conf = new YarnConfiguration();
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setFloat("yarn.timeline-service.version", 2.0f);
            conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
            conf.set("yarn.timeline-service.fs-writer.root-dir", ROOT_DIR);
            auxService = PerNodeTimelineCollectorsAuxService.launchServer((String[])new String[0], (NodeTimelineCollectorManager)collectorManager, (Configuration)conf);
            auxService.addApplicationIfAbsent(ApplicationId.newInstance((long)0L, (int)1), "user");
        }
        catch (ExitUtil.ExitException e) {
            Assertions.fail();
        }
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (auxService != null) {
            auxService.stop();
        }
        FileUtils.deleteDirectory((File)new File(ROOT_DIR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPutEntities() throws Exception {
        TimelineV2Client client = TimelineV2Client.createTimelineClient((ApplicationId)ApplicationId.newInstance((long)0L, (int)1));
        try {
            client.setTimelineCollectorInfo(CollectorInfo.newInstance((String)collectorManager.getRestServerBindAddress()));
            client.init(conf);
            client.start();
            TimelineEntity entity = new TimelineEntity();
            entity.setType("test entity type");
            entity.setId("test entity id");
            TimelineMetric metric = new TimelineMetric(TimelineMetric.Type.TIME_SERIES);
            metric.setId("test metric id");
            metric.addValue(1L, (Number)1.0);
            metric.addValue(2L, (Number)2.0);
            entity.addMetric(metric);
            client.putEntities(new TimelineEntity[]{entity});
            client.putEntitiesAsync(new TimelineEntity[]{entity});
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPutExtendedEntities() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        TimelineV2Client client = TimelineV2Client.createTimelineClient((ApplicationId)appId);
        try {
            client.setTimelineCollectorInfo(CollectorInfo.newInstance((String)collectorManager.getRestServerBindAddress()));
            client.init(conf);
            client.start();
            ClusterEntity cluster = new ClusterEntity();
            cluster.setId("yarn_cluster");
            FlowRunEntity flow = new FlowRunEntity();
            flow.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
            flow.setName("test_flow_name");
            flow.setVersion("test_flow_version");
            flow.setRunId(1L);
            flow.setParent(cluster.getType(), cluster.getId());
            ApplicationEntity app = new ApplicationEntity();
            app.setId(appId.toString());
            flow.addChild(app.getType(), app.getId());
            ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            ApplicationAttemptEntity appAttempt = new ApplicationAttemptEntity();
            appAttempt.setId(attemptId.toString());
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
            ContainerEntity container = new ContainerEntity();
            container.setId(containerId.toString());
            UserEntity user = new UserEntity();
            user.setId(UserGroupInformation.getCurrentUser().getShortUserName());
            QueueEntity queue = new QueueEntity();
            queue.setId("default_queue");
            client.putEntities(new TimelineEntity[]{cluster, flow, app, appAttempt, container, user, queue});
            client.putEntitiesAsync(new TimelineEntity[]{cluster, flow, app, appAttempt, container, user, queue});
        }
        finally {
            client.stop();
        }
    }

    private static class MockNodeTimelineCollectorManager
    extends NodeTimelineCollectorManager {
        protected CollectorNodemanagerProtocol getNMCollectorService() {
            CollectorNodemanagerProtocol protocol = (CollectorNodemanagerProtocol)Mockito.mock(CollectorNodemanagerProtocol.class);
            try {
                GetTimelineCollectorContextResponse response = GetTimelineCollectorContextResponse.newInstance((String)UserGroupInformation.getCurrentUser().getShortUserName(), (String)"test_flow_name", (String)"test_flow_version", (long)1L);
                Mockito.when((Object)protocol.getTimelineCollectorContext((GetTimelineCollectorContextRequest)ArgumentMatchers.any(GetTimelineCollectorContextRequest.class))).thenReturn((Object)response);
            }
            catch (IOException | YarnException e) {
                Assertions.fail();
            }
            return protocol;
        }
    }
}

