/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.serde;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DefaultSerializer
implements INativeSerializer<Writable> {
    private final ModifiedByteArrayOutputStream outBuffer = new ModifiedByteArrayOutputStream();
    private final DataOutputStream outData = new DataOutputStream(this.outBuffer);
    private Writable buffered = null;
    private int bufferedLength = -1;

    @Override
    public int getLength(Writable w) throws IOException {
        this.buffered = null;
        this.bufferedLength = -1;
        this.outBuffer.reset();
        w.write((DataOutput)this.outData);
        this.bufferedLength = this.outBuffer.size();
        this.buffered = w;
        return this.bufferedLength;
    }

    @Override
    public void serialize(Writable w, DataOutput out) throws IOException {
        w.write(out);
    }

    @Override
    public void deserialize(DataInput in, int length, Writable w) throws IOException {
        w.readFields(in);
    }

    static class ModifiedByteArrayOutputStream
    extends ByteArrayOutputStream {
        ModifiedByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

