/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsFetcher;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.clients.CompatibleUrlConnClient;
import java.io.IOException;
import java.net.URL;

public abstract class HttpCredentialsFetcher
implements CredentialsFetcher {
    @Override
    public abstract URL buildUrl() throws ClientException;

    @Override
    public abstract Credentials parse(HttpResponse var1) throws ClientException;

    @Override
    public Credentials fetch() throws ClientException {
        URL url = this.buildUrl();
        HttpRequest request = new HttpRequest(url.toString());
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(Integer.valueOf(5000));
        request.setSysReadTimeout(Integer.valueOf(5000));
        HttpResponse response = null;
        try {
            response = this.send(request);
        }
        catch (IOException e) {
            throw new ClientException("CredentialsFetcher.fetch exception: " + e);
        }
        return this.parse(response);
    }

    @Override
    public HttpResponse send(HttpRequest request) throws IOException {
        HttpResponse response = null;
        try {
            response = CompatibleUrlConnClient.compatibleGetResponse((HttpRequest)request);
        }
        catch (ClientException e) {
            throw new IOException(e);
        }
        if (response.getStatus() != 200) {
            throw new IOException("HttpCode=" + response.getStatus());
        }
        return response;
    }

    @Override
    public Credentials fetch(int retryTimes) throws ClientException {
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                return this.fetch();
            }
            catch (ClientException e) {
                if (i != retryTimes) continue;
                throw e;
            }
        }
        throw new ClientException("Failed to connect ECS Metadata Service: Max retry times exceeded.");
    }
}

