/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.VectoredReadUtils;
import org.apache.hadoop.fs.impl.CombinedFileRange;
import org.apache.hadoop.fs.s3a.HttpChannelEOFException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.RangeNotSatisfiableEOFException;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.SDKStreamDrainer;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AInputStream
extends ObjectInputStream
implements CanSetReadahead,
CanUnbuffer,
StreamCapabilities,
IOStatisticsSource {
    public static final String E_NEGATIVE_READAHEAD_VALUE = "Negative readahead value";
    public static final String OPERATION_OPEN = "open";
    public static final String OPERATION_REOPEN = "re-open";
    private static final boolean CLOSE_WRAPPED_STREAM_ON_NEGATIVE_READ = true;
    private static final int TMP_BUFFER_MAX_SIZE = 65536;
    private static final Logger LOG = LoggerFactory.getLogger(S3AInputStream.class);
    private final AtomicBoolean stopVectoredIOOperations = new AtomicBoolean(false);
    private long pos;
    private volatile boolean closed;
    private ResponseInputStream<GetObjectResponse> wrappedStream;
    private final Optional<Long> fileLength = Optional.of(this.getContentLength());
    private long readahead = 65536L;
    private long nextReadPos;
    private long contentRangeFinish;
    private long contentRangeStart;
    private final ChangeTracker changeTracker;
    private final long asyncDrainThreshold;

    public S3AInputStream(ObjectReadParameters parameters) {
        super(InputStreamType.Classic, parameters);
        S3AReadOpContext context = this.getContext();
        this.changeTracker = new ChangeTracker(this.getUri(), context.getChangeDetectionPolicy(), this.getS3AStreamStatistics().getChangeTrackerStatistics(), this.getObjectAttributes());
        this.setReadahead(context.getReadahead());
        this.asyncDrainThreshold = context.getAsyncDrainThreshold();
    }

    @Override
    protected boolean isStreamOpen() {
        return !this.closed;
    }

    @Override
    protected void abortInFinalizer() {
        try {
            this.getS3AStreamStatistics().streamLeaked();
            this.closeStream("finalize()", true, true).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    private void maybeSwitchToRandomIO() {
        if (this.getInputPolicy().isAdaptive()) {
            this.setInputPolicy(S3AInputPolicy.Random);
        }
    }

    private synchronized void reopen(String reason, long targetPos, long length, boolean forceAbort) throws IOException {
        if (this.isObjectStreamOpen()) {
            this.closeStream("reopen(" + reason + ")", forceAbort, false);
        }
        this.contentRangeFinish = S3AInputStream.calculateRequestLimit(this.getInputPolicy(), targetPos, length, this.getContentLength(), this.readahead);
        LOG.debug("reopen({}) for {} range[{}-{}], length={}, streamPosition={}, nextReadPosition={}, policy={}", new Object[]{this.getUri(), reason, targetPos, this.contentRangeFinish, length, this.pos, this.nextReadPos, this.getInputPolicy()});
        GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)this.getCallbacks().newGetRequestBuilder(this.getKey()).range(S3AUtils.formatRange(targetPos, this.contentRangeFinish - 1L)).applyMutation(this.changeTracker::maybeApplyConstraint)).build();
        long opencount = this.getS3AStreamStatistics().streamOpened();
        String operation = opencount == 0L ? OPERATION_OPEN : OPERATION_REOPEN;
        String text = String.format("%s %s at %d", operation, this.getUri(), targetPos);
        this.wrappedStream = (ResponseInputStream)Invoker.onceTrackingDuration(text, this.getUri(), this.getS3AStreamStatistics().initiateGetRequest(), () -> this.getCallbacks().getObject(request));
        this.changeTracker.processResponse((GetObjectResponse)this.wrappedStream.response(), operation, targetPos);
        this.contentRangeStart = targetPos;
        this.pos = targetPos;
    }

    public synchronized long getPos() throws IOException {
        return this.nextReadPos < 0L ? 0L : this.nextReadPos;
    }

    public synchronized void seek(long targetPos) throws IOException {
        this.checkNotClosed();
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + targetPos);
        }
        if (this.getContentLength() <= 0L) {
            return;
        }
        this.nextReadPos = targetPos;
    }

    private void seekQuietly(long positiveTargetPos) {
        try {
            this.seek(positiveTargetPos);
        }
        catch (IOException ioe) {
            LOG.debug("Ignoring IOE on seek of {} to {}", new Object[]{this.getUri(), positiveTargetPos, ioe});
        }
    }

    private void seekInStream(long targetPos, long length) throws IOException {
        this.checkNotClosed();
        if (!this.isObjectStreamOpen()) {
            return;
        }
        long diff = targetPos - this.pos;
        if (diff > 0L) {
            boolean skipForward;
            int available = this.wrappedStream.available();
            long forwardSeekRange = Math.max(this.readahead, (long)available);
            long remainingInCurrentRequest = this.remainingInCurrentRequest();
            long forwardSeekLimit = Math.min(remainingInCurrentRequest, forwardSeekRange);
            boolean bl = skipForward = remainingInCurrentRequest > 0L && diff < forwardSeekLimit;
            if (skipForward) {
                LOG.debug("Forward seek on {}, of {} bytes", (Object)this.getUri(), (Object)diff);
                long skipped = this.wrappedStream.skip(diff);
                if (skipped > 0L) {
                    this.pos += skipped;
                }
                this.getS3AStreamStatistics().seekForwards(diff, skipped);
                if (this.pos == targetPos) {
                    LOG.debug("Now at {}: bytes remaining in current request: {}", (Object)this.pos, (Object)this.remainingInCurrentRequest());
                    return;
                }
                LOG.warn("Failed to seek on {} to {}. Current position {}", new Object[]{this.getUri(), targetPos, this.pos});
            } else {
                this.getS3AStreamStatistics().seekForwards(diff, 0L);
            }
        } else if (diff < 0L) {
            this.getS3AStreamStatistics().seekBackwards(diff);
            this.maybeSwitchToRandomIO();
        } else if (this.remainingInCurrentRequest() > 0L) {
            return;
        }
        this.closeStream("seekInStream()", false, false);
        this.pos = targetPos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    private void lazySeek(long targetPos, long len) throws IOException {
        Invoker invoker = this.getContext().getReadInvoker();
        invoker.retry("lazySeek to " + targetPos, this.getPathStr(), true, () -> {
            this.seekInStream(targetPos, len);
            if (!this.isObjectStreamOpen()) {
                this.reopen("read from new offset", targetPos, len, false);
            }
        });
    }

    private void incrementBytesRead(long bytesRead) {
        this.getS3AStreamStatistics().bytesRead(bytesRead);
        if (this.getContext().stats != null && bytesRead > 0L) {
            this.getContext().stats.incrementBytesRead(bytesRead);
        }
    }

    public synchronized int read() throws IOException {
        this.checkNotClosed();
        if (this.getContentLength() == 0L || this.nextReadPos >= this.getContentLength()) {
            return -1;
        }
        try {
            this.lazySeek(this.nextReadPos, 1L);
        }
        catch (RangeNotSatisfiableEOFException e) {
            LOG.debug("Downgrading 416 response attempt to read at {} to -1 response", (Object)this.nextReadPos);
            return -1;
        }
        Invoker invoker = this.getContext().getReadInvoker();
        int byteRead = (Integer)invoker.retry("read", this.getPathStr(), true, () -> {
            int b;
            if (!this.isObjectStreamOpen()) {
                this.reopen("failure recovery", this.getPos(), 1L, false);
            }
            try {
                b = this.wrappedStream.read();
            }
            catch (SocketTimeoutException | HttpChannelEOFException e) {
                this.onReadFailure(e, true);
                throw e;
            }
            catch (IOException e) {
                this.onReadFailure(e, false);
                throw e;
            }
            return b;
        });
        if (byteRead >= 0) {
            ++this.pos;
            ++this.nextReadPos;
            this.incrementBytesRead(1L);
        } else {
            this.streamReadResultNegative();
        }
        return byteRead;
    }

    private void onReadFailure(IOException ioe, boolean forceAbort) {
        GetObjectResponse objectResponse;
        GetObjectResponse getObjectResponse = objectResponse = this.wrappedStream == null ? null : (GetObjectResponse)this.wrappedStream.response();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got exception while trying to read from stream {}, client: {} object: {}, trying to recover: ", new Object[]{this.getUri(), this.getCallbacks(), objectResponse, ioe});
        } else {
            LOG.info("Got exception while trying to read from stream {}, client: {} object: {}, trying to recover: " + ioe, new Object[]{this.getUri(), this.getCallbacks(), objectResponse});
        }
        this.getS3AStreamStatistics().readException();
        this.closeStream("failure recovery", forceAbort, false);
    }

    private void streamReadResultNegative() {
        this.closeStream("wrappedStream.read() returned -1", false, false);
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.checkNotClosed();
        this.validatePositionedReadArgs(this.nextReadPos, buf, off, len);
        if (len == 0) {
            return 0;
        }
        if (this.getContentLength() == 0L || this.nextReadPos >= this.getContentLength()) {
            return -1;
        }
        try {
            this.lazySeek(this.nextReadPos, len);
        }
        catch (RangeNotSatisfiableEOFException e) {
            return -1;
        }
        Invoker invoker = this.getContext().getReadInvoker();
        this.getS3AStreamStatistics().readOperationStarted(this.nextReadPos, len);
        int bytesRead = (Integer)invoker.retry("read", this.getPathStr(), true, () -> {
            int bytes;
            if (!this.isObjectStreamOpen()) {
                this.reopen("failure recovery", this.getPos(), 1L, false);
            }
            try {
                bytes = this.wrappedStream.read(buf, off, len);
            }
            catch (SocketTimeoutException | HttpChannelEOFException e) {
                this.onReadFailure(e, true);
                throw e;
            }
            catch (EOFException e) {
                LOG.debug("EOFException raised by http stream read(); downgrading to a -1 response", (Throwable)e);
                return -1;
            }
            catch (IOException e) {
                this.onReadFailure(e, false);
                throw e;
            }
            return bytes;
        });
        if (bytesRead > 0) {
            this.pos += (long)bytesRead;
            this.nextReadPos += (long)bytesRead;
            this.incrementBytesRead(bytesRead);
        } else {
            this.streamReadResultNegative();
        }
        this.getS3AStreamStatistics().readOperationCompleted(len, bytesRead);
        return bytesRead;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.getUri() + ": " + "Stream is closed!");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.stopVectoredIOOperations.set(true);
                this.closeStream("close() operation", false, true);
                this.getCallbacks().close();
            }
            finally {
                super.close();
            }
        }
    }

    private CompletableFuture<Boolean> closeStream(String reason, boolean forceAbort, boolean blocking) {
        CompletableFuture<Boolean> operation;
        if (!this.isObjectStreamOpen()) {
            return CompletableFuture.completedFuture(false);
        }
        long remaining = this.remainingInCurrentRequest();
        LOG.debug("Closing stream {}: {}", (Object)reason, (Object)(forceAbort ? "abort" : "soft"));
        boolean shouldAbort = forceAbort || remaining > this.readahead;
        SDKStreamDrainer<ResponseInputStream<GetObjectResponse>> drainer = new SDKStreamDrainer<ResponseInputStream<GetObjectResponse>>(this.getUri(), this.wrappedStream, shouldAbort, (int)remaining, this.getS3AStreamStatistics(), reason);
        if (blocking || shouldAbort || remaining <= this.asyncDrainThreshold) {
            operation = CompletableFuture.completedFuture(drainer.apply());
        } else {
            LOG.debug("initiating asynchronous drain of {} bytes", (Object)remaining);
            operation = this.getCallbacks().submit(drainer);
        }
        this.wrappedStream = null;
        return operation;
    }

    @InterfaceStability.Unstable
    public synchronized boolean resetConnection() throws IOException {
        this.checkNotClosed();
        LOG.info("Forcing reset of connection to {}", (Object)this.getUri());
        return (Boolean)FutureIO.awaitFuture(this.closeStream("reset()", true, true));
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.remainingInFile();
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long remainingInFile() {
        return this.getContentLength() - this.pos;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long remainingInCurrentRequest() {
        return this.contentRangeFinish - this.pos;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long getContentRangeFinish() {
        return this.contentRangeFinish;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long getContentRangeStart() {
        return this.contentRangeStart;
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceStability.Unstable
    public String toString() {
        String s = this.getS3AStreamStatistics().toString();
        S3AInputStream s3AInputStream = this;
        synchronized (s3AInputStream) {
            StringBuilder sb = new StringBuilder("S3AInputStream{");
            sb.append(super.toString()).append(" ");
            sb.append(this.getUri());
            sb.append(" wrappedStream=").append(this.isObjectStreamOpen() ? OPERATION_OPEN : "closed");
            sb.append(" read policy=").append((Object)this.getInputPolicy());
            sb.append(" pos=").append(this.pos);
            sb.append(" nextReadPos=").append(this.nextReadPos);
            sb.append(" contentLength=").append(this.getContentLength());
            sb.append(" contentRangeStart=").append(this.contentRangeStart);
            sb.append(" contentRangeFinish=").append(this.contentRangeFinish);
            sb.append(" remainingInCurrentRequest=").append(this.remainingInCurrentRequest());
            sb.append(" ").append(this.changeTracker);
            sb.append(" ").append(this.getVectoredIOContext());
            sb.append('\n').append(s);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        this.validatePositionedReadArgs(position, buffer, offset, length);
        this.getS3AStreamStatistics().readFullyOperationStarted(position, length);
        if (length == 0) {
            return;
        }
        S3AInputStream s3AInputStream = this;
        synchronized (s3AInputStream) {
            long oldPos = this.getPos();
            try {
                int nbytes;
                this.seek(position);
                for (int nread = 0; nread < length; nread += nbytes) {
                    nbytes = this.read(buffer, offset + nread, length - nread);
                    if (nbytes >= 0) continue;
                    throw new EOFException("End of file reached before reading fully.");
                }
            }
            finally {
                this.seekQuietly(oldPos);
            }
        }
    }

    public synchronized void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate) throws IOException {
        this.readVectored(ranges, allocate, VectoredReadUtils.LOG_BYTE_BUFFER_RELEASED);
    }

    public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate, Consumer<ByteBuffer> release) throws IOException {
        LOG.debug("Starting vectored read on path {} for ranges {} ", (Object)this.getPathStr(), ranges);
        this.checkNotClosed();
        if (this.stopVectoredIOOperations.getAndSet(false)) {
            LOG.debug("Reinstating vectored read operation for path {} ", (Object)this.getPathStr());
        }
        Objects.requireNonNull(allocate, "ranges");
        Objects.requireNonNull(allocate, "allocate");
        Objects.requireNonNull(release, "release");
        List sortedRanges = VectoredReadUtils.validateAndSortRanges(ranges, this.fileLength);
        for (FileRange fileRange : ranges) {
            CompletableFuture result = new CompletableFuture();
            fileRange.setData(result);
        }
        this.closeStream("readVectored()", false, false);
        this.maybeSwitchToRandomIO();
        if (VectoredReadUtils.isOrderedDisjoint((List)sortedRanges, (int)1, (int)this.minSeekForVectorReads())) {
            LOG.debug("Not merging the ranges as they are disjoint");
            this.getS3AStreamStatistics().readVectoredOperationStarted(sortedRanges.size(), sortedRanges.size());
            for (FileRange fileRange : sortedRanges) {
                ByteBuffer buffer = allocate.apply(fileRange.getLength());
                this.getBoundedThreadPool().submit(() -> this.readSingleRange(range, buffer));
            }
        } else {
            LOG.debug("Trying to merge the ranges as they are not disjoint");
            List combinedFileRanges = VectoredReadUtils.mergeSortedRanges((List)sortedRanges, (int)1, (int)this.minSeekForVectorReads(), (int)this.maxReadSizeForVectorReads());
            this.getS3AStreamStatistics().readVectoredOperationStarted(sortedRanges.size(), combinedFileRanges.size());
            LOG.debug("Number of original ranges size {} , Number of combined ranges {} ", (Object)ranges.size(), (Object)combinedFileRanges.size());
            for (CombinedFileRange combinedFileRange : combinedFileRanges) {
                this.getBoundedThreadPool().submit(() -> this.readCombinedRangeAndUpdateChildren(combinedFileRange, allocate));
            }
        }
        LOG.debug("Finished submitting vectored read to threadpool on path {} for ranges {} ", (Object)this.getPathStr(), ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCombinedRangeAndUpdateChildren(CombinedFileRange combinedFileRange, IntFunction<ByteBuffer> allocate) {
        LOG.debug("Start reading {} from path {} ", (Object)combinedFileRange, (Object)this.getPathStr());
        ResponseInputStream<GetObjectResponse> rangeContent = null;
        try {
            rangeContent = this.getS3ObjectInputStream("readCombinedFileRange", combinedFileRange.getOffset(), combinedFileRange.getLength());
            this.populateChildBuffers(combinedFileRange, (InputStream)rangeContent, allocate);
        }
        catch (Exception ex) {
            try {
                LOG.debug("Exception while reading {} from path {} ", new Object[]{combinedFileRange, this.getPathStr(), ex});
                for (FileRange child : combinedFileRange.getUnderlying()) {
                    if (child.getData().isDone()) continue;
                    child.getData().completeExceptionally(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{rangeContent});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{rangeContent});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{rangeContent});
        LOG.debug("Finished reading {} from path {} ", (Object)combinedFileRange, (Object)this.getPathStr());
    }

    private void populateChildBuffers(CombinedFileRange combinedFileRange, InputStream objectContent, IntFunction<ByteBuffer> allocate) throws IOException {
        if (combinedFileRange.getUnderlying().size() == 1) {
            FileRange child = (FileRange)combinedFileRange.getUnderlying().get(0);
            ByteBuffer buffer = allocate.apply(child.getLength());
            this.populateBuffer(child, buffer, objectContent);
            child.getData().complete(buffer);
        } else {
            FileRange prev = null;
            for (FileRange child : combinedFileRange.getUnderlying()) {
                long position;
                this.checkIfVectoredIOStopped();
                if (prev != null && (position = prev.getOffset() + (long)prev.getLength()) < child.getOffset()) {
                    long drainQuantity = child.getOffset() - position;
                    this.drainUnnecessaryData(objectContent, position, drainQuantity);
                }
                ByteBuffer buffer = allocate.apply(child.getLength());
                this.populateBuffer(child, buffer, objectContent);
                child.getData().complete(buffer);
                prev = child;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainUnnecessaryData(InputStream objectContent, long position, long drainQuantity) throws IOException {
        int drainBytes = 0;
        int size = (int)Math.min(16384L, drainQuantity);
        byte[] drainBuffer = new byte[size];
        LOG.debug("Draining {} bytes from stream from offset {}; buffer size={}", new Object[]{drainQuantity, position, size});
        try {
            int readCount;
            for (long remaining = drainQuantity; remaining > 0L; remaining -= (long)readCount) {
                this.checkIfVectoredIOStopped();
                readCount = objectContent.read(drainBuffer, 0, (int)Math.min((long)size, remaining));
                LOG.debug("Drained {} bytes from stream", (Object)readCount);
                if (readCount < 0) {
                    String s = String.format("End of stream reached draining data between ranges; expected %,d bytes; only drained %,d bytes before -1 returned (position=%,d)", drainQuantity, drainBytes, position + (long)drainBytes);
                    throw new EOFException(s);
                }
                drainBytes += readCount;
            }
        }
        finally {
            this.getS3AStreamStatistics().readVectoredBytesDiscarded(drainBytes);
            LOG.debug("{} bytes drained from stream ", (Object)drainBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSingleRange(FileRange range, ByteBuffer buffer) {
        LOG.debug("Start reading {} from {} ", (Object)range, (Object)this.getPathStr());
        if (range.getLength() == 0) {
            buffer.flip();
            range.getData().complete(buffer);
            return;
        }
        ResponseInputStream<GetObjectResponse> objectRange = null;
        try {
            long position = range.getOffset();
            int length = range.getLength();
            objectRange = this.getS3ObjectInputStream("readSingleRange", position, length);
            this.populateBuffer(range, buffer, (InputStream)objectRange);
            range.getData().complete(buffer);
        }
        catch (Exception ex) {
            try {
                LOG.warn("Exception while reading a range {} from path {} ", new Object[]{range, this.getPathStr(), ex});
                range.getData().completeExceptionally(ex);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{objectRange});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{objectRange});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{objectRange});
        LOG.debug("Finished reading range {} from path {} ", (Object)range, (Object)this.getPathStr());
    }

    private ResponseInputStream<GetObjectResponse> getS3ObjectInputStream(String operationName, long position, int length) throws IOException {
        this.checkIfVectoredIOStopped();
        ResponseInputStream<GetObjectResponse> objectRange = this.getS3Object(operationName, position, length);
        this.checkIfVectoredIOStopped();
        return objectRange;
    }

    private void populateBuffer(FileRange range, ByteBuffer buffer, InputStream objectContent) throws IOException {
        int length = range.getLength();
        if (buffer.isDirect()) {
            VectoredReadUtils.readInDirectBuffer((FileRange)range, (ByteBuffer)buffer, (position, tmp, offset, currentLength) -> {
                this.readByteArray(objectContent, range, (byte[])tmp, (int)offset, (int)currentLength);
                return null;
            });
            buffer.flip();
        } else {
            this.readByteArray(objectContent, range, buffer.array(), 0, length);
        }
    }

    private void readByteArray(InputStream objectContent, FileRange range, byte[] dest, int offset, int length) throws IOException {
        LOG.debug("Reading {} bytes", (Object)length);
        int readBytes = 0;
        long position = range.getOffset();
        while (readBytes < length) {
            this.checkIfVectoredIOStopped();
            int readBytesCurr = objectContent.read(dest, offset + readBytes, length - readBytes);
            LOG.debug("read {} bytes from stream", (Object)readBytesCurr);
            if (readBytesCurr < 0) {
                throw new EOFException(String.format("HTTP stream closed before all bytes were read. Expected %,d bytes but only read %,d bytes. Current position %,d (%s)", length, readBytes, position, range));
            }
            readBytes += readBytesCurr;
            position += (long)readBytesCurr;
            this.incrementBytesRead(readBytesCurr);
        }
    }

    private ResponseInputStream<GetObjectResponse> getS3Object(String operationName, long position, int length) throws IOException {
        ResponseInputStream objectRange;
        GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)this.getCallbacks().newGetRequestBuilder(this.getKey()).range(S3AUtils.formatRange(position, position + (long)length - 1L)).applyMutation(this.changeTracker::maybeApplyConstraint)).build();
        DurationTracker tracker = this.getS3AStreamStatistics().initiateGetRequest();
        Invoker invoker = this.getContext().getReadInvoker();
        try {
            objectRange = (ResponseInputStream)invoker.retry(operationName, this.getPathStr(), true, () -> {
                this.checkIfVectoredIOStopped();
                return this.getCallbacks().getObject(request);
            });
        }
        catch (IOException ex) {
            tracker.failed();
            throw ex;
        }
        finally {
            tracker.close();
        }
        this.changeTracker.processResponse((GetObjectResponse)objectRange.response(), operationName, position);
        return objectRange;
    }

    private void checkIfVectoredIOStopped() throws InterruptedIOException {
        if (this.stopVectoredIOOperations.get()) {
            throw new InterruptedIOException("Stream closed or unbuffer is called");
        }
    }

    public synchronized void setReadahead(Long readahead) {
        this.readahead = S3AInputStream.validateReadahead(readahead);
    }

    public synchronized long getReadahead() {
        return this.readahead;
    }

    static long calculateRequestLimit(S3AInputPolicy inputPolicy, long targetPos, long length, long contentLength, long readahead) {
        long rangeLimit;
        switch (inputPolicy) {
            case Random: {
                rangeLimit = length < 0L ? contentLength : targetPos + Math.max(readahead, length);
                break;
            }
            case Sequential: {
                rangeLimit = contentLength;
                break;
            }
            default: {
                rangeLimit = contentLength;
            }
        }
        rangeLimit = Math.min(contentLength, rangeLimit);
        return rangeLimit;
    }

    public static long validateReadahead(@Nullable Long readahead) {
        if (readahead == null) {
            return 65536L;
        }
        Preconditions.checkArgument((readahead >= 0L ? 1 : 0) != 0, (Object)E_NEGATIVE_READAHEAD_VALUE);
        return readahead;
    }

    public synchronized void unbuffer() {
        try {
            this.stopVectoredIOOperations.set(true);
            this.closeStream("unbuffer()", false, false);
        }
        finally {
            this.getS3AStreamStatistics().unbuffered();
            if (this.getInputPolicy().isAdaptive()) {
                S3AInputPolicy policy = S3AInputPolicy.Random;
                this.setInputPolicy(policy);
            }
        }
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase((String)capability)) {
            case "fs.capability.iocontext.supported": 
            case "in:readahead": 
            case "in:unbuffer": {
                return true;
            }
        }
        return super.hasCapability(capability);
    }

    @VisibleForTesting
    public boolean isObjectStreamOpen() {
        return this.wrappedStream != null;
    }

    @VisibleForTesting
    public ResponseInputStream<GetObjectResponse> getWrappedStream() {
        return this.wrappedStream;
    }
}

