/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.security.RouterDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientRequestInterceptor
implements ClientRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientRequestInterceptor.class);
    private Configuration conf;
    private ClientRequestInterceptor nextInterceptor;
    protected UserGroupInformation user = null;
    private RouterDelegationTokenSecretManager tokenSecretManager = null;

    @Override
    public void setNextInterceptor(ClientRequestInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(String userName) {
        this.user = RouterServerUtil.setupUser(userName);
        if (this.nextInterceptor != null) {
            this.nextInterceptor.init(userName);
        }
    }

    @Override
    public void shutdown() {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.shutdown();
        }
    }

    @Override
    public ClientRequestInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    @Override
    public RouterDelegationTokenSecretManager getTokenSecretManager() {
        return this.tokenSecretManager;
    }

    @Override
    public void setTokenSecretManager(RouterDelegationTokenSecretManager tokenSecretManager) {
        this.tokenSecretManager = tokenSecretManager;
    }
}

