/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.statistics.meters.LegacyStatCounter;

public class GatewayReceiverStats
extends CacheServerStats {
    private static final String typeName = "GatewayReceiverStatistics";
    private static final String DUPLICATE_BATCHES_RECEIVED = "duplicateBatchesReceived";
    private static final String OUT_OF_ORDER_BATCHES_RECEIVED = "outoforderBatchesReceived";
    private static final String EARLY_ACKS = "earlyAcks";
    private static final String EVENTS_RECEIVED = "eventsReceived";
    private static final String CREAT_REQUESTS = "createRequests";
    private static final String UPDATE_REQUESTS = "updateRequest";
    private static final String DESTROY_REQUESTS = "destroyRequest";
    private static final String UNKNOWN_OPERATIONS_RECEIVED = "unknowsOperationsReceived";
    private static final String EXCEPTIONS_OCCURRED = "exceptionsOccurred";
    private static final String EVENTS_RETRIED = "eventsRetried";
    private final MeterRegistry meterRegistry;
    private final int duplicateBatchesReceivedId;
    private final int outoforderBatchesReceivedId;
    private final int earlyAcksId;
    private final Counter eventsReceivedCounter;
    private static final String EVENTS_RECEIVED_COUNTER_NAME = "geode.gateway.receiver.events";
    private static final String EVENTS_RECEIVED_COUNTER_DESCRIPTION = "total number events across the batched received by this GatewayReceiver";
    private static final String EVENTS_RECEIVED_COUNTER_UNITS = "operations";
    private final int createRequestId;
    private final int updateRequestId;
    private final int destroyRequestId;
    private final int unknowsOperationsReceivedId;
    private final int exceptionsOccurredId;
    private final int eventsRetriedId;

    public static GatewayReceiverStats createGatewayReceiverStats(StatisticsFactory f, String ownerName, MeterRegistry meterRegistry) {
        StatisticDescriptor[] descriptors = new StatisticDescriptor[]{f.createLongCounter(DUPLICATE_BATCHES_RECEIVED, "number of batches which have already been seen by this GatewayReceiver", "nanoseconds"), f.createLongCounter(OUT_OF_ORDER_BATCHES_RECEIVED, "number of batches which are out of order on this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(EARLY_ACKS, "number of early acknowledgements sent to gatewaySenders", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(EVENTS_RECEIVED, EVENTS_RECEIVED_COUNTER_DESCRIPTION, EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(CREAT_REQUESTS, "total number of create operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(UPDATE_REQUESTS, "total number of update operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(DESTROY_REQUESTS, "total number of destroy operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(UNKNOWN_OPERATIONS_RECEIVED, "total number of unknown operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(EXCEPTIONS_OCCURRED, "number of exceptions occurred while porcessing the batches", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(EVENTS_RETRIED, "total number events retried by this GatewayReceiver due to exceptions", EVENTS_RECEIVED_COUNTER_UNITS)};
        return new GatewayReceiverStats(f, ownerName, typeName, descriptors, meterRegistry);
    }

    public GatewayReceiverStats(StatisticsFactory f, String ownerName, String typeName, StatisticDescriptor[] descriptiors, MeterRegistry meterRegistry) {
        super(f, ownerName, typeName, descriptiors);
        this.duplicateBatchesReceivedId = this.statType.nameToId(DUPLICATE_BATCHES_RECEIVED);
        this.outoforderBatchesReceivedId = this.statType.nameToId(OUT_OF_ORDER_BATCHES_RECEIVED);
        this.earlyAcksId = this.statType.nameToId(EARLY_ACKS);
        int eventsReceivedId = this.statType.nameToId(EVENTS_RECEIVED);
        this.createRequestId = this.statType.nameToId(CREAT_REQUESTS);
        this.updateRequestId = this.statType.nameToId(UPDATE_REQUESTS);
        this.destroyRequestId = this.statType.nameToId(DESTROY_REQUESTS);
        this.unknowsOperationsReceivedId = this.statType.nameToId(UNKNOWN_OPERATIONS_RECEIVED);
        this.exceptionsOccurredId = this.statType.nameToId(EXCEPTIONS_OCCURRED);
        this.eventsRetriedId = this.statType.nameToId(EVENTS_RETRIED);
        this.meterRegistry = meterRegistry;
        this.eventsReceivedCounter = LegacyStatCounter.builder(EVENTS_RECEIVED_COUNTER_NAME).longStatistic(this.stats, eventsReceivedId).description(EVENTS_RECEIVED_COUNTER_DESCRIPTION).baseUnit(EVENTS_RECEIVED_COUNTER_UNITS).register(meterRegistry);
    }

    public void incDuplicateBatchesReceived() {
        this.stats.incLong(this.duplicateBatchesReceivedId, 1L);
    }

    public long getDuplicateBatchesReceived() {
        return this.stats.getLong(this.duplicateBatchesReceivedId);
    }

    public void incOutoforderBatchesReceived() {
        this.stats.incLong(this.outoforderBatchesReceivedId, 1L);
    }

    public long getOutoforderBatchesReceived() {
        return this.stats.getLong(this.outoforderBatchesReceivedId);
    }

    public void incEarlyAcks() {
        this.stats.incLong(this.earlyAcksId, 1L);
    }

    public long getEarlyAcks() {
        return this.stats.getLong(this.earlyAcksId);
    }

    public void incEventsReceived(int delta) {
        this.eventsReceivedCounter.increment((double)delta);
    }

    public long getEventsReceived() {
        return (long)this.eventsReceivedCounter.count();
    }

    public void incCreateRequest() {
        this.stats.incLong(this.createRequestId, 1L);
    }

    public long getCreateRequest() {
        return this.stats.getLong(this.createRequestId);
    }

    public void incUpdateRequest() {
        this.stats.incLong(this.updateRequestId, 1L);
    }

    public long getUpdateRequest() {
        return this.stats.getLong(this.updateRequestId);
    }

    public void incDestroyRequest() {
        this.stats.incLong(this.destroyRequestId, 1L);
    }

    public long getDestroyRequest() {
        return this.stats.getLong(this.destroyRequestId);
    }

    public void incUnknowsOperationsReceived() {
        this.stats.incLong(this.unknowsOperationsReceivedId, 1L);
    }

    public long getUnknowsOperationsReceived() {
        return this.stats.getLong(this.unknowsOperationsReceivedId);
    }

    public void incExceptionsOccurred(int delta) {
        this.stats.incLong(this.exceptionsOccurredId, (long)delta);
    }

    public long getExceptionsOccurred() {
        return this.stats.getLong(this.exceptionsOccurredId);
    }

    public void incEventsRetried() {
        this.stats.incLong(this.eventsRetriedId, 1L);
    }

    public long getEventsRetried() {
        return this.stats.getLong(this.eventsRetriedId);
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void close() {
        this.meterRegistry.remove((Meter)this.eventsReceivedCounter);
        super.close();
    }
}

