/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class WindowEmitStrategy$ {
    public static WindowEmitStrategy$ MODULE$;
    @Experimental
    private final ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED;
    @Experimental
    private final ConfigOption<Duration> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY;
    @Experimental
    private final ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED;
    @Experimental
    private final ConfigOption<Duration> TABLE_EXEC_EMIT_LATE_FIRE_DELAY;
    @Experimental
    private final ConfigOption<Duration> TABLE_EXEC_EMIT_ALLOW_LATENESS;

    static {
        new WindowEmitStrategy$();
    }

    public WindowEmitStrategy apply(ReadableConfig config, LogicalWindow window) {
        boolean isEventTime = AggregateUtil$.MODULE$.isRowtimeAttribute(window.timeAttribute());
        boolean isSessionWindow = window instanceof SessionGroupWindow;
        long allowLateness = this.parseAllowLateness(isSessionWindow, config);
        Boolean enableEarlyFireDelay = (Boolean)config.get(this.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED());
        Duration earlyFireDelay = config.getOptional(this.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY()).orElse(null);
        Boolean enableLateFireDelay = (Boolean)config.get(this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED());
        Duration lateFireDelay = config.getOptional(this.TABLE_EXEC_EMIT_LATE_FIRE_DELAY()).orElse(null);
        return new WindowEmitStrategy(Predef$.MODULE$.boolean2Boolean(isEventTime), Predef$.MODULE$.boolean2Boolean(isSessionWindow), earlyFireDelay, enableEarlyFireDelay, lateFireDelay, enableLateFireDelay, Predef$.MODULE$.long2Long(allowLateness));
    }

    private long parseAllowLateness(boolean isSessionWindow, ReadableConfig config) {
        Boolean enableLateFireDelay = (Boolean)config.get(this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED());
        Duration emitAllowLateness = config.getOptional(this.TABLE_EXEC_EMIT_ALLOW_LATENESS()).orElse(null);
        if (isSessionWindow) {
            return 0L;
        }
        if (!Predef$.MODULE$.Boolean2boolean(enableLateFireDelay)) {
            return 0L;
        }
        if (emitAllowLateness != null) {
            return emitAllowLateness.toMillis();
        }
        if (((Duration)config.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis() < 0L) {
            return 0L;
        }
        return ((Duration)config.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis();
    }

    public ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED() {
        return this.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED;
    }

    public ConfigOption<Duration> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY() {
        return this.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY;
    }

    public ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED() {
        return this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED;
    }

    public ConfigOption<Duration> TABLE_EXEC_EMIT_LATE_FIRE_DELAY() {
        return this.TABLE_EXEC_EMIT_LATE_FIRE_DELAY;
    }

    public ConfigOption<Duration> TABLE_EXEC_EMIT_ALLOW_LATENESS() {
        return this.TABLE_EXEC_EMIT_ALLOW_LATENESS;
    }

    private WindowEmitStrategy$() {
        MODULE$ = this;
        this.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED = ConfigOptions.key((String)"table.exec.emit.early-fire.enabled").booleanType().defaultValue((Object)BoxesRunTime.boxToBoolean((boolean)false)).withDescription("Specifies whether to enable early-fire emit.Early-fire is an emit strategy before watermark advanced to end of window.");
        this.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY = ConfigOptions.key((String)"table.exec.emit.early-fire.delay").durationType().noDefaultValue().withDescription("The early firing delay in milli second, early fire is the emit strategy before watermark advanced to end of window. < 0 is illegal configuration. 0 means no delay (fire on every element). > 0 means the fire interval. ");
        this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED = ConfigOptions.key((String)"table.exec.emit.late-fire.enabled").booleanType().defaultValue((Object)BoxesRunTime.boxToBoolean((boolean)false)).withDescription("Specifies whether to enable late-fire emit. Late-fire is an emit strategy after watermark advanced to end of window.");
        this.TABLE_EXEC_EMIT_LATE_FIRE_DELAY = ConfigOptions.key((String)"table.exec.emit.late-fire.delay").durationType().noDefaultValue().withDescription("The late firing delay in milli second, late fire is the emit strategy after watermark advanced to end of window. < 0 is illegal configuration. 0 means no delay (fire on every element). > 0 means the fire interval.");
        this.TABLE_EXEC_EMIT_ALLOW_LATENESS = ConfigOptions.key((String)"table.exec.emit.allow-lateness").durationType().noDefaultValue().withDescription("Sets the time by which elements are allowed to be late. Elements that arrive behind the watermark by more than the specified time will be dropped. Note: use the value if it is set, else use 'minIdleStateRetentionTime' in table config.< 0 is illegal configuration. 0 means disable allow lateness. > 0 means allow-lateness.");
    }
}

