/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.logical;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.utils.ShortcutUtils;

@Internal
public class FlinkLogicalTableFunctionScan
extends TableFunctionScan
implements FlinkLogicalRel {
    public static final Converter CONVERTER = new Converter(ConverterRule.Config.INSTANCE.withConversion(LogicalTableFunctionScan.class, Convention.NONE, FlinkConventions.LOGICAL(), "FlinkLogicalTableFunctionScanConverter"));

    public FlinkLogicalTableFunctionScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, @Nullable Type elementType, RelDataType rowType, @Nullable Set<RelColumnMapping> columnMappings) {
        super(cluster, traitSet, inputs, rexCall, elementType, rowType, columnMappings);
    }

    @Override
    public TableFunctionScan copy(RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, @Nullable Type elementType, RelDataType rowType, @Nullable Set<RelColumnMapping> columnMappings) {
        return new FlinkLogicalTableFunctionScan(this.getCluster(), traitSet, inputs, rexCall, elementType, rowType, columnMappings);
    }

    @Internal
    public static class Converter
    extends ConverterRule {
        protected Converter(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            LogicalTableFunctionScan functionScan = (LogicalTableFunctionScan)call.rel(0);
            FunctionDefinition functionDefinition = ShortcutUtils.unwrapFunctionDefinition(functionScan.getCall());
            if (functionDefinition == null) {
                return true;
            }
            boolean isTableFunction = functionDefinition.getKind() == FunctionKind.TABLE || functionDefinition.getKind() == FunctionKind.PROCESS_TABLE;
            return isTableFunction && !(functionDefinition instanceof TemporalTableFunction);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            LogicalTableFunctionScan functionScan = (LogicalTableFunctionScan)rel;
            RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions.LOGICAL()).simplify();
            List<RelNode> newInputs = functionScan.getInputs().stream().map(input -> RelOptRule.convert(input, FlinkConventions.LOGICAL())).collect(Collectors.toList());
            RexCall rexCall = (RexCall)functionScan.getCall();
            return new FlinkLogicalTableFunctionScan(functionScan.getCluster(), traitSet, newInputs, rexCall, functionScan.getElementType(), functionScan.getRowType(), functionScan.getColumnMappings());
        }
    }
}

