/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CompiledPlanSerdeUtil;

@Internal
final class ColumnJsonSerializer
extends StdSerializer<Column> {
    static final String KIND = "kind";
    static final String KIND_PHYSICAL = "PHYSICAL";
    static final String KIND_COMPUTED = "COMPUTED";
    static final String KIND_METADATA = "METADATA";
    static final String NAME = "name";
    static final String DATA_TYPE = "dataType";
    static final String COMMENT = "comment";
    static final String EXPRESSION = "expression";
    static final String METADATA_KEY = "metadataKey";
    static final String IS_VIRTUAL = "isVirtual";

    ColumnJsonSerializer() {
        super(Column.class);
    }

    public void serialize(Column column, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(NAME, column.getName());
        CompiledPlanSerdeUtil.serializeOptionalField(jsonGenerator, COMMENT, column.getComment(), serializerProvider);
        if (column instanceof Column.PhysicalColumn) {
            this.serialize((Column.PhysicalColumn)column, jsonGenerator, serializerProvider);
        } else if (column instanceof Column.MetadataColumn) {
            this.serialize((Column.MetadataColumn)column, jsonGenerator, serializerProvider);
        } else if (column instanceof Column.ComputedColumn) {
            this.serialize((Column.ComputedColumn)column, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    private void serialize(Column.PhysicalColumn column, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        serializerProvider.defaultSerializeField(DATA_TYPE, (Object)column.getDataType(), jsonGenerator);
    }

    private void serialize(Column.MetadataColumn column, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStringField(KIND, KIND_METADATA);
        serializerProvider.defaultSerializeField(DATA_TYPE, (Object)column.getDataType(), jsonGenerator);
        CompiledPlanSerdeUtil.serializeOptionalField(jsonGenerator, METADATA_KEY, column.getMetadataKey(), serializerProvider);
        jsonGenerator.writeBooleanField(IS_VIRTUAL, column.isVirtual());
    }

    private void serialize(Column.ComputedColumn column, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStringField(KIND, KIND_COMPUTED);
        serializerProvider.defaultSerializeField(EXPRESSION, (Object)column.getExpression(), jsonGenerator);
    }
}

