/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardForConsecutiveHashPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.HashCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecExchange;
import org.apache.flink.table.planner.utils.StreamExchangeModeUtils;
import org.apache.flink.table.runtime.partitioner.BinaryHashPartitioner;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="batch-exec-exchange", version=1, producedTransformations={"exchange"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecExchange
extends CommonExecExchange
implements BatchExecNode<RowData> {
    public static final String FIELD_NAME_REQUIRED_EXCHANGE_MODE = "requiredExchangeMode";
    @JsonProperty(value="requiredExchangeMode")
    private StreamExchangeMode requiredExchangeMode = StreamExchangeMode.UNDEFINED;

    public BatchExecExchange(ReadableConfig tableConfig, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecExchange.class), ExecNodeContext.newPersistedConfig(BatchExecExchange.class, tableConfig), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public BatchExecExchange(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="requiredExchangeMode") StreamExchangeMode requiredExchangeMode) {
        super(id, context, persistedConfig, inputProperties, outputType, description);
        this.requiredExchangeMode = requiredExchangeMode;
    }

    public void setRequiredExchangeMode(@Nullable StreamExchangeMode requiredExchangeMode) {
        this.requiredExchangeMode = requiredExchangeMode;
    }

    @Override
    public String getDescription() {
        InputProperty.RequiredDistribution requiredDistribution = this.getInputProperties().get(0).getRequiredDistribution();
        StringBuilder sb = new StringBuilder();
        String type = requiredDistribution.getType().name().toLowerCase();
        if (type.equals("singleton")) {
            type = "single";
        } else if (requiredDistribution instanceof InputProperty.KeepInputAsIsDistribution && ((InputProperty.KeepInputAsIsDistribution)requiredDistribution).isStrict()) {
            type = "forward";
        }
        sb.append("distribution=[").append(type);
        if (requiredDistribution instanceof InputProperty.HashDistribution) {
            sb.append(this.getHashDistributionDescription((InputProperty.HashDistribution)requiredDistribution));
        } else if (requiredDistribution instanceof InputProperty.KeepInputAsIsDistribution && !((InputProperty.KeepInputAsIsDistribution)requiredDistribution).isStrict()) {
            InputProperty.KeepInputAsIsDistribution distribution = (InputProperty.KeepInputAsIsDistribution)requiredDistribution;
            sb.append("[hash").append(this.getHashDistributionDescription((InputProperty.HashDistribution)distribution.getInputDistribution())).append("]");
        }
        sb.append("]");
        if (this.requiredExchangeMode == StreamExchangeMode.BATCH) {
            sb.append(", shuffle_mode=[BATCH]");
        }
        return String.format("Exchange(%s)", sb);
    }

    private String getHashDistributionDescription(InputProperty.HashDistribution hashDistribution) {
        RowType inputRowType = (RowType)this.getInputEdges().get(0).getOutputType();
        String[] fieldNames = (String[])Arrays.stream(hashDistribution.getKeys()).mapToObj(i -> (String)inputRowType.getFieldNames().get(i)).toArray(String[]::new);
        return Arrays.stream(fieldNames).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        int parallelism;
        BroadcastPartitioner partitioner;
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputType = (RowType)inputEdge.getOutputType();
        boolean requireUndefinedExchangeMode = false;
        InputProperty inputProperty = this.getInputProperties().get(0);
        InputProperty.RequiredDistribution requiredDistribution = inputProperty.getRequiredDistribution();
        InputProperty.DistributionType distributionType = requiredDistribution.getType();
        switch (distributionType) {
            case ANY: {
                partitioner = null;
                parallelism = -1;
                break;
            }
            case BROADCAST: {
                partitioner = new BroadcastPartitioner();
                parallelism = -1;
                break;
            }
            case SINGLETON: {
                partitioner = new GlobalPartitioner();
                parallelism = 1;
                break;
            }
            case HASH: {
                partitioner = this.createHashPartitioner((InputProperty.HashDistribution)requiredDistribution, inputType, config, planner.getFlinkContext().getClassLoader());
                parallelism = -1;
                break;
            }
            case KEEP_INPUT_AS_IS: {
                InputProperty.KeepInputAsIsDistribution keepInputAsIsDistribution = (InputProperty.KeepInputAsIsDistribution)requiredDistribution;
                if (keepInputAsIsDistribution.isStrict()) {
                    partitioner = new ForwardPartitioner();
                    requireUndefinedExchangeMode = true;
                } else {
                    InputProperty.RequiredDistribution inputDistribution = ((InputProperty.KeepInputAsIsDistribution)requiredDistribution).getInputDistribution();
                    Preconditions.checkArgument((boolean)(inputDistribution instanceof InputProperty.HashDistribution), (Object)"Only HashDistribution is supported now");
                    partitioner = new ForwardForConsecutiveHashPartitioner((StreamPartitioner)this.createHashPartitioner((InputProperty.HashDistribution)inputDistribution, inputType, config, planner.getFlinkContext().getClassLoader()));
                }
                parallelism = inputTransform.getParallelism();
                break;
            }
            default: {
                throw new TableException(String.valueOf((Object)distributionType) + "is not supported now!");
            }
        }
        StreamExchangeMode exchangeMode = requireUndefinedExchangeMode ? StreamExchangeMode.UNDEFINED : StreamExchangeModeUtils.getBatchStreamExchangeMode(config, this.requiredExchangeMode);
        PartitionTransformation transformation = new PartitionTransformation(inputTransform, (StreamPartitioner)partitioner, exchangeMode);
        this.createTransformationMeta("exchange", config).fill(transformation);
        transformation.setParallelism(parallelism);
        transformation.setOutputType((TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()));
        return transformation;
    }

    private BinaryHashPartitioner createHashPartitioner(InputProperty.HashDistribution hashDistribution, RowType inputType, ExecNodeConfig config, ClassLoader classLoader) {
        int[] keys = hashDistribution.getKeys();
        String[] fieldNames = (String[])Arrays.stream(keys).mapToObj(i -> (String)inputType.getFieldNames().get(i)).toArray(String[]::new);
        return new BinaryHashPartitioner(HashCodeGenerator.generateRowHash(new CodeGeneratorContext(config, classLoader), (LogicalType)inputType, "HashPartitioner", keys), fieldNames);
    }

    @VisibleForTesting
    public Optional<StreamExchangeMode> getRequiredExchangeMode() {
        return Optional.ofNullable(this.requiredExchangeMode);
    }
}

