/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop;

import java.net.URI;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.fs.s3.common.AbstractS3FileSystemFactory;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3hadoop.HadoopS3AccessHelper;
import org.apache.flink.fs.s3hadoop.common.HadoopConfigLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemFactory
extends AbstractS3FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileSystemFactory.class);
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"s3.", "s3a.", "fs.s3a."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"fs.s3a.access-key", "fs.s3a.access.key"}, {"fs.s3a.secret-key", "fs.s3a.secret.key"}, {"fs.s3a.path-style-access", "fs.s3a.path.style.access"}};

    public S3FileSystemFactory() {
        super("Hadoop s3a file system", S3FileSystemFactory.createHadoopConfigLoader());
    }

    public String getScheme() {
        return "s3";
    }

    @VisibleForTesting
    static HadoopConfigLoader createHadoopConfigLoader() {
        return new HadoopConfigLoader(FLINK_CONFIG_PREFIXES, MIRRORED_CONFIG_KEYS, "fs.s3a.", Collections.emptySet(), Collections.emptySet(), "");
    }

    @Override
    protected FileSystem createHadoopFileSystem() {
        return new S3AFileSystem();
    }

    @Override
    protected URI getInitURI(URI fsUri, Configuration hadoopConfig) {
        URI defaultUri;
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        if (scheme == null && authority == null) {
            fsUri = FileSystem.getDefaultUri(hadoopConfig);
        } else if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
            fsUri = defaultUri;
        }
        LOG.debug("Using scheme {} for s3a file system backing the S3 File System", (Object)fsUri);
        return fsUri;
    }

    @Override
    @Nullable
    protected S3AccessHelper getS3AccessHelper(FileSystem fs) {
        S3AFileSystem s3Afs = (S3AFileSystem)fs;
        return new HadoopS3AccessHelper(s3Afs, s3Afs.getConf());
    }
}

