/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.stream.IntStream;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.plan.utils.SortUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinOperator;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class SorMergeJoinOperatorUtil {
    public static SortMergeJoinFunction getSortMergeJoinFunction(ClassLoader classLoader, ReadableConfig config, FlinkJoinType joinType, RowType leftType, RowType rightType, int[] leftKeys, int[] rightKeys, RowType keyType, boolean leftIsSmaller, boolean[] filterNulls, GeneratedJoinCondition condFunc, double externalBufferMemRatio) {
        int[] keyPositions = IntStream.range(0, leftKeys.length).toArray();
        int maxNumFileHandles = (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES);
        boolean compressionEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED);
        int compressionBlockSize = (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes();
        boolean asyncMergeEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SORT_ASYNC_MERGE_ENABLED);
        SortCodeGenerator leftSortGen = SortUtil.newSortGen(config, classLoader, leftKeys, leftType);
        SortCodeGenerator rightSortGen = SortUtil.newSortGen(config, classLoader, rightKeys, rightType);
        return new SortMergeJoinFunction(externalBufferMemRatio, joinType, leftIsSmaller, maxNumFileHandles, compressionEnabled, compressionBlockSize, asyncMergeEnabled, condFunc, ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "SMJProjection", leftType, keyType, leftKeys), ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "SMJProjection", rightType, keyType, rightKeys), leftSortGen.generateNormalizedKeyComputer("LeftComputer"), leftSortGen.generateRecordComparator("LeftComparator"), rightSortGen.generateNormalizedKeyComputer("RightComputer"), rightSortGen.generateRecordComparator("RightComparator"), SortUtil.newSortGen(config, classLoader, keyPositions, keyType).generateRecordComparator("KeyComparator"), filterNulls);
    }

    public static SimpleOperatorFactory<RowData> generateOperatorFactory(GeneratedJoinCondition condFunc, RowType leftType, RowType rightType, int[] leftKeys, int[] rightKeys, FlinkJoinType joinType, ReadableConfig config, boolean leftIsSmaller, boolean[] filterNulls, long managedMemory, ClassLoader classLoader) {
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(leftKeys).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        SortMergeJoinFunction sortMergeJoinFunction = SorMergeJoinOperatorUtil.getSortMergeJoinFunction(classLoader, config, joinType, leftType, rightType, leftKeys, rightKeys, keyType, leftIsSmaller, filterNulls, condFunc, 1.0 * (double)externalBufferMemory / (double)managedMemory);
        return SimpleOperatorFactory.of((StreamOperator)new SortMergeJoinOperator(sortMergeJoinFunction));
    }

    private SorMergeJoinOperatorUtil() {
    }
}

