/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.WindowAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.window.WindowRankOperatorBuilder;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-window-rank", version=1, consumedOptions={"table.local-time-zone"}, producedTransformations={"window-rank"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecWindowRank
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String WINDOW_RANK_TRANSFORMATION = "window-rank";
    private static final long WINDOW_RANK_MEMORY_RATIO = 100L;
    public static final String FIELD_NAME_RANK_TYPE = "rankType";
    public static final String FIELD_NAME_PARTITION_SPEC = "partitionSpec";
    public static final String FIELD_NAME_SORT_SPEC = "sortSpec";
    public static final String FIELD_NAME_RANK_RANG = "rankRange";
    public static final String FIELD_NAME_OUTPUT_RANK_NUMBER = "outputRowNumber";
    public static final String FIELD_NAME_WINDOWING = "windowing";
    @JsonProperty(value="rankType")
    private final RankType rankType;
    @JsonProperty(value="partitionSpec")
    private final PartitionSpec partitionSpec;
    @JsonProperty(value="sortSpec")
    private final SortSpec sortSpec;
    @JsonProperty(value="rankRange")
    private final RankRange rankRange;
    @JsonProperty(value="outputRowNumber")
    private final boolean outputRankNumber;
    @JsonProperty(value="windowing")
    private final WindowingStrategy windowing;

    public StreamExecWindowRank(ReadableConfig tableConfig, RankType rankType, PartitionSpec partitionSpec, SortSpec sortSpec, RankRange rankRange, boolean outputRankNumber, WindowingStrategy windowing, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecWindowRank.class), ExecNodeContext.newPersistedConfig(StreamExecWindowRank.class, tableConfig), rankType, partitionSpec, sortSpec, rankRange, outputRankNumber, windowing, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWindowRank(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="rankType") RankType rankType, @JsonProperty(value="partitionSpec") PartitionSpec partitionSpec, @JsonProperty(value="sortSpec") SortSpec sortSpec, @JsonProperty(value="rankRange") RankRange rankRange, @JsonProperty(value="outputRowNumber") boolean outputRankNumber, @JsonProperty(value="windowing") WindowingStrategy windowing, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.rankType = (RankType)Preconditions.checkNotNull((Object)rankType);
        this.partitionSpec = (PartitionSpec)Preconditions.checkNotNull((Object)partitionSpec);
        this.sortSpec = (SortSpec)Preconditions.checkNotNull((Object)sortSpec);
        this.rankRange = (RankRange)Preconditions.checkNotNull((Object)rankRange);
        this.outputRankNumber = outputRankNumber;
        this.windowing = (WindowingStrategy)Preconditions.checkNotNull((Object)windowing);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        switch (this.rankType) {
            case ROW_NUMBER: {
                break;
            }
            case RANK: {
                throw new TableException("RANK() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.");
            }
            case DENSE_RANK: {
                throw new TableException("DENSE_RANK() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.");
            }
            default: {
                throw new TableException(String.format("%s() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.", this.rankType));
            }
        }
        if (!this.windowing.isRowtime()) {
            throw new TableException("Processing time Window TopN is not supported yet.");
        }
        if (!(this.windowing instanceof WindowAttachedWindowingStrategy)) {
            throw new UnsupportedOperationException(this.windowing.getClass().getName() + " is not supported yet.");
        }
        int windowEndIndex = ((WindowAttachedWindowingStrategy)this.windowing).getWindowEnd();
        ExecEdge inputEdge = this.getInputEdges().get(0);
        RowType inputType = (RowType)inputEdge.getOutputType();
        if (!(this.rankRange instanceof ConstantRankRange)) {
            throw new TableException(String.format("Rank strategy %s is not supported on window rank currently.", this.rankRange.toString(inputType.getFieldNames())));
        }
        ConstantRankRange constantRankRange = (ConstantRankRange)this.rankRange;
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        InternalTypeInfo inputRowTypeInfo = InternalTypeInfo.of((RowType)inputType);
        int[] sortFields = this.sortSpec.getFieldIndices();
        RowDataKeySelector sortKeySelector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), sortFields, (InternalTypeInfo<RowData>)inputRowTypeInfo);
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        IntStream.range(0, sortFields.length).forEach(idx -> builder.addField(idx, this.sortSpec.getFieldSpec(idx).getIsAscendingOrder(), this.sortSpec.getFieldSpec(idx).getNullIsLast()));
        SortSpec sortSpecInSortKey = builder.build();
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.windowing.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        GeneratedRecordComparator sortKeyComparator = ComparatorCodeGenerator.gen(config, planner.getFlinkContext().getClassLoader(), "StreamExecSortComparator", RowType.of((LogicalType[])this.sortSpec.getFieldTypes(inputType)), sortSpecInSortKey);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.partitionSpec.getFieldIndices(), (InternalTypeInfo<RowData>)inputRowTypeInfo);
        WindowAggOperator operator = WindowRankOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)new RowDataSerializer(inputType)).shiftTimeZone(shiftTimeZone).keySerializer((PagedTypeSerializer)selector.getProducedType().toSerializer()).sortKeySelector(sortKeySelector).sortKeyComparator(sortKeyComparator).outputRankNumber(this.outputRankNumber).rankStart(constantRankRange.getRankStart()).rankEnd(constantRankRange.getRankEnd()).windowEndIndex(windowEndIndex).withEventTime(Boolean.valueOf(this.windowing.isRowtime())).build();
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(WINDOW_RANK_TRANSFORMATION, config), SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), 100L, false);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }
}

