/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.PartitionSetSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.TopicListSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.TopicPatternSubscriber;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.TopicPartition;

@PublicEvolving
public interface KafkaSubscriber
extends Serializable {
    public Set<TopicPartition> getSubscribedTopicPartitions(AdminClient var1);

    public static KafkaSubscriber getTopicListSubscriber(List<String> topics) {
        return new TopicListSubscriber(topics);
    }

    public static KafkaSubscriber getTopicPatternSubscriber(Pattern topicPattern) {
        return new TopicPatternSubscriber(topicPattern);
    }

    public static KafkaSubscriber getPartitionSetSubscriber(Set<TopicPartition> partitions) {
        return new PartitionSetSubscriber(partitions);
    }
}

