/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azurefs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.azure.common.hadoop.BaseHadoopFsRecoverableFsDataOutputStream;
import org.apache.flink.fs.azure.common.hadoop.HadoopFsRecoverable;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class AzureBlobFsRecoverableDataOutputStream
extends BaseHadoopFsRecoverableFsDataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobFsRecoverableDataOutputStream.class);
    private static final String RENAME = ".rename";
    @VisibleForTesting
    static int minBufferLength = 0x200000;

    AzureBlobFsRecoverableDataOutputStream(FileSystem fs, Path targetFile, Path tempFile) throws IOException {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        this.targetFile = (Path)Preconditions.checkNotNull((Object)targetFile);
        LOG.debug("The targetFile is {}", (Object)targetFile.getName());
        this.tempFile = (Path)Preconditions.checkNotNull((Object)tempFile);
        LOG.debug("The tempFile is {}", (Object)tempFile.getName());
        this.out = fs.create(tempFile);
    }

    @VisibleForTesting
    AzureBlobFsRecoverableDataOutputStream(FileSystem fs, Path targetFile, Path tempFile, FSDataOutputStream out) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        this.targetFile = (Path)Preconditions.checkNotNull((Object)targetFile);
        this.tempFile = (Path)Preconditions.checkNotNull((Object)tempFile);
        this.out = out;
    }

    /*
     * Enabled aggressive block sorting
     */
    AzureBlobFsRecoverableDataOutputStream(FileSystem fs, HadoopFsRecoverable recoverable) throws IOException {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        this.targetFile = (Path)Preconditions.checkNotNull((Object)recoverable.targetFile());
        this.tempFile = (Path)Preconditions.checkNotNull((Object)recoverable.tempFile());
        if (!fs.exists(this.tempFile)) {
            LOG.error("The temp file is not found {}", (Object)this.tempFile);
            Path renameTempPath = new Path(this.tempFile.toString() + RENAME);
            if (!fs.exists(renameTempPath)) {
                LOG.error("Unrecoverable error. As the required {} file is not found", (Object)this.tempFile);
                throw new IOException("Unable to recover the job as the expected " + this.tempFile + " file is not found");
            }
            LOG.info("Found the rename file. Probably a case where the rename did not happen {}", (Object)renameTempPath);
            if (fs.getFileStatus(renameTempPath).getLen() != recoverable.offset()) {
                LOG.error("Unrecoverable error. As the required {} file is not found", (Object)this.tempFile);
                throw new IOException("Unable to recover the job as the expected " + this.tempFile + " file is not found");
            }
            this.rename(fs, renameTempPath);
        } else {
            long len = fs.getFileStatus(this.tempFile).getLen();
            LOG.info("The recoverable offset is {} and the file len is {}", (Object)recoverable.offset(), (Object)len);
            if (len > recoverable.offset()) {
                this.truncate(fs, recoverable);
            } else if (len < recoverable.offset()) {
                LOG.error("Temp file length {} is less than the expected recoverable offset {}", (Object)len, (Object)recoverable.offset());
                throw new IOException("Unable to create recoverable outputstream as length of file " + len + " is less than recoverable offset " + recoverable.offset());
            }
        }
        this.out = fs.append(this.tempFile);
        if (this.out.getPos() == 0L) {
            this.initialFileSize = fs.getFileStatus(this.tempFile).getLen();
        }
        LOG.debug("Created a new OS for appending {}", (Object)this.tempFile);
    }

    private void truncate(FileSystem fs, HadoopFsRecoverable recoverable) throws IOException {
        Path renameTempPath = new Path(this.tempFile.toString() + RENAME);
        try {
            LOG.info("Creating the temp rename file {} for truncating the tempFile {}", (Object)renameTempPath, (Object)this.tempFile);
            FSDataOutputStream fsDataOutputStream = fs.create(renameTempPath);
            LOG.info("Opening the tempFile {} for truncate", (Object)this.tempFile);
            FSDataInputStream fsDis = fs.open(this.tempFile);
            long remaining = recoverable.offset();
            byte[] buf = null;
            long dataWritten = 0L;
            int readBytes = -1;
            while (remaining != 0L) {
                buf = (long)minBufferLength < remaining ? new byte[minBufferLength] : new byte[(int)remaining];
                readBytes = fsDis.read(buf, 0, buf.length);
                if (readBytes != -1) {
                    LOG.info("Bytes remaining to read {}", (Object)(remaining -= (long)readBytes));
                    fsDataOutputStream.write(buf, 0, readBytes);
                    LOG.info("Successfully wrote {} bytes of data", (Object)(dataWritten += (long)readBytes));
                    continue;
                }
                LOG.debug("Reached the end of the file");
                remaining = 0L;
            }
            LOG.info("Closing the temp rename file {}", (Object)renameTempPath);
            fsDataOutputStream.close();
            if (fsDis != null) {
                LOG.debug("Closing the input stream");
                fsDis.close();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to recover. Exception while trying to truncate the temp file {}", (Object)this.tempFile);
            throw e;
        }
        try {
            LOG.info("Deleting the actual temp file {}", (Object)this.tempFile);
            fs.delete(this.tempFile, false);
        }
        catch (IOException e) {
            LOG.error("Unable to recover. Error while deleting the temp file {}", (Object)this.tempFile);
            throw e;
        }
        this.rename(fs, renameTempPath);
    }

    private void rename(FileSystem fs, Path renameTempPath) throws IOException {
        LOG.info("Renaming the temp rename file {} back to tempFile {}", (Object)renameTempPath, (Object)this.tempFile);
        try {
            boolean result = fs.rename(renameTempPath, this.tempFile);
            if (!result) {
                LOG.error("Unable to recover. Rename operation failed {} to {}", (Object)renameTempPath, (Object)this.tempFile);
                throw new IOException("Unable to recover. Rename operation failed");
            }
            LOG.info("Rename was successful");
        }
        catch (IOException e) {
            LOG.error("Unable to recover. Renaming of tempFile did not happen after truncating {} to {}", (Object)renameTempPath, (Object)this.tempFile);
            throw e;
        }
    }

    @Override
    public void sync() throws IOException {
        this.out.hsync();
    }

    protected RecoverableFsDataOutputStream.Committer createCommitterFromResumeRecoverable(HadoopFsRecoverable recoverable) {
        return new ABFSCommitter(this.fs, recoverable);
    }

    static class ABFSCommitter
    implements RecoverableFsDataOutputStream.Committer {
        private final FileSystem fs;
        private final HadoopFsRecoverable recoverable;

        ABFSCommitter(FileSystem fs, HadoopFsRecoverable recoverable) {
            this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
            this.recoverable = (HadoopFsRecoverable)Preconditions.checkNotNull((Object)recoverable);
        }

        public void commit() throws IOException {
            Path src = this.recoverable.tempFile();
            Path dest = this.recoverable.targetFile();
            long expectedLength = this.recoverable.offset();
            FileStatus srcStatus = null;
            try {
                srcStatus = this.fs.getFileStatus(src);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                throw new IOException("Cannot clean commit: Staging file does not exist.");
            }
            if (srcStatus != null) {
                LOG.debug("The srcStatus is {} and exp length is {}", (Object)srcStatus.getLen(), (Object)expectedLength);
                if (srcStatus.getLen() != expectedLength) {
                    LOG.error("The src file {} with length {} does not match the expected length {}", new Object[]{src, srcStatus.getLen(), expectedLength});
                    throw new IOException("The src file " + src + " with length " + srcStatus.getLen() + " does not match the expected length " + expectedLength);
                }
                try {
                    this.fs.rename(src, dest);
                }
                catch (IOException e) {
                    throw new IOException("Committing file by rename failed: " + src + " to " + dest, e);
                }
            } else if (!this.fs.exists(dest)) {
                throw new IOException("Unrecoverable exception while trying to recover " + this.recoverable.tempFile());
            }
        }

        public void commitAfterRecovery() throws IOException {
            this.commit();
        }

        public RecoverableWriter.CommitRecoverable getRecoverable() {
            return this.recoverable;
        }
    }
}

