/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

public abstract class ExpandingPreparingTable
extends FlinkPreparingTableBase {
    protected ExpandingPreparingTable(@Nullable RelOptSchema relOptSchema, RelDataType rowType, Iterable<String> names, FlinkStatistic statistic) {
        super(relOptSchema, rowType, names, statistic);
    }

    protected abstract RelNode convertToRel(RelOptTable.ToRelContext var1);

    @Override
    public final RelNode toRel(RelOptTable.ToRelContext context) {
        return this.expand(context);
    }

    private RelNode expand(final RelOptTable.ToRelContext context) {
        if (context.getTableHints().size() > 0) {
            throw new ValidationException(String.format("View '%s' cannot be enriched with new options. Hints can only be applied to tables.", ObjectIdentifier.of((String)this.names.get(0), (String)this.names.get(1), (String)this.names.get(2))));
        }
        RelNode rel = this.convertToRel(context);
        return rel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable table = scan.getTable();
                if (table instanceof ExpandingPreparingTable) {
                    return ((ExpandingPreparingTable)table).expand(context);
                }
                return super.visit(scan);
            }
        });
    }
}

