/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.resource.util;

import com.google.common.base.Preconditions;
import io.opencensus.contrib.resource.util.AwsIdentityDocUtils;
import io.opencensus.contrib.resource.util.GcpMetadataConfig;
import io.opencensus.contrib.resource.util.ResourceUtils;
import io.opencensus.resource.Resource;
import java.util.LinkedHashMap;

public final class HostResource {
    public static final String TYPE = "host";
    public static final String HOSTNAME_KEY = "host.hostname";
    public static final String NAME_KEY = "host.name";
    public static final String ID_KEY = "host.id";
    public static final String TYPE_KEY = "host.type";

    public static Resource create(String hostname, String name, String id, String type) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(HOSTNAME_KEY, Preconditions.checkNotNull(hostname, "hostname"));
        labels.put(NAME_KEY, Preconditions.checkNotNull(name, "name"));
        labels.put(ID_KEY, Preconditions.checkNotNull(id, "id"));
        labels.put(TYPE_KEY, Preconditions.checkNotNull(type, "type"));
        return Resource.create(TYPE, labels);
    }

    static Resource detect() {
        if (AwsIdentityDocUtils.isRunningOnAws()) {
            return HostResource.create("", "", AwsIdentityDocUtils.getInstanceId(), AwsIdentityDocUtils.getMachineType());
        }
        if (GcpMetadataConfig.isRunningOnGcp()) {
            return HostResource.create(GcpMetadataConfig.getInstanceHostname(), GcpMetadataConfig.getInstanceName(), GcpMetadataConfig.getInstanceId(), GcpMetadataConfig.getMachineType());
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    private HostResource() {
    }
}

