/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpoint;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactory;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactoryUtils;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpoint;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestOptions;

public class SqlGatewayRestEndpointFactory
implements SqlGatewayEndpointFactory {
    public static final String IDENTIFIER = "rest";

    @Override
    public SqlGatewayEndpoint createSqlGatewayEndpoint(SqlGatewayEndpointFactory.Context context) {
        SqlGatewayEndpointFactoryUtils.EndpointFactoryHelper endpointFactoryHelper = SqlGatewayEndpointFactoryUtils.createEndpointFactoryHelper(this, context);
        endpointFactoryHelper.validate();
        Configuration config = SqlGatewayRestEndpointFactory.rebuildRestEndpointOptions(context.getEndpointOptions(), context.getFlinkConfiguration().toMap());
        try {
            return new SqlGatewayRestEndpoint(config, context.getSqlGatewayService());
        }
        catch (Exception e) {
            throw new SqlGatewayException("Cannot start the rest endpoint.", e);
        }
    }

    public static Configuration rebuildRestEndpointOptions(Map<String, String> endpointConfigMap, Map<String, String> flinkConfigMap) {
        flinkConfigMap.put(RestOptions.ADDRESS.key(), endpointConfigMap.get(SqlGatewayRestOptions.ADDRESS.key()));
        if (endpointConfigMap.containsKey(SqlGatewayRestOptions.BIND_ADDRESS.key())) {
            flinkConfigMap.put(RestOptions.BIND_ADDRESS.key(), endpointConfigMap.get(SqlGatewayRestOptions.BIND_ADDRESS.key()));
        }
        flinkConfigMap.put(RestOptions.PORT.key(), endpointConfigMap.getOrDefault(SqlGatewayRestOptions.PORT.key(), ((Integer)SqlGatewayRestOptions.PORT.defaultValue()).toString()));
        if (endpointConfigMap.containsKey(SqlGatewayRestOptions.BIND_PORT.key())) {
            flinkConfigMap.put(RestOptions.BIND_PORT.key(), endpointConfigMap.get(SqlGatewayRestOptions.BIND_PORT.key()));
        }
        return Configuration.fromMap(flinkConfigMap);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(SqlGatewayRestOptions.ADDRESS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(SqlGatewayRestOptions.BIND_ADDRESS);
        options.add(SqlGatewayRestOptions.PORT);
        options.add(SqlGatewayRestOptions.BIND_PORT);
        return options;
    }
}

