/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.CurrencyData;

/**
 * CollateralData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class CollateralData {
  public static final String SERIALIZED_NAME_ALLOWED_COLLATERAL_TYPES = "allowedCollateralTypes";
  @SerializedName(SERIALIZED_NAME_ALLOWED_COLLATERAL_TYPES)
  private List<CodeValueData> allowedCollateralTypes;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private CodeValueData type;

  public static final String SERIALIZED_NAME_VALUE = "value";
  @SerializedName(SERIALIZED_NAME_VALUE)
  private BigDecimal value;

  public CollateralData() {
  }

  public CollateralData allowedCollateralTypes(List<CodeValueData> allowedCollateralTypes) {
    
    this.allowedCollateralTypes = allowedCollateralTypes;
    return this;
  }

  public CollateralData addAllowedCollateralTypesItem(CodeValueData allowedCollateralTypesItem) {
    if (this.allowedCollateralTypes == null) {
      this.allowedCollateralTypes = new ArrayList<>();
    }
    this.allowedCollateralTypes.add(allowedCollateralTypesItem);
    return this;
  }

  /**
   * Get allowedCollateralTypes
   * @return allowedCollateralTypes
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getAllowedCollateralTypes() {
    return allowedCollateralTypes;
  }


  public void setAllowedCollateralTypes(List<CodeValueData> allowedCollateralTypes) {
    this.allowedCollateralTypes = allowedCollateralTypes;
  }

  public CollateralData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public CollateralData description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public CollateralData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public CollateralData type(CodeValueData type) {
    
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  @javax.annotation.Nullable

  public CodeValueData getType() {
    return type;
  }


  public void setType(CodeValueData type) {
    this.type = type;
  }

  public CollateralData value(BigDecimal value) {
    
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
   */
  @javax.annotation.Nullable

  public BigDecimal getValue() {
    return value;
  }


  public void setValue(BigDecimal value) {
    this.value = value;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CollateralData collateralData = (CollateralData) o;
    return Objects.equals(this.allowedCollateralTypes, collateralData.allowedCollateralTypes) &&
        Objects.equals(this.currency, collateralData.currency) &&
        Objects.equals(this.description, collateralData.description) &&
        Objects.equals(this.id, collateralData.id) &&
        Objects.equals(this.type, collateralData.type) &&
        Objects.equals(this.value, collateralData.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowedCollateralTypes, currency, description, id, type, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CollateralData {\n");
    sb.append("    allowedCollateralTypes: ").append(toIndentedString(allowedCollateralTypes)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

