/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.data.PermissionData;
import org.apache.fineract.useradministration.service.PermissionReadPlatformService;
import org.apache.fineract.useradministration.service.PermissionReadPlatformServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PermissionReadPlatformServiceImpl
implements PermissionReadPlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionReadPlatformServiceImpl.class);
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public Collection<PermissionData> retrieveAllPermissions() {
        this.context.authenticatedUser();
        PermissionUsageDataMapper mapper = new PermissionUsageDataMapper(this.sqlGenerator);
        String sql = mapper.permissionSchema();
        log.debug("retrieveAllPermissions: {}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[0]);
    }

    public Collection<PermissionData> retrieveAllMakerCheckerablePermissions() {
        this.context.authenticatedUser();
        PermissionUsageDataMapper mapper = new PermissionUsageDataMapper(this.sqlGenerator);
        String sql = mapper.makerCheckerablePermissionSchema();
        log.debug("retrieveAllMakerCheckerablePermissions: {}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[0]);
    }

    public Collection<PermissionData> retrieveAllRolePermissions(Long roleId) {
        PermissionUsageDataMapper mapper = new PermissionUsageDataMapper(this.sqlGenerator);
        String sql = mapper.rolePermissionSchema();
        log.debug("retrieveAllRolePermissions: {}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[]{roleId});
    }

    @Generated
    public PermissionReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
    }
}

