/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.domain.LocalDateInterval;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChart;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartAssembler;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.PreClosurePenalInterestOnType;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPeriodFrequencyType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.domain.DepositAccountInterestRateChart;
import org.apache.fineract.portfolio.savings.domain.DepositAccountTermAndPreClosure;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountCharge;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsEvent;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.domain.interest.PostingPeriod;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@DiscriminatorValue(value="200")
public class FixedDepositAccount
extends SavingsAccount
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OneToOne(mappedBy="account", cascade={CascadeType.ALL})
    private DepositAccountTermAndPreClosure accountTermAndPreClosure;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="account")
    protected DepositAccountInterestRateChart chart;
    @Transient
    protected InterestRateChartAssembler chartAssembler;
    @Transient
    private ConfigurationDomainService configurationDomainService;
    static final long serialVersionUID = -6459209863455219086L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_chart_vh;

    protected FixedDepositAccount() {
    }

    public static FixedDepositAccount createNewApplicationForSubmittal(Client client, Group group, SavingsProduct product, Staff fieldOfficer, String accountNo, ExternalId externalId, AccountType accountType, LocalDate submittedOnDate, AppUser submittedBy, BigDecimal interestRate, SavingsCompoundingInterestPeriodType interestCompoundingPeriodType, SavingsPostingInterestPeriodType interestPostingPeriodType, SavingsInterestCalculationType interestCalculationType, SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType, BigDecimal minRequiredOpeningBalance, Integer lockinPeriodFrequency, SavingsPeriodFrequencyType lockinPeriodFrequencyType, boolean withdrawalFeeApplicableForTransfer, Set<SavingsAccountCharge> savingsAccountCharges, DepositAccountTermAndPreClosure accountTermAndPreClosure, DepositAccountInterestRateChart chart, boolean withHoldTax) {
        SavingsAccountStatusType status = SavingsAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL;
        boolean allowOverdraft = false;
        BigDecimal overdraftLimit = new BigDecimal(0);
        FixedDepositAccount account = new FixedDepositAccount(client, group, product, fieldOfficer, accountNo, externalId, status, accountType, submittedOnDate, submittedBy, interestRate, interestCompoundingPeriodType, interestPostingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeApplicableForTransfer, savingsAccountCharges, accountTermAndPreClosure, chart, false, overdraftLimit, withHoldTax);
        return account;
    }

    private FixedDepositAccount(Client client, Group group, SavingsProduct product, Staff fieldOfficer, String accountNo, ExternalId externalId, SavingsAccountStatusType status, AccountType accountType, LocalDate submittedOnDate, AppUser submittedBy, BigDecimal nominalAnnualInterestRate, SavingsCompoundingInterestPeriodType interestCompoundingPeriodType, SavingsPostingInterestPeriodType interestPostingPeriodType, SavingsInterestCalculationType interestCalculationType, SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType, BigDecimal minRequiredOpeningBalance, Integer lockinPeriodFrequency, SavingsPeriodFrequencyType lockinPeriodFrequencyType, boolean withdrawalFeeApplicableForTransfer, Set<SavingsAccountCharge> savingsAccountCharges, DepositAccountTermAndPreClosure accountTermAndPreClosure, DepositAccountInterestRateChart chart, boolean allowOverdraft, BigDecimal overdraftLimit, boolean withHoldTax) {
        super(client, group, product, fieldOfficer, accountNo, externalId, status, accountType, submittedOnDate, submittedBy, nominalAnnualInterestRate, interestCompoundingPeriodType, interestPostingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeApplicableForTransfer, savingsAccountCharges, allowOverdraft, overdraftLimit, withHoldTax);
        this.accountTermAndPreClosure = accountTermAndPreClosure;
        this.chart = chart;
        if (this.chart != null) {
            this.chart.updateDepositAccountReference((SavingsAccount)this);
        }
    }

    public void modifyApplication(JsonCommand command, Map<String, Object> actualChanges) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount.modify");
        super.modifyApplication(command, actualChanges, baseDataValidator);
        Map termAndPreClosureChanges = this._persistence_get_accountTermAndPreClosure().update(command, baseDataValidator);
        actualChanges.putAll(termAndPreClosureChanges);
        this.validateDomainRules(baseDataValidator);
        super.validateInterestPostingAndCompoundingPeriodTypes(baseDataValidator);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    protected BigDecimal getEffectiveInterestRateAsFraction(MathContext mc, LocalDate interestPostingUpToDate) {
        boolean isPreMatureClosure = false;
        return this.getEffectiveInterestRateAsFraction(mc, interestPostingUpToDate, isPreMatureClosure);
    }

    protected BigDecimal getEffectiveInterestRateAsFraction(MathContext mc, LocalDate interestPostingUpToDate, boolean isPreMatureClosure) {
        BigDecimal applicableInterestRate = this._persistence_get_nominalAnnualInterestRate();
        if (this._persistence_get_chart() != null) {
            boolean applyPreMaturePenalty = false;
            BigDecimal penalInterest = BigDecimal.ZERO;
            LocalDate depositCloseDate = this.calculateMaturityDate();
            if (isPreMatureClosure && this._persistence_get_accountTermAndPreClosure().isPreClosurePenalApplicable()) {
                applyPreMaturePenalty = true;
                penalInterest = this._persistence_get_accountTermAndPreClosure().depositPreClosureDetail().preClosurePenalInterest();
                PreClosurePenalInterestOnType preClosurePenalInterestOnType = this._persistence_get_accountTermAndPreClosure().depositPreClosureDetail().preClosurePenalInterestOnType();
                if (preClosurePenalInterestOnType.isWholeTerm()) {
                    depositCloseDate = this.interestCalculatedUpto();
                } else if (preClosurePenalInterestOnType.isTillPrematureWithdrawal()) {
                    depositCloseDate = interestPostingUpToDate;
                }
            }
            BigDecimal depositAmount = this._persistence_get_accountTermAndPreClosure().depositAmount();
            applicableInterestRate = this._persistence_get_chart().getApplicableInterestRate(depositAmount, this.depositStartDate(), depositCloseDate, this._persistence_get_client());
            if (applyPreMaturePenalty) {
                applicableInterestRate = (applicableInterestRate = applicableInterestRate.subtract(penalInterest)).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : applicableInterestRate;
            }
        }
        this._persistence_set_nominalAnnualInterestRate(applicableInterestRate);
        return applicableInterestRate.divide(BigDecimal.valueOf(100L), mc);
    }

    public void updateMaturityDateAndAmountBeforeAccountActivation(MathContext mc, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        ArrayList<SavingsAccountTransaction> allTransactions = new ArrayList<SavingsAccountTransaction>();
        String refNo = null;
        Money transactionAmountMoney = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_accountTermAndPreClosure().depositAmount());
        SavingsAccountTransaction transaction = SavingsAccountTransaction.deposit(null, (Office)this.office(), null, (LocalDate)this.accountSubmittedOrActivationDate(), (Money)transactionAmountMoney, refNo);
        transaction.setRunningBalance(transactionAmountMoney);
        transaction.updateCumulativeBalanceAndDates(this.getCurrency(), this.interestCalculatedUpto());
        allTransactions.add(transaction);
        this.updateMaturityDateAndAmount(mc, allTransactions, isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
    }

    public void updateMaturityDateAndAmount(MathContext mc, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        this.updateMaturityDateAndAmount(mc, this.retreiveOrderedNonInterestPostingTransactions(), isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
    }

    public void updateMaturityDateAndAmount(MathContext mc, List<SavingsAccountTransaction> transactions, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        LocalDate maturityDate = this.calculateMaturityDate();
        LocalDate interestCalculationUpto = maturityDate.minusDays(1L);
        this.resetAccountTransactionsEndOfDayBalances(transactions, maturityDate);
        List postingPeriods = this.calculateInterestPayable(mc, interestCalculationUpto, transactions, isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        this.resetAccountTransactionsEndOfDayBalances(transactions, DateUtils.getBusinessLocalDate());
        Money totalInterestPayable = Money.zero((MonetaryCurrency)this.getCurrency());
        for (PostingPeriod postingPeriod : postingPeriods) {
            totalInterestPayable = totalInterestPayable.plus(postingPeriod.getInterestEarned());
        }
        Money depositAmount = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_accountTermAndPreClosure().depositAmount());
        Money maturityAmount = depositAmount.plus(totalInterestPayable);
        this._persistence_get_accountTermAndPreClosure().updateMaturityDetails(maturityAmount.getAmount(), maturityDate);
    }

    public void updateMaturityStatus(boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount.updateMaturityDetails");
        SavingsAccountStatusType currentStatus = SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status());
        if (!SavingsAccountStatusType.ACTIVE.hasStateOf(currentStatus)) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("not.in.active.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (!DateUtils.isDateInTheFuture((LocalDate)this.maturityDate())) {
            this._persistence_set_status(SavingsAccountStatusType.MATURED.getValue());
            this.postMaturityInterest(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        }
    }

    public LocalDate calculateMaturityDate() {
        LocalDate startDate = this.accountSubmittedOrActivationDate();
        LocalDate maturityDate = null;
        Integer depositPeriod = this._persistence_get_accountTermAndPreClosure().depositPeriod();
        switch (1.$SwitchMap$org$apache$fineract$portfolio$savings$SavingsPeriodFrequencyType[this._persistence_get_accountTermAndPreClosure().depositPeriodFrequencyType().ordinal()]) {
            case 1: {
                maturityDate = startDate.plusDays(depositPeriod.intValue());
                break;
            }
            case 2: {
                maturityDate = startDate.plusWeeks(depositPeriod.intValue());
                break;
            }
            case 3: {
                maturityDate = startDate.plusMonths(depositPeriod.intValue());
                break;
            }
            case 4: {
                maturityDate = startDate.plusYears(depositPeriod.intValue());
                break;
            }
        }
        return maturityDate;
    }

    private List<PostingPeriod> calculateInterestPayable(MathContext mc, LocalDate maturityDate, List<SavingsAccountTransaction> transactions, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        SavingsPostingInterestPeriodType postingPeriodType = SavingsPostingInterestPeriodType.fromInt((Integer)this._persistence_get_interestPostingPeriodType());
        SavingsCompoundingInterestPeriodType compoundingPeriodType = SavingsCompoundingInterestPeriodType.fromInt((Integer)this._persistence_get_interestCompoundingPeriodType());
        SavingsInterestCalculationDaysInYearType daysInYearType = SavingsInterestCalculationDaysInYearType.fromInt((Integer)this._persistence_get_interestCalculationDaysInYearType());
        List postedAsOnTransactionDates = this.getManualPostingDates();
        List postingPeriodIntervals = this.savingsHelper.determineInterestPostingPeriods(this.accountSubmittedOrActivationDate(), maturityDate, postingPeriodType, financialYearBeginningMonth, postedAsOnTransactionDates);
        ArrayList<PostingPeriod> allPostingPeriods = new ArrayList<PostingPeriod>();
        Money periodStartingBalance = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        SavingsInterestCalculationType interestCalculationType = SavingsInterestCalculationType.fromInt((Integer)this._persistence_get_interestCalculationType());
        BigDecimal interestRateAsFraction = this.getEffectiveInterestRateAsFraction(mc, maturityDate, isPreMatureClosure);
        Collection interestPostTransactions = this.savingsHelper.fetchPostInterestTransactionIds((Long)this.getId());
        boolean isInterestTransfer = false;
        Money minBalanceForInterestCalculation = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this.minBalanceForInterestCalculation());
        List savingsAccountTransactionDetailsForPostingPeriodList = this.toSavingsAccountTransactionDetailsForPostingPeriodList(transactions);
        for (LocalDateInterval periodInterval : postingPeriodIntervals) {
            boolean isUserPosting = false;
            if (postedAsOnTransactionDates.contains(periodInterval.endDate())) {
                isUserPosting = true;
            }
            PostingPeriod postingPeriod = PostingPeriod.createFrom((LocalDateInterval)periodInterval, (Money)periodStartingBalance, (List)savingsAccountTransactionDetailsForPostingPeriodList, (MonetaryCurrency)this._persistence_get_currency(), (SavingsCompoundingInterestPeriodType)compoundingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (BigDecimal)interestRateAsFraction, (long)daysInYearType.getValue().intValue(), (LocalDate)maturityDate, (Collection)interestPostTransactions, (boolean)isInterestTransfer, (Money)minBalanceForInterestCalculation, (boolean)isSavingsInterestPostingAtCurrentPeriodEnd, (boolean)isUserPosting, (Integer)financialYearBeginningMonth);
            periodStartingBalance = postingPeriod.closingBalance();
            allPostingPeriods.add(postingPeriod);
        }
        this._persistence_get_summary().updateFromInterestPeriodSummaries(this._persistence_get_currency(), allPostingPeriods);
        this.savingsHelper.calculateInterestForAllPostingPeriods(this._persistence_get_currency(), allPostingPeriods, this.getLockedInUntilDate(), Boolean.valueOf(this.isTransferInterestToOtherAccount()));
        return allPostingPeriods;
    }

    public void prematureClosure(AppUser currentUser, JsonCommand command, Map<String, Object> actualChanges) {
        SavingsAccountTransaction accountTransaction;
        List savingsAccountTransactions;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount.preMatureClose");
        SavingsAccountStatusType currentStatus = SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status());
        if (!SavingsAccountStatusType.ACTIVE.hasStateOf(currentStatus)) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("not.in.active.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        if (DateUtils.isBefore((LocalDate)closedDate, (LocalDate)this.getActivationDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.activation.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (this.isAccountLocked(closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.lockin.period", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (this.maturityDate() != null && DateUtils.isAfter((LocalDate)closedDate, (LocalDate)this.maturityDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.before.maturity.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (DateUtils.isAfterBusinessDate((LocalDate)closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("cannot.be.a.future.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if ((savingsAccountTransactions = this.retrieveListOfTransactions()).size() > 0 && (accountTransaction = (SavingsAccountTransaction)savingsAccountTransactions.get(savingsAccountTransactions.size() - 1)).isAfter(closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.last.transaction.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        this.validateActivityNotBeforeClientOrGroupTransferDate(SavingsEvent.SAVINGS_CLOSE_ACCOUNT, closedDate);
        this._persistence_set_status(SavingsAccountStatusType.PRE_MATURE_CLOSURE.getValue());
        Integer onAccountClosureId = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        this._persistence_get_accountTermAndPreClosure().updateOnAccountClosureStatus(onClosureType);
        actualChanges.put("status", SavingsEnumerations.status((Integer)this._persistence_get_status()));
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("closedOnDate", closedDate.format(fmt));
        this._persistence_set_rejectedOnDate(null);
        this._persistence_set_rejectedBy(null);
        this._persistence_set_withdrawnOnDate(null);
        this._persistence_set_withdrawnBy(null);
        this._persistence_set_closedOnDate(closedDate);
        this._persistence_set_closedBy(currentUser);
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
    }

    public Money activateWithBalance() {
        return Money.of((MonetaryCurrency)this._persistence_get_currency(), (BigDecimal)this._persistence_get_accountTermAndPreClosure().depositAmount());
    }

    public void close(AppUser currentUser, JsonCommand command, Map<String, Object> actualChanges) {
        SavingsAccountTransaction accountTransaction;
        List savingsAccountTransactions;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount.close");
        SavingsAccountStatusType currentStatus = SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status());
        if (!SavingsAccountStatusType.MATURED.hasStateOf(currentStatus)) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("not.in.matured.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        if (DateUtils.isBefore((LocalDate)closedDate, (LocalDate)this.getActivationDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.activation.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (DateUtils.isBefore((LocalDate)closedDate, (LocalDate)this.maturityDate())) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.account.maturity.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (DateUtils.isAfterBusinessDate((LocalDate)closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("cannot.be.a.future.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if ((savingsAccountTransactions = this.retrieveListOfTransactions()).size() > 0 && (accountTransaction = (SavingsAccountTransaction)savingsAccountTransactions.get(savingsAccountTransactions.size() - 1)).isAfter(closedDate)) {
            baseDataValidator.reset().parameter("closedOnDate").value((Object)closedDate).failWithCode("must.be.after.last.transaction.date", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        this.validateActivityNotBeforeClientOrGroupTransferDate(SavingsEvent.SAVINGS_CLOSE_ACCOUNT, closedDate);
        this._persistence_set_status(SavingsAccountStatusType.CLOSED.getValue());
        Integer onAccountClosureId = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        this._persistence_get_accountTermAndPreClosure().updateOnAccountClosureStatus(onClosureType);
        actualChanges.put("status", SavingsEnumerations.status((Integer)this._persistence_get_status()));
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("closedOnDate", closedDate.format(fmt));
        this._persistence_set_rejectedOnDate(null);
        this._persistence_set_rejectedBy(null);
        this._persistence_set_withdrawnOnDate(null);
        this._persistence_set_withdrawnBy(null);
        this._persistence_set_closedOnDate(closedDate);
        this._persistence_set_closedBy(currentUser);
    }

    public void updateClosedStatus() {
        this._persistence_set_status(SavingsAccountStatusType.CLOSED.getValue());
    }

    public void updateOnAccountClosureStatus(DepositAccountOnClosureType onClosureType) {
        this._persistence_get_accountTermAndPreClosure().updateOnAccountClosureStatus(onClosureType);
    }

    public void postMaturityInterest(boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        LocalDate interestPostingUpToDate = this.maturityDate();
        MathContext mc = MathContext.DECIMAL64;
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean backdatedTxnsAllowedTill = false;
        boolean postReversals = false;
        List postingPeriods = this.calculateInterestUsing(mc, interestPostingUpToDate, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        Money interestPostedToDate = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        boolean recalucateDailyBalanceDetails = false;
        for (PostingPeriod interestPostingPeriod : postingPeriods) {
            LocalDate interestPostingTransactionDate = interestPostingPeriod.dateOfPostingTransaction();
            interestPostingTransactionDate = DateUtils.isAfter((LocalDate)interestPostingTransactionDate, (LocalDate)interestPostingUpToDate) ? interestPostingUpToDate : interestPostingTransactionDate;
            Money interestEarnedToBePostedForPeriod = interestPostingPeriod.getInterestEarned();
            interestPostedToDate = interestPostedToDate.plus(interestEarnedToBePostedForPeriod);
            SavingsAccountTransaction postingTransaction = this.findInterestPostingTransactionFor(interestPostingTransactionDate);
            if (postingTransaction == null) {
                SavingsAccountTransaction newPostingTransaction = SavingsAccountTransaction.interestPosting((SavingsAccount)this, (Office)this.office(), (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod, (boolean)interestPostingPeriod.isUserPosting());
                this._persistence_get_transactions().add(newPostingTransaction);
                recalucateDailyBalanceDetails = true;
                continue;
            }
            boolean correctionRequired = postingTransaction.hasNotAmount(interestEarnedToBePostedForPeriod);
            if (!correctionRequired) continue;
            postingTransaction.reverse();
            SavingsAccountTransaction newPostingTransaction = SavingsAccountTransaction.interestPosting((SavingsAccount)this, (Office)this.office(), (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod, (boolean)interestPostingPeriod.isUserPosting());
            this._persistence_get_transactions().add(newPostingTransaction);
            recalucateDailyBalanceDetails = true;
        }
        if (recalucateDailyBalanceDetails = this.applyWithholdTaxForDepositAccounts(interestPostingUpToDate, recalucateDailyBalanceDetails, false)) {
            this.recalculateDailyBalances(Money.zero((MonetaryCurrency)this._persistence_get_currency()), interestPostingUpToDate, false, postReversals);
        }
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
    }

    public void postPreMaturityInterest(LocalDate accountCloseDate, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        Money interestPostedToDate = this.totalInterestPosted();
        LocalDate interestCalculatedToDate = accountCloseDate.minusDays(1L);
        Money interestOnMaturity = this.calculatePreMatureInterest(interestCalculatedToDate, this.retreiveOrderedNonInterestPostingTransactions(), isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        boolean recalucateDailyBalance = false;
        Money remainigInterestToBePosted = interestOnMaturity.minus(interestPostedToDate);
        boolean backdatedTxnsAllowedTill = false;
        if (!remainigInterestToBePosted.isZero()) {
            boolean postInterestAsOn = false;
            SavingsAccountTransaction newPostingTransaction = SavingsAccountTransaction.interestPosting((SavingsAccount)this, (Office)this.office(), (LocalDate)accountCloseDate, (Money)remainigInterestToBePosted, (boolean)false);
            this._persistence_get_transactions().add(newPostingTransaction);
            recalucateDailyBalance = true;
        }
        recalucateDailyBalance = this.applyWithholdTaxForDepositAccounts(accountCloseDate, recalucateDailyBalance, false);
        boolean postReversals = false;
        if (recalucateDailyBalance) {
            this.recalculateDailyBalances(Money.zero((MonetaryCurrency)this._persistence_get_currency()), accountCloseDate, false, postReversals);
        }
        this._persistence_get_summary().updateSummary(this._persistence_get_currency(), this.savingsAccountTransactionSummaryWrapper, this._persistence_get_transactions());
        this._persistence_get_accountTermAndPreClosure().updateMaturityDetails(this.getAccountBalance(), accountCloseDate);
    }

    public BigDecimal calculatePreMatureAmount(LocalDate preMatureDate, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        Money interestPostedToDate = this.totalInterestPosted().copy();
        Money interestEarnedTillDate = this.calculatePreMatureInterest(preMatureDate, this.retreiveOrderedNonInterestPostingTransactions(), isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Money accountBalance = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this.getAccountBalance());
        Money maturityAmount = accountBalance.minus(interestPostedToDate).plus(interestEarnedTillDate);
        return maturityAmount.getAmount();
    }

    private Money calculatePreMatureInterest(LocalDate preMatureDate, List<SavingsAccountTransaction> transactions, boolean isPreMatureClosure, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        MathContext mc = MathContext.DECIMAL64;
        List postingPeriods = this.calculateInterestPayable(mc, preMatureDate, transactions, isPreMatureClosure, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Money interestOnMaturity = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        for (PostingPeriod interestPostingPeriod : postingPeriods) {
            Money interestEarnedForPeriod = interestPostingPeriod.getInterestEarned();
            interestOnMaturity = interestOnMaturity.plus(interestEarnedForPeriod);
        }
        return interestOnMaturity;
    }

    public void postInterest(MathContext mc, LocalDate postingDate, boolean isInterestTransfer, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate postInterestOnDate, boolean backdatedTxnsAllowedTill) {
        LocalDate interestPostingUpToDate = this.interestPostingUpToDate(postingDate);
        boolean postReversals = false;
        super.postInterest(mc, interestPostingUpToDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, postReversals);
    }

    public List<PostingPeriod> calculateInterestUsing(MathContext mc, LocalDate postingDate, boolean isInterestTransfer, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate postAsInterestOn, boolean backdatedTxnsAllowedTill, boolean postReversals) {
        LocalDate interestPostingUpToDate = this.interestPostingUpToDate(postingDate);
        return super.calculateInterestUsing(mc, interestPostingUpToDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postAsInterestOn, backdatedTxnsAllowedTill, postReversals);
    }

    private LocalDate interestPostingUpToDate(LocalDate interestPostingDate) {
        LocalDate interestPostingUpToDate = interestPostingDate;
        LocalDate uptoMaturityDate = this.interestCalculatedUpto();
        if (uptoMaturityDate != null && DateUtils.isBefore((LocalDate)uptoMaturityDate, (LocalDate)interestPostingDate)) {
            interestPostingUpToDate = uptoMaturityDate;
        }
        return interestPostingUpToDate;
    }

    public LocalDate maturityDate() {
        return this._persistence_get_accountTermAndPreClosure().getMaturityDate();
    }

    public BigDecimal maturityAmount() {
        return this._persistence_get_accountTermAndPreClosure().maturityAmount();
    }

    private Money totalInterestPosted() {
        Money interestPostedToDate = Money.zero((MonetaryCurrency)this._persistence_get_currency());
        for (SavingsAccountTransaction transaction : this._persistence_get_transactions()) {
            if (!transaction.isInterestPostingAndNotReversed()) continue;
            interestPostedToDate = interestPostedToDate.plus(transaction.getAmount(this._persistence_get_currency()));
        }
        return interestPostedToDate;
    }

    public Map<String, Object> activate(AppUser currentUser, JsonCommand command) {
        Map actualChanges = super.activate(currentUser, command);
        return actualChanges;
    }

    private LocalDate depositStartDate() {
        LocalDate depositStartDate = this.accountSubmittedOrActivationDate();
        return depositStartDate;
    }

    private LocalDate interestCalculatedUpto() {
        LocalDate uptoMaturityDate = this.calculateMaturityDate();
        if (uptoMaturityDate != null) {
            uptoMaturityDate = uptoMaturityDate.minusDays(1L);
        }
        return uptoMaturityDate;
    }

    public void validateDomainRules() {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositaccount");
        this.validateDomainRules(baseDataValidator);
        super.validateInterestPostingAndCompoundingPeriodTypes(baseDataValidator);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateDomainRules(DataValidatorBuilder baseDataValidator) {
        boolean isMinTermGreaterThanMax = this._persistence_get_accountTermAndPreClosure().depositTermDetail().isMinDepositTermGreaterThanMaxDepositTerm();
        boolean isValidDepositPeriod = this._persistence_get_accountTermAndPreClosure().depositTermDetail().isDepositBetweenMinAndMax(this.depositStartDate(), this.calculateMaturityDate());
        if (isMinTermGreaterThanMax) {
            Integer maxTerm = this._persistence_get_accountTermAndPreClosure().depositTermDetail().maxDepositTerm();
            baseDataValidator.reset().parameter("maxDepositTerm").value((Object)maxTerm).failWithCodeNoParameterAddedToErrorCode("max.term.lessthan.min.term", new Object[0]);
        }
        Integer depositPeriod = this._persistence_get_accountTermAndPreClosure().depositPeriod();
        SavingsPeriodFrequencyType depositPeriodFrequencyType = this._persistence_get_accountTermAndPreClosure().depositPeriodFrequencyType();
        if (!isValidDepositPeriod) {
            baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).failWithCodeNoParameterAddedToErrorCode("deposit.period.not.between.min.and.max.deposit.term", new Object[0]);
        } else {
            boolean isValid;
            Integer inMultiplesOf = this._persistence_get_accountTermAndPreClosure().depositTermDetail().inMultiplesOfDepositTerm();
            if (inMultiplesOf != null && !(isValid = this._persistence_get_accountTermAndPreClosure().depositTermDetail().isValidInMultiplesOfPeriod(depositPeriod, depositPeriodFrequencyType))) {
                baseDataValidator.reset().parameter("depositPeriod").value((Object)depositPeriod).failWithCodeNoParameterAddedToErrorCode("deposit.period.not.multiple.of.term", new Object[0]);
            }
        }
        if (this._persistence_get_chart() != null) {
            LocalDate chartEndDate;
            LocalDate chartFromDate = this._persistence_get_chart().getFromDate();
            LocalDateInterval chartInterval = LocalDateInterval.create((LocalDate)chartFromDate, (LocalDate)(chartEndDate = (chartEndDate = this._persistence_get_chart().getEndDate()) == null ? DateUtils.getBusinessLocalDate() : chartEndDate));
            if (!chartInterval.contains(this.accountSubmittedOrActivationDate())) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("no.valid.interest.rate.slab.available", new Object[0]);
            }
            BigDecimal depositAmount = this._persistence_get_accountTermAndPreClosure().depositAmount();
            BigDecimal applicableInterestRate = this._persistence_get_chart().getApplicableInterestRate(depositAmount, this.depositStartDate(), this.calculateMaturityDate(), this._persistence_get_client());
            if (applicableInterestRate.compareTo(BigDecimal.ZERO) == 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("no.applicable.interest.rate.is.found.based.on.amount.and.deposit.period", new Object[0]);
            }
        } else if (this._persistence_get_nominalAnnualInterestRate() == null || this._persistence_get_nominalAnnualInterestRate().compareTo(BigDecimal.ZERO) == 0) {
            baseDataValidator.reset().parameter("nominalAnnualInterestRate").value((Object)this._persistence_get_nominalAnnualInterestRate()).failWithCodeNoParameterAddedToErrorCode("valid.interest.chart.or.nominal.interest.rate.required", new Object[0]);
        }
    }

    public boolean isReinvestOnClosure() {
        return this._persistence_get_accountTermAndPreClosure().isReinvestOnClosure();
    }

    public boolean isTransferToSavingsOnClosure() {
        return this._persistence_get_accountTermAndPreClosure().isTransferToSavingsOnClosure();
    }

    public Integer getOnAccountClosureId() {
        return this._persistence_get_accountTermAndPreClosure().getOnAccountClosureType();
    }

    public Long getTransferToSavingsAccountId() {
        return this._persistence_get_accountTermAndPreClosure().getTransferToSavingsAccountId();
    }

    public FixedDepositAccount reInvest(BigDecimal depositAmount) {
        DepositAccountTermAndPreClosure newAccountTermAndPreClosure = this._persistence_get_accountTermAndPreClosure().copy(depositAmount);
        SavingsProduct product = this._persistence_get_product();
        InterestRateChart productChart = product.applicableChart(this.getClosedOnDate());
        DepositAccountInterestRateChart newChart = DepositAccountInterestRateChart.from((InterestRateChart)productChart);
        AccountType accountType = AccountType.fromInt((Integer)this._persistence_get_accountType());
        SavingsPostingInterestPeriodType postingPeriodType = SavingsPostingInterestPeriodType.fromInt((Integer)this._persistence_get_interestPostingPeriodType());
        SavingsCompoundingInterestPeriodType compoundingPeriodType = SavingsCompoundingInterestPeriodType.fromInt((Integer)this._persistence_get_interestCompoundingPeriodType());
        SavingsInterestCalculationType interestCalculationType = SavingsInterestCalculationType.fromInt((Integer)this._persistence_get_interestCalculationType());
        SavingsInterestCalculationDaysInYearType daysInYearType = SavingsInterestCalculationDaysInYearType.fromInt((Integer)this._persistence_get_interestCalculationDaysInYearType());
        BigDecimal minRequiredOpeningBalance = null;
        BigDecimal interestRate = BigDecimal.ZERO;
        Set savingsAccountCharges = null;
        SavingsPeriodFrequencyType lockinPeriodFrequencyType = SavingsPeriodFrequencyType.fromInt((Integer)this._persistence_get_lockinPeriodFrequencyType());
        Integer lockinPeriodFrequency = this._persistence_get_lockinPeriodFrequency();
        boolean withdrawalFeeApplicableForTransfer = false;
        String accountNumber = null;
        boolean withHoldTax = this._persistence_get_withHoldTax();
        FixedDepositAccount reInvestedAccount = FixedDepositAccount.createNewApplicationForSubmittal((Client)this._persistence_get_client(), (Group)this._persistence_get_group(), (SavingsProduct)product, (Staff)this._persistence_get_savingsOfficer(), accountNumber, (ExternalId)this._persistence_get_externalId(), (AccountType)accountType, (LocalDate)this.getClosedOnDate(), (AppUser)this._persistence_get_closedBy(), (BigDecimal)interestRate, (SavingsCompoundingInterestPeriodType)compoundingPeriodType, (SavingsPostingInterestPeriodType)postingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (SavingsInterestCalculationDaysInYearType)daysInYearType, minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (SavingsPeriodFrequencyType)lockinPeriodFrequencyType, (boolean)false, savingsAccountCharges, (DepositAccountTermAndPreClosure)newAccountTermAndPreClosure, (DepositAccountInterestRateChart)newChart, (boolean)withHoldTax);
        newAccountTermAndPreClosure.updateAccountReference((SavingsAccount)reInvestedAccount);
        newChart.updateDepositAccountReference((SavingsAccount)reInvestedAccount);
        return reInvestedAccount;
    }

    protected boolean isTransferInterestToOtherAccount() {
        return this._persistence_get_accountTermAndPreClosure().isTransferInterestToLinkedAccount();
    }

    public boolean allowDeposit() {
        return false;
    }

    public boolean allowWithdrawal() {
        return false;
    }

    public boolean allowModify() {
        return false;
    }

    public boolean isTransactionsAllowed() {
        return this.isActive() || this.isAccountMatured();
    }

    private boolean isAccountMatured() {
        return SavingsAccountStatusType.fromInt((Integer)this._persistence_get_status()).isMatured();
    }

    public BigDecimal minBalanceForInterestCalculation() {
        return null;
    }

    public void loadLazyCollections() {
        super.loadLazyCollections();
        this._persistence_get_chart().getId();
    }

    public BigDecimal getDepositAmount() {
        return this._persistence_get_accountTermAndPreClosure().depositAmount();
    }

    public BigDecimal getAccountBalance() {
        return this._persistence_get_summary().getAccountBalance(this._persistence_get_currency()).getAmount();
    }

    public boolean isMatured() {
        return SavingsAccountStatusType.MATURED.getValue().equals(this._persistence_get_status());
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_chart_vh != null) {
            this._persistence_chart_vh = (WeavedAttributeValueHolderInterface)this._persistence_chart_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new FixedDepositAccount();
    }

    public Object _persistence_get(String string) {
        if (string == "accountTermAndPreClosure") {
            return this.accountTermAndPreClosure;
        }
        if (string == "chart") {
            return this.chart;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "accountTermAndPreClosure") {
            this.accountTermAndPreClosure = (DepositAccountTermAndPreClosure)object;
            return;
        }
        if (string == "chart") {
            this.chart = (DepositAccountInterestRateChart)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public DepositAccountTermAndPreClosure _persistence_get_accountTermAndPreClosure() {
        this._persistence_checkFetched("accountTermAndPreClosure");
        return this.accountTermAndPreClosure;
    }

    public void _persistence_set_accountTermAndPreClosure(DepositAccountTermAndPreClosure depositAccountTermAndPreClosure) {
        this._persistence_checkFetchedForSet("accountTermAndPreClosure");
        this._persistence_propertyChange("accountTermAndPreClosure", (Object)this.accountTermAndPreClosure, (Object)depositAccountTermAndPreClosure);
        this.accountTermAndPreClosure = depositAccountTermAndPreClosure;
    }

    protected void _persistence_initialize_chart_vh() {
        if (this._persistence_chart_vh == null) {
            this._persistence_chart_vh = new ValueHolder((Object)this.chart);
            this._persistence_chart_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_chart_vh() {
        DepositAccountInterestRateChart depositAccountInterestRateChart;
        this._persistence_initialize_chart_vh();
        if ((this._persistence_chart_vh.isCoordinatedWithProperty() || this._persistence_chart_vh.isNewlyWeavedValueHolder()) && (depositAccountInterestRateChart = this._persistence_get_chart()) != this._persistence_chart_vh.getValue()) {
            this._persistence_set_chart(depositAccountInterestRateChart);
        }
        return this._persistence_chart_vh;
    }

    public void _persistence_set_chart_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_chart_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            DepositAccountInterestRateChart depositAccountInterestRateChart = this._persistence_get_chart();
            if (depositAccountInterestRateChart != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_chart((DepositAccountInterestRateChart)object);
            }
        } else {
            this.chart = null;
        }
    }

    public DepositAccountInterestRateChart _persistence_get_chart() {
        this._persistence_checkFetched("chart");
        this._persistence_initialize_chart_vh();
        this.chart = (DepositAccountInterestRateChart)this._persistence_chart_vh.getValue();
        return this.chart;
    }

    public void _persistence_set_chart(DepositAccountInterestRateChart depositAccountInterestRateChart) {
        this._persistence_checkFetchedForSet("chart");
        this._persistence_initialize_chart_vh();
        this.chart = (DepositAccountInterestRateChart)this._persistence_chart_vh.getValue();
        this._persistence_propertyChange("chart", (Object)this.chart, (Object)depositAccountInterestRateChart);
        this.chart = depositAccountInterestRateChart;
        this._persistence_chart_vh.setValue((Object)depositAccountInterestRateChart);
    }
}

