/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.common.AccountingEnumerations;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingReadPlatformService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.api.SavingsProductsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.fineract.portfolio.savings.service.SavingsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/savingsproducts")
@Component
@Tag(name="Savings Product", description="An MFIs savings product offerings are modeled using this API.\nWhen creating savings accounts, the details from the savings product are used to auto fill details of the savings account application process.")
public class SavingsProductsApiResource {
    private final SavingsProductReadPlatformService savingProductReadPlatformService;
    private final SavingsDropdownReadPlatformService dropdownReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<SavingsProductData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;
    private final ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final TaxReadPlatformService taxReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Savings Product", description="Creates a Savings Product\n\nMandatory Fields: name, shortName, description, currencyCode, digitsAfterDecimal,inMultiplesOf, nominalAnnualInterestRate, interestCompoundingPeriodType, interestCalculationType, interestCalculationDaysInYearType,accountingRule\n\nMandatory Fields for Cash based accounting (accountingRule = 2): savingsReferenceAccountId, savingsControlAccountId, interestOnSavingsAccountId, incomeFromFeeAccountId, transfersInSuspenseAccountId, incomeFromPenaltyAccountId\n\nOptional Fields: minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeForTransfers, paymentChannelToFundSourceMappings, feeToIncomeAccountMappings, penaltyToIncomeAccountMappings, charges, allowOverdraft, overdraftLimit, minBalanceForInterestCalculation,withHoldTax,taxGroupId,accountMapping, lienAllowed, maxAllowedLienLimit")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.PostSavingsProductsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.PostSavingsProductsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createSavingProduct().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Savings Product", description="Updates a Savings Product")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.PutSavingsProductsProductIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.PutSavingsProductsProductIdResponse.class))})})
    public String update(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateSavingProduct(productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Savings Products", description="Lists Savings Products\n\nExample Requests:\n\nsavingsproducts\n\nsavingsproducts?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.GetSavingsProductsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsproduct");
        Collection products = this.savingProductReadPlatformService.retrieveAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, products, SavingsApiSetConstants.SAVINGS_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Savings Product", description="Retrieves a Savings Product\n\nExample Requests:\n\nsavingsproducts/1\n\nsavingsproducts/1?template=true\n\nsavingsproducts/1?fields=name,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.GetSavingsProductsProductIdResponse.class))})})
    public String retrieveOne(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsproduct");
        SavingsProductData savingProductData = this.savingProductReadPlatformService.retrieveOne(productId);
        List charges = this.chargeReadPlatformService.retrieveSavingsProductCharges(productId);
        savingProductData = SavingsProductData.withCharges((SavingsProductData)savingProductData, (Collection)charges);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (savingProductData.hasAccountingEnabled()) {
            Map accountingMappings = this.accountMappingReadPlatformService.fetchAccountMappingDetailsForSavingsProduct(productId, Integer.valueOf(savingProductData.accountingRuleTypeId()));
            List paymentChannelToFundSourceMappings = this.accountMappingReadPlatformService.fetchPaymentTypeToFundSourceMappingsForSavingsProduct(productId);
            List feeToGLAccountMappings = this.accountMappingReadPlatformService.fetchFeeToIncomeAccountMappingsForSavingsProduct(productId);
            List penaltyToGLAccountMappings = this.accountMappingReadPlatformService.fetchPenaltyToIncomeAccountMappingsForSavingsProduct(productId);
            savingProductData = SavingsProductData.withAccountingDetails((SavingsProductData)savingProductData, (Map)accountingMappings, (Collection)paymentChannelToFundSourceMappings, (Collection)feeToGLAccountMappings, (Collection)penaltyToGLAccountMappings);
        }
        if (settings.isTemplate()) {
            savingProductData = this.handleTemplateRelatedData(savingProductData);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)savingProductData, SavingsApiSetConstants.SAVINGS_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Savings Product Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\nAccount Mapping:\n\nsavingsproducts/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.GetSavingsProductsTemplateResponse.class))})})
    public String retrieveTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsproduct");
        SavingsProductData savingProduct = this.handleTemplateRelatedData(null);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)savingProduct, SavingsApiSetConstants.SAVINGS_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    private SavingsProductData handleTemplateRelatedData(SavingsProductData savingsProduct) {
        EnumOptionData interestCompoundingPeriodType = SavingsEnumerations.compoundingInterestPeriodType((SavingsCompoundingInterestPeriodType)SavingsCompoundingInterestPeriodType.DAILY);
        EnumOptionData interestPostingPeriodType = SavingsEnumerations.interestPostingPeriodType((SavingsPostingInterestPeriodType)SavingsPostingInterestPeriodType.MONTHLY);
        EnumOptionData interestCalculationType = SavingsEnumerations.interestCalculationType((SavingsInterestCalculationType)SavingsInterestCalculationType.DAILY_BALANCE);
        EnumOptionData interestCalculationDaysInYearType = SavingsEnumerations.interestCalculationDaysInYearType((SavingsInterestCalculationDaysInYearType)SavingsInterestCalculationDaysInYearType.DAYS_365);
        EnumOptionData accountingRule = AccountingEnumerations.accountingRuleType((AccountingRuleType)AccountingRuleType.NONE);
        CurrencyData currency = CurrencyData.blank();
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        if (currencyOptions.size() == 1) {
            currency = (CurrencyData)new ArrayList(currencyOptions).get(0);
        }
        Collection interestCompoundingPeriodTypeOptions = this.dropdownReadPlatformService.retrieveCompoundingInterestPeriodTypeOptions();
        Collection interestPostingPeriodTypeOptions = this.dropdownReadPlatformService.retrieveInterestPostingPeriodTypeOptions();
        Collection interestCalculationTypeOptions = this.dropdownReadPlatformService.retrieveInterestCalculationTypeOptions();
        Collection interestCalculationDaysInYearTypeOptions = this.dropdownReadPlatformService.retrieveInterestCalculationDaysInYearTypeOptions();
        Collection lockinPeriodFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
        Collection withdrawalFeeTypeOptions = this.dropdownReadPlatformService.retrievewithdrawalFeeTypeOptions();
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        List accountingRuleOptions = this.accountingDropdownReadPlatformService.retrieveAccountingRuleTypeOptions();
        Map accountingMappingOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForSavingsProducts();
        String accountMappingForPayment = this.configurationDomainService.getAccountMappingForPaymentType();
        boolean feeChargesOnly = false;
        List chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(false);
        chargeOptions = CollectionUtils.isEmpty((Collection)chargeOptions) ? null : chargeOptions;
        List penaltyOptions = this.chargeReadPlatformService.retrieveSavingsApplicablePenalties();
        penaltyOptions = CollectionUtils.isEmpty((Collection)penaltyOptions) ? null : penaltyOptions;
        List taxGroupOptions = this.taxReadPlatformService.retrieveTaxGroupsForLookUp();
        SavingsProductData savingsProductToReturn = null;
        savingsProductToReturn = savingsProduct != null ? SavingsProductData.withTemplate((SavingsProductData)savingsProduct, (Collection)currencyOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, (Collection)paymentTypeOptions, (Collection)accountingRuleOptions, (Map)accountingMappingOptions, (Collection)chargeOptions, (Collection)penaltyOptions, (Collection)taxGroupOptions, (String)accountMappingForPayment) : SavingsProductData.template((CurrencyData)currency, (EnumOptionData)interestCompoundingPeriodType, (EnumOptionData)interestPostingPeriodType, (EnumOptionData)interestCalculationType, (EnumOptionData)interestCalculationDaysInYearType, (EnumOptionData)accountingRule, (Collection)currencyOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, (Collection)paymentTypeOptions, (Collection)accountingRuleOptions, (Map)accountingMappingOptions, (Collection)chargeOptions, (Collection)penaltyOptions, (Collection)taxGroupOptions, (String)accountMappingForPayment);
        return savingsProductToReturn;
    }

    @DELETE
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Savings Product", description="Deletes a Savings Product")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsProductsApiResourceSwagger.DeleteSavingsProductsProductIdResponse.class))})})
    public String delete(@PathParam(value="productId") @Parameter(description="productId") Long productId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteSavingProduct(productId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public SavingsProductsApiResource(SavingsProductReadPlatformService savingProductReadPlatformService, SavingsDropdownReadPlatformService dropdownReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<SavingsProductData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService, ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, TaxReadPlatformService taxReadPlatformService, ConfigurationDomainService configurationDomainService) {
        this.savingProductReadPlatformService = savingProductReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
        this.accountMappingReadPlatformService = accountMappingReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.taxReadPlatformService = taxReadPlatformService;
        this.configurationDomainService = configurationDomainService;
    }
}

