/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.reaging;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.ChangeOperation;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.springframework.stereotype.Component;

@Component
public class LoanReAgingValidator {
    public void validateReAge(Loan loan, JsonCommand command) {
        this.validateReAgeRequest(loan, command);
        this.validateReAgeBusinessRules(loan);
    }

    private void validateReAgeRequest(Loan loan, JsonCommand command) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.reAge");
        String externalId = command.stringValueOfParameterNamedAllowingNull("externalId");
        baseDataValidator.reset().parameter("externalId").ignoreIfNull().value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        LocalDate startDate = command.localDateValueOfParameterNamed("startDate");
        baseDataValidator.reset().parameter("startDate").value((Object)startDate).notNull().validateDateAfter(loan.getMaturityDate());
        String frequencyType = command.stringValueOfParameterNamedAllowingNull("frequencyType");
        baseDataValidator.reset().parameter("frequencyType").value((Object)frequencyType).notNull();
        Integer frequencyNumber = command.integerValueOfParameterNamed("frequencyNumber");
        baseDataValidator.reset().parameter("frequencyNumber").value((Object)frequencyNumber).notNull().integerGreaterThanZero();
        Integer numberOfInstallments = command.integerValueOfParameterNamed("numberOfInstallments");
        baseDataValidator.reset().parameter("numberOfInstallments").value((Object)numberOfInstallments).notNull().integerGreaterThanZero();
        this.throwExceptionIfValidationErrorsExist(dataValidationErrors);
    }

    private void validateReAgeBusinessRules(Loan loan) {
        if (DateUtils.isBefore((LocalDate)DateUtils.getBusinessLocalDate(), (LocalDate)loan.getMaturityDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.cannot.be.submitted.before.maturity", "Loan cannot be re-aged before maturity", new Object[]{loan.getId()});
        }
        LoanScheduleType loanScheduleType = LoanScheduleType.valueOf((String)loan.getLoanProductRelatedDetail().getLoanScheduleType().name());
        boolean isProgressiveSchedule = LoanScheduleType.PROGRESSIVE.equals((Object)loanScheduleType);
        String transactionProcessingStrategyCode = loan.getTransactionProcessingStrategyCode();
        boolean isAdvancedPaymentSchedule = "advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode);
        if (!isProgressiveSchedule || !isAdvancedPaymentSchedule) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.supported.only.for.progressive.loan.schedule.type", "Loan reaging is only available for progressive repayment schedule and Advanced payment allocation strategy", new Object[]{loan.getId()});
        }
        if (loan.isInterestBearing()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.supported.only.for.non.interest.loans", "Loan reaging is only available for non-interest bearing loans", new Object[]{loan.getId()});
        }
        if (!loan.getStatus().isActive()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.supported.only.for.active.loans", "Loan reaging can only be done on active loans", new Object[]{loan.getId()});
        }
        boolean isReAgingTransactionForTodayPresent = loan.getLoanTransactions().stream().anyMatch(tx -> tx.getTypeOf().isReAge() && tx.getTransactionDate().equals(DateUtils.getBusinessLocalDate()));
        if (isReAgingTransactionForTodayPresent) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.reage.transaction.already.present.for.today", "Loan reaging can only be done once a day. There has already been a reaging done for today", new Object[]{loan.getId()});
        }
    }

    public void validateUndoReAge(Loan loan, JsonCommand command) {
        this.validateUndoReAgeBusinessRules(loan);
    }

    private void validateUndoReAgeBusinessRules(Loan loan) {
        Optional<LoanTransaction> optionalReAgingTx = loan.getLoanTransactions().stream().filter(tx -> tx.getTypeOf().isReAge()).min(Comparator.comparing(LoanTransaction::getTransactionDate));
        if (optionalReAgingTx.isEmpty()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.reaging.transaction.missing", "Undoing a reaging can only be done if there was a reaging already", new Object[]{loan.getId()});
        }
        boolean repaymentExistsAfterReAging = loan.getLoanTransactions().stream().anyMatch(tx -> tx.getTypeOf().isRepaymentType() && this.transactionHappenedAfterOther(tx, (LoanTransaction)optionalReAgingTx.get()));
        if (repaymentExistsAfterReAging) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.repayment.exists.after.reaging", "Undoing a reaging can only be done if there hasn't been any repayment afterwards", new Object[]{loan.getId()});
        }
    }

    private void throwExceptionIfValidationErrorsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    private boolean transactionHappenedAfterOther(LoanTransaction transaction, LoanTransaction otherTransaction) {
        return new ChangeOperation(transaction).compareTo(new ChangeOperation(otherTransaction)) > 0;
    }
}

