/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.loanaccount.data.AccountingBridgeDataDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanAccountingBridgeMapper;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.springframework.stereotype.Component;

@Component
public class LoanJournalEntryPosterImpl
implements LoanJournalEntryPoster {
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;
    private final LoanAccountingBridgeMapper loanAccountingBridgeMapper;

    public void postJournalEntries(Loan loan, List<Long> existingTransactionIds, List<Long> existingReversedTransactionIds) {
        MonetaryCurrency currency = loan.getCurrency();
        boolean isAccountTransfer = false;
        if (loan.isChargedOff()) {
            List accountingBridgeDataList = this.loanAccountingBridgeMapper.deriveAccountingBridgeDataForChargeOff(currency.getCode(), existingTransactionIds, existingReversedTransactionIds, isAccountTransfer, loan);
            for (AccountingBridgeDataDTO accountingBridgeData : accountingBridgeDataList) {
                this.journalEntryWritePlatformService.createJournalEntriesForLoan(accountingBridgeData);
            }
        } else {
            AccountingBridgeDataDTO accountingBridgeData = this.loanAccountingBridgeMapper.deriveAccountingBridgeData(currency.getCode(), existingTransactionIds, existingReversedTransactionIds, isAccountTransfer, loan);
            this.journalEntryWritePlatformService.createJournalEntriesForLoan(accountingBridgeData);
        }
    }

    @Generated
    public LoanJournalEntryPosterImpl(JournalEntryWritePlatformService journalEntryWritePlatformService, LoanAccountingBridgeMapper loanAccountingBridgeMapper) {
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
        this.loanAccountingBridgeMapper = loanAccountingBridgeMapper;
    }
}

