/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.service;

import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementDomain;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.exception.ClientCollateralCannotBeDeletedException;
import org.apache.fineract.portfolio.collateralmanagement.exception.ClientCollateralNotFoundException;
import org.apache.fineract.portfolio.collateralmanagement.exception.CollateralNotFoundException;
import org.apache.fineract.portfolio.collateralmanagement.service.ClientCollateralManagementWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;

public class ClientCollateralManagementWritePlatformServiceImpl
implements ClientCollateralManagementWritePlatformService {
    private final ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper;
    private final CollateralManagementRepositoryWrapper collateralManagementRepositoryWrapper;
    private final ClientRepositoryWrapper clientRepositoryWrapper;

    @Transactional
    public CommandProcessingResult addClientCollateralProduct(JsonCommand command) {
        this.validateForCreation(command);
        Long collateralId = command.longValueOfParameterNamed("collateralId");
        BigDecimal quantity = command.bigDecimalValueOfParameterNamed("quantity");
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(command.getClientId(), false);
        CollateralManagementDomain collateralManagementData = this.collateralManagementRepositoryWrapper.getCollateral(collateralId);
        ClientCollateralManagement clientCollateralManagement = ClientCollateralManagement.createNew((BigDecimal)quantity, (Client)client, (CollateralManagementDomain)collateralManagementData);
        this.clientCollateralManagementRepositoryWrapper.saveAndFlush(clientCollateralManagement);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(command.getClientId()).withEntityId((Long)clientCollateralManagement.getId()).build();
    }

    private void validateForCreation(JsonCommand command) {
        Object errorCode = "parameter.";
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client-collateral");
        if (!command.parameterExists("collateralId")) {
            errorCode = (String)errorCode + "collateralId.not.exists";
            baseDataValidator.reset().parameter("collateralId").failWithCode((String)errorCode, new Object[0]);
        }
        if (!command.parameterExists("quantity")) {
            errorCode = (String)errorCode + ".quantity.not.exists";
            baseDataValidator.reset().parameter("quantity").failWithCode((String)errorCode, new Object[0]);
        } else {
            BigDecimal quantity = command.bigDecimalValueOfParameterNamed("quantity");
            baseDataValidator.reset().parameter("quantity").value((Object)quantity).notNull().positiveAmount();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    @Transactional
    public CommandProcessingResult updateClientCollateralProduct(JsonCommand command) {
        this.validateForUpdate(command);
        ClientCollateralManagement collateral = this.clientCollateralManagementRepositoryWrapper.getCollateral(command.entityId());
        Map changes = collateral.update(command);
        this.clientCollateralManagementRepositoryWrapper.updateClientCollateralProduct(collateral);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(command.entityId()).withClientId(command.getClientId()).with(changes).build();
    }

    private void validateForUpdate(JsonCommand command) {
        Long clientCollateralId = command.entityId();
        Object errorCode = "parameter.";
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client-collateral");
        BigDecimal quantity = null;
        if (!command.parameterExists("quantity")) {
            errorCode = (String)errorCode + ".quantity.not.exists";
            baseDataValidator.reset().parameter("quantity").failWithCode((String)errorCode, new Object[0]);
        } else {
            quantity = command.bigDecimalValueOfParameterNamed("quantity");
            baseDataValidator.reset().parameter("quantity").value((Object)quantity).notNull().positiveAmount();
        }
        ClientCollateralManagement clientCollateralManagement = this.clientCollateralManagementRepositoryWrapper.getCollateral(clientCollateralId);
        if (clientCollateralManagement == null) {
            throw new ClientCollateralNotFoundException(clientCollateralId);
        }
        BigDecimal totalQuantity = BigDecimal.ZERO;
        if (!clientCollateralManagement.getLoanCollateralManagementSet().isEmpty()) {
            for (LoanCollateralManagement loanCollateralManagement : clientCollateralManagement.getLoanCollateralManagementSet()) {
                totalQuantity = totalQuantity.add(loanCollateralManagement.getQuantity());
            }
        }
        if (totalQuantity.compareTo(quantity) >= 0) {
            baseDataValidator.reset().parameter("quantity").value((Object)quantity).notLessThanMin(totalQuantity);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    @Transactional
    public CommandProcessingResult deleteClientCollateralProduct(Long collateralId) {
        ClientCollateralManagement clientCollateralManagement = this.clientCollateralManagementRepositoryWrapper.getCollateral(collateralId);
        this.validateForDeletion(clientCollateralManagement, collateralId);
        this.clientCollateralManagementRepositoryWrapper.deleteClientCollateralProduct(collateralId);
        return new CommandProcessingResultBuilder().withEntityId(collateralId).build();
    }

    private void validateForDeletion(ClientCollateralManagement clientCollateralManagement, Long clientCollateralId) {
        if (clientCollateralManagement == null) {
            throw new CollateralNotFoundException(clientCollateralId);
        }
        if (!clientCollateralManagement.getLoanCollateralManagementSet().isEmpty()) {
            for (LoanCollateralManagement loanCollateralManagement : clientCollateralManagement.getLoanCollateralManagementSet()) {
                if (loanCollateralManagement.isReleased()) continue;
                throw new ClientCollateralCannotBeDeletedException(ClientCollateralCannotBeDeletedException.ClientCollateralCannotBeDeletedReason.CLIENT_COLLATERAL_IS_ALREADY_ATTACHED, clientCollateralId);
            }
        }
    }

    @Generated
    public ClientCollateralManagementWritePlatformServiceImpl(ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper, CollateralManagementRepositoryWrapper collateralManagementRepositoryWrapper, ClientRepositoryWrapper clientRepositoryWrapper) {
        this.clientCollateralManagementRepositoryWrapper = clientCollateralManagementRepositoryWrapper;
        this.collateralManagementRepositoryWrapper = collateralManagementRepositoryWrapper;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
    }
}

