/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.service;

import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateral.api.CollateralApiConstants;
import org.apache.fineract.portfolio.collateral.command.CollateralCommand;
import org.apache.fineract.portfolio.collateral.domain.LoanCollateral;
import org.apache.fineract.portfolio.collateral.domain.LoanCollateralRepository;
import org.apache.fineract.portfolio.collateral.exception.CollateralCannotBeCreatedException;
import org.apache.fineract.portfolio.collateral.exception.CollateralCannotBeDeletedException;
import org.apache.fineract.portfolio.collateral.exception.CollateralCannotBeUpdatedException;
import org.apache.fineract.portfolio.collateral.exception.CollateralNotFoundException;
import org.apache.fineract.portfolio.collateral.serialization.CollateralCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.collateral.service.CollateralWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class CollateralWritePlatformServiceJpaRepositoryImpl
implements CollateralWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollateralWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanCollateralRepository collateralRepository;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final CollateralCommandFromApiJsonDeserializer collateralCommandFromApiJsonDeserializer;

    @Transactional
    public CommandProcessingResult addCollateral(Long loanId, JsonCommand command) {
        this.context.authenticatedUser();
        CollateralCommand collateralCommand = this.collateralCommandFromApiJsonDeserializer.commandFromApiJson(command.json());
        collateralCommand.validateForCreate();
        try {
            Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
            CodeValue collateralType = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("LoanCollateral", collateralCommand.getCollateralTypeId());
            LoanCollateral collateral = LoanCollateral.fromJson((Loan)loan, (CodeValue)collateralType, (JsonCommand)command);
            if (!loan.getStatus().isSubmittedAndPendingApproval()) {
                throw new CollateralCannotBeCreatedException(CollateralCannotBeCreatedException.LoanCollateralCannotBeCreatedReason.LOAN_NOT_IN_SUBMITTED_AND_PENDING_APPROVAL_STAGE, (Long)loan.getId());
            }
            this.collateralRepository.saveAndFlush((Object)collateral);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId((Long)loan.getId()).withEntityId((Long)collateral.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleCollateralDataIntegrityViolation((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateCollateral(Long loanId, Long collateralId, JsonCommand command) {
        this.context.authenticatedUser();
        CollateralCommand collateralCommand = this.collateralCommandFromApiJsonDeserializer.commandFromApiJson(command.json());
        collateralCommand.validateForUpdate();
        Long collateralTypeId = collateralCommand.getCollateralTypeId();
        try {
            Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
            CodeValue collateralType = null;
            LoanCollateral collateralForUpdate = (LoanCollateral)this.collateralRepository.findById((Object)collateralId).orElseThrow(() -> new CollateralNotFoundException(loanId, collateralId));
            Map changes = collateralForUpdate.update(command);
            if (changes.containsKey(CollateralApiConstants.CollateralJSONinputParams.COLLATERAL_TYPE_ID.getValue())) {
                collateralType = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("LoanCollateral", collateralTypeId);
                collateralForUpdate.setCollateralType(collateralType);
            }
            if (!loan.getStatus().isSubmittedAndPendingApproval()) {
                throw new CollateralCannotBeUpdatedException(CollateralCannotBeUpdatedException.LoanCollateralCannotBeUpdatedReason.LOAN_NOT_IN_SUBMITTED_AND_PENDING_APPROVAL_STAGE, (Long)loan.getId());
            }
            if (!changes.isEmpty()) {
                this.collateralRepository.saveAndFlush((Object)collateralForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId(command.getLoanId()).withEntityId(collateralId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleCollateralDataIntegrityViolation((NonTransientDataAccessException)dve);
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
    }

    @Transactional
    public CommandProcessingResult deleteCollateral(Long loanId, Long collateralId, Long commandId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        LoanCollateral collateral = this.collateralRepository.findByLoanIdAndId(loanId, collateralId);
        if (collateral == null) {
            throw new CollateralNotFoundException(loanId, collateralId);
        }
        if (!loan.getStatus().isSubmittedAndPendingApproval()) {
            throw new CollateralCannotBeDeletedException(CollateralCannotBeDeletedException.LoanCollateralCannotBeDeletedReason.LOAN_NOT_IN_SUBMITTED_AND_PENDING_APPROVAL_STAGE, loanId, collateralId);
        }
        this.collateralRepository.delete((Object)collateral);
        return new CommandProcessingResultBuilder().withCommandId(commandId).withLoanId(loanId).withEntityId(collateralId).build();
    }

    private void handleCollateralDataIntegrityViolation(NonTransientDataAccessException dve) {
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.collateral.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Generated
    public CollateralWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, LoanRepositoryWrapper loanRepositoryWrapper, LoanCollateralRepository collateralRepository, CodeValueRepositoryWrapper codeValueRepository, CollateralCommandFromApiJsonDeserializer collateralCommandFromApiJsonDeserializer) {
        this.context = context;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.collateralRepository = collateralRepository;
        this.codeValueRepository = codeValueRepository;
        this.collateralCommandFromApiJsonDeserializer = collateralCommandFromApiJsonDeserializer;
    }
}

