/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.accounts.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.accounts.api.AccountsApiResourceSwagger;
import org.apache.fineract.portfolio.accounts.data.AccountData;
import org.apache.fineract.portfolio.accounts.data.request.AccountRequest;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountData;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/accounts/{type}")
@Component
@Tag(name="Share Account", description="Share accounts are instances of a praticular share product created for an individual. An application process around the creation of accounts is also supported.")
public class AccountsApiResource {
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<AccountData> toApiJsonSerializer;
    private final PlatformSecurityContext platformSecurityContext;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final ShareAccountReadPlatformService shareAccountReadPlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Share Account Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Requests:\n\naccounts/share/template?clientId=1\n\n\naccounts/share/template?clientId=1&productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.GetAccountsTypeTemplateResponse.class))})})
    public ShareAccountData template(@PathParam(value="type") @Parameter(description="type") String accountType, @QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="productId") @Parameter(description="productId") Long productId) {
        this.platformSecurityContext.authenticatedUser();
        return this.shareAccountReadPlatformService.retrieveTemplate(clientId, productId);
    }

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a share application/account", description="Retrieves a share application/account\n\nExample Requests :\n\nshareaccount/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.GetAccountsTypeAccountIdResponse.class))})})
    public ShareAccountData retrieveAccount(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @PathParam(value="type") @Parameter(description="type") String accountType, @Context UriInfo uriInfo) {
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.shareAccountReadPlatformService.retrieveOne(accountId, settings.isTemplate());
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List share applications/accounts", description="Lists share applications/accounts\n\nExample Requests:\n\nshareaccount")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.GetAccountsTypeResponse.class))})})
    public Page<AccountData> retrieveAllAccounts(@PathParam(value="type") @Parameter(description="type") String accountType, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit) {
        return this.shareAccountReadPlatformService.retrieveAll(offset, limit);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Submit new share application", description="Submits new share application\n\nMandatory Fields: clientId, productId, submittedDate, savingsAccountId, requestedShares, applicationDate\n\nOptional Fields: accountNo, externalId\n\nInherited from Product (if not provided): minimumActivePeriod, minimumActivePeriodFrequencyType, lockinPeriodFrequency, lockinPeriodFrequencyType")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeResponse.class))})})
    public CommandProcessingResult createAccount(@PathParam(value="type") @Parameter(description="type") String accountType, @Parameter(hidden=true) AccountRequest accountRequest) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createAccount(accountType).withJson(this.toApiJsonSerializer.serialize((Object)accountRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @POST
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve share application | Undo approval share application | Reject share application | Activate a share account | Close a share account | Apply additional shares on a share account | Approve additional shares request on a share account | Reject additional shares request on a share account | Redeem shares on a share account", description="Approve share application:\n\nApproves share application so long as its in 'Submitted and pending approval' state.\n\nUndo approval share application:\n\nWill move 'approved' share application back to 'Submitted and pending approval' state.\n\nReject share application:\n\nRejects share application so long as its in 'Submitted and pending approval' state.\n\nActivate a share account:\n\nResults in an approved share application being converted into an 'active' share account.\n\nClose a share account:\n\nResults in an Activated share application being converted into an 'closed' share account.\n\nclosedDate is closure date of share account\n\nMandatory Fields: dateFormat,locale,closedDate\n\nApply additional shares on a share account:\n\nrequestedDate is requsted date of share purchase\n\nrequestedShares is number of shares to be purchase\n\nMandatory Fields: dateFormat,locale,requestedDate, requestedShares\n\nApprove additional shares request on a share account\n\nrequestedShares is Share purchase transaction ids\n\nMandatory Fields: requestedShares\n\nReject additional shares request on a share account:\n\nrequestedShares is Share purchase transaction ids\n\nMandatory Fields: requestedShares\n\nRedeem shares on a share account:\n\nResults redeem some/all shares from share account.\n\nrequestedDate is requsted date of shares redeem\n\nrequestedShares is number of shares to be redeemed\n\nMandatory Fields: dateFormat,locale,requestedDate,requestedShares\n\nShowing request/response for 'Reject additional shares request on a share account'\n\nFor more info visit this link - https://fineract.apache.org/docs/legacy/#shareaccounts")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeAccountIdResponse.class))})})
    public CommandProcessingResult handleCommands(@PathParam(value="type") @Parameter(description="type") String accountType, @PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createAccountCommand(accountType, accountId, commandParam).withJson(apiRequestBodyAsJson).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @PUT
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a share application", description="Share application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method. Specific api endpoints will be created to allow change of interest detail such as rate, compounding period, posting period etc")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PutAccountsTypeAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PutAccountsTypeAccountIdResponse.class))})})
    public CommandProcessingResult updateAccount(@PathParam(value="type") @Parameter(description="type") String accountType, @PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @Parameter(hidden=true) AccountRequest accountRequest) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateAccount(accountType, accountId).withJson(this.toApiJsonSerializer.serialize((Object)accountRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getSharedAccountsTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat, @PathParam(value="type") @Parameter(description="type") String accountType) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.SHARE_ACCOUNTS.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload shared accounts template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public Long postSharedAccountsTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat, @PathParam(value="type") @Parameter(description="type") String accountType) {
        return this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.SHARE_ACCOUNTS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
    }

    @Generated
    public AccountsApiResource(ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<AccountData> toApiJsonSerializer, PlatformSecurityContext platformSecurityContext, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, ShareAccountReadPlatformService shareAccountReadPlatformService) {
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.platformSecurityContext = platformSecurityContext;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.shareAccountReadPlatformService = shareAccountReadPlatformService;
    }
}

