/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.staff.domain;

import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepository;
import org.apache.fineract.organisation.staff.exception.StaffNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StaffRepositoryWrapper {
    private final StaffRepository repository;

    @Autowired
    public StaffRepositoryWrapper(StaffRepository repository) {
        this.repository = repository;
    }

    public Staff findOneWithNotFoundDetection(Long id) {
        return (Staff)this.repository.findById((Object)id).orElseThrow(() -> new StaffNotFoundException(id));
    }

    public Staff findByOfficeWithNotFoundDetection(Long staffId, Long officeId) {
        Staff staff = this.repository.findByOffice(staffId, officeId);
        if (staff == null) {
            throw new StaffNotFoundException(staffId);
        }
        return staff;
    }

    public Staff findByOfficeHierarchyWithNotFoundDetection(Long staffId, String hierarchy) {
        Staff staff = (Staff)this.repository.findById((Object)staffId).orElseThrow(() -> new StaffNotFoundException(staffId));
        String staffhierarchy = staff.office().getHierarchy();
        if (!hierarchy.startsWith(staffhierarchy)) {
            throw new StaffNotFoundException(staffId);
        }
        return staff;
    }

    public void save(Staff staff) {
        this.repository.save((Object)staff);
    }
}

