/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.service;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.dataqueries.api.DataTableApiConstant;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableData;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableReadService;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.infrastructure.survey.data.ClientScoresOverview;
import org.apache.fineract.infrastructure.survey.data.SurveyDataTableData;
import org.apache.fineract.infrastructure.survey.service.ReadSurveyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class ReadSurveyServiceImpl
implements ReadSurveyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadSurveyServiceImpl.class);
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final SqlValidator sqlValidator;
    private final GenericDataService genericDataService;
    private final DatatableReadService datatableReadService;

    public List<SurveyDataTableData> retrieveAllSurveys() {
        String sql = this.retrieveAllSurveySQL("");
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sql);
        ArrayList<SurveyDataTableData> surveyDataTables = new ArrayList<SurveyDataTableData>();
        while (rs.next()) {
            String appTableName = rs.getString("application_table_name");
            String registeredDatatableName = rs.getString("registered_table_name");
            String entitySubType = rs.getString("entity_subtype");
            boolean enabled = rs.getBoolean("enabled");
            List columnHeaderData = this.genericDataService.fillResultsetColumnHeaders(registeredDatatableName);
            surveyDataTables.add(SurveyDataTableData.create((DatatableData)DatatableData.create((String)appTableName, (String)registeredDatatableName, (String)entitySubType, (List)columnHeaderData), (boolean)enabled));
        }
        return surveyDataTables;
    }

    private String retrieveAllSurveySQL(String andClause) {
        return "select application_table_name, cf.enabled, registered_table_name, entity_subtype from x_registered_table  left join c_configuration cf on x_registered_table.registered_table_name = cf.name  where exists (select 'f' from m_appuser_role ur  join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = " + String.valueOf(this.context.authenticatedUser().getId()) + " and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name)))  and x_registered_table.category = " + DataTableApiConstant.CATEGORY_PPI + andClause + " order by application_table_name, registered_table_name";
    }

    public SurveyDataTableData retrieveSurvey(String surveyName) {
        this.sqlValidator.validate(surveyName);
        String sql = "select cf.enabled, application_table_name, registered_table_name, entity_subtype from x_registered_table  left join c_configuration cf on x_registered_table.registered_table_name = cf.name  where exists (select 'f' from m_appuser_role ur  join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = ? and registered_table_name=? and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name)))  order by application_table_name, registered_table_name";
        SurveyDataTableData datatableData = null;
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet("select cf.enabled, application_table_name, registered_table_name, entity_subtype from x_registered_table  left join c_configuration cf on x_registered_table.registered_table_name = cf.name  where exists (select 'f' from m_appuser_role ur  join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = ? and registered_table_name=? and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name)))  order by application_table_name, registered_table_name", new Object[]{this.context.authenticatedUser().getId(), surveyName});
        if (rs.next()) {
            String appTableName = rs.getString("application_table_name");
            String registeredDatatableName = rs.getString("registered_table_name");
            String entitySubType = rs.getString("entity_subtype");
            boolean enabled = rs.getBoolean("enabled");
            List columnHeaderData = this.genericDataService.fillResultsetColumnHeaders(registeredDatatableName);
            datatableData = SurveyDataTableData.create((DatatableData)DatatableData.create((String)appTableName, (String)registeredDatatableName, (String)entitySubType, (List)columnHeaderData), (boolean)enabled);
        }
        return datatableData;
    }

    public List<ClientScoresOverview> retrieveClientSurveyScoreOverview(String surveyName, Long clientId) {
        String sql = "SELECT  tz.id, lkh.name, lkh.code, poverty_line, tz.date, tz.score FROM ? tz JOIN ppi_likelihoods_ppi lkp on lkp.ppi_name = ? AND enabled = ?  JOIN ppi_scores sc on score_from  <= tz.score AND score_to >=tz.score JOIN ppi_poverty_line pvl on pvl.likelihood_ppi_id = lkp.id AND pvl.score_id = sc.id JOIN ppi_likelihoods lkh on lkh.id = lkp.likelihood_id  WHERE  client_id = ? ";
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet("SELECT  tz.id, lkh.name, lkh.code, poverty_line, tz.date, tz.score FROM ? tz JOIN ppi_likelihoods_ppi lkp on lkp.ppi_name = ? AND enabled = ?  JOIN ppi_scores sc on score_from  <= tz.score AND score_to >=tz.score JOIN ppi_poverty_line pvl on pvl.likelihood_ppi_id = lkp.id AND pvl.score_id = sc.id JOIN ppi_likelihoods lkh on lkh.id = lkp.likelihood_id  WHERE  client_id = ? ", new Object[]{surveyName, surveyName, 200L, clientId});
        ArrayList<ClientScoresOverview> scoresOverviews = new ArrayList<ClientScoresOverview>();
        while (rs.next()) {
            scoresOverviews.add(new ClientScoresOverview().setLikelihoodCode(rs.getString("code")).setLikelihoodName(rs.getString("name")).setScore(rs.getLong("score")).setPovertyLine(Double.valueOf(rs.getDouble("poverty_line"))).setDate(rs.getDate("date").toLocalDate()).setId(rs.getLong("id")).setSurveyName(surveyName));
        }
        return scoresOverviews;
    }

    public List<ClientScoresOverview> retrieveClientSurveyScoreOverview(Long clientId) {
        String surveyNameSql = this.retrieveAllSurveyNameSQL();
        SqlRowSet surveyNames = this.jdbcTemplate.queryForRowSet(surveyNameSql);
        ArrayList<CallSite> sqls = new ArrayList<CallSite>();
        while (surveyNames.next()) {
            sqls.add((CallSite)((Object)("SELECT '" + surveyNames.getString("name") + "' as surveyName, tz.id, lkh.name, lkh.code, poverty_line, tz.date, tz.score FROM " + surveyNames.getString("name") + " tz JOIN ppi_likelihoods_ppi lkp on lkp.ppi_name = '" + surveyNames.getString("name") + "' AND enabled = '200' JOIN ppi_scores sc on score_from  <= tz.score AND score_to >=tz.score JOIN ppi_poverty_line pvl on pvl.likelihood_ppi_id = lkp.id AND pvl.score_id = sc.id JOIN ppi_likelihoods lkh on lkh.id = lkp.likelihood_id  WHERE  client_id = ?")));
        }
        ArrayList<ClientScoresOverview> scoresOverviews = new ArrayList<ClientScoresOverview>();
        for (String string : sqls) {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(string, new Object[]{clientId});
            while (rs.next()) {
                scoresOverviews.add(new ClientScoresOverview().setLikelihoodCode(rs.getString("code")).setLikelihoodName(rs.getString("name")).setScore(rs.getLong("score")).setPovertyLine(Double.valueOf(rs.getDouble("poverty_line"))).setDate(rs.getDate("date").toLocalDate()).setId(rs.getLong("id")).setSurveyName(rs.getString("surveyName")));
            }
        }
        return scoresOverviews;
    }

    private String retrieveAllSurveyNameSQL() {
        return "select cf.name from x_registered_table  join c_configuration cf on x_registered_table.registered_table_name = cf.name  where exists (select 'f' from m_appuser_role ur  join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = " + String.valueOf(this.context.authenticatedUser().getId()) + " and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name)))  and x_registered_table.category = " + DataTableApiConstant.CATEGORY_PPI + " order by application_table_name, registered_table_name";
    }

    public GenericResultsetData retrieveSurveyEntry(String surveyName, Long clientId, Long entryId) {
        return this.datatableReadService.retrieveDataTableGenericResultSet(surveyName, clientId, null, entryId);
    }

    @Generated
    public ReadSurveyServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, SqlValidator sqlValidator, GenericDataService genericDataService, DatatableReadService datatableReadService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlValidator = sqlValidator;
        this.genericDataService = genericDataService;
        this.datatableReadService = datatableReadService;
    }
}

