/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.service;

import jakarta.annotation.PostConstruct;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.infrastructure.sms.data.SmsData;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.infrastructure.sms.exception.SmsNotFoundException;
import org.apache.fineract.infrastructure.sms.service.SmsReadPlatformService;
import org.apache.fineract.infrastructure.sms.service.SmsReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class SmsReadPlatformServiceImpl
implements SmsReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationHelper paginationHelper;
    private final ColumnValidator columnValidator;
    private final SqlValidator sqlValidator;
    private SmsMapper smsRowMapper;

    @PostConstruct
    public void init() {
        this.smsRowMapper = new SmsMapper();
    }

    public List<SmsData> retrieveAll() {
        String sql = "select " + this.smsRowMapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)this.smsRowMapper);
    }

    public SmsData retrieveOne(Long resourceId) {
        try {
            String sql = "select " + this.smsRowMapper.schema() + " where smo.id = ?";
            return (SmsData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.smsRowMapper, new Object[]{resourceId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SmsNotFoundException(resourceId, e);
        }
    }

    public List<SmsData> retrieveAllPending(Long campaignId, Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select " + this.smsRowMapper.schema() + " where smo.status_enum = " + SmsMessageStatusType.PENDING.getValue();
        if (campaignId != null) {
            sql = sql + " and smo.campaign_id = " + campaignId;
        }
        sql = sql + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.smsRowMapper);
    }

    public List<SmsData> retrieveAllSent(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select " + this.smsRowMapper.schema() + " where smo.status_enum IN (" + SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue() + "," + SmsMessageStatusType.SENT.getValue() + ")" + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.smsRowMapper);
    }

    public List<Long> retrieveExternalIdsOfAllSent(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select external_id from " + this.smsRowMapper.tableName() + " where status_enum = " + SmsMessageStatusType.SENT.getValue() + sqlPlusLimit;
        return this.jdbcTemplate.queryForList(sql, Long.class);
    }

    public Page<Long> retrieveAllWaitingForDeliveryReport(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select id from " + this.smsRowMapper.tableName() + " where status_enum = " + SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue() + sqlPlusLimit;
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sql, Long.class);
    }

    public List<Long> retrieveAllPending(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select external_id from " + this.smsRowMapper.tableName() + " where status_enum = " + SmsMessageStatusType.PENDING.getValue() + sqlPlusLimit;
        return this.jdbcTemplate.queryForList(sql, Long.class);
    }

    public List<SmsData> retrieveAllDelivered(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select " + this.smsRowMapper.schema() + " where smo.status_enum = " + SmsMessageStatusType.DELIVERED.getValue() + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.smsRowMapper);
    }

    public List<SmsData> retrieveAllFailed(Integer limit) {
        String sqlPlusLimit = limit > 0 ? " " + this.sqlGenerator.limit(limit.intValue()) : "";
        String sql = "select " + this.smsRowMapper.schema() + " where smo.status_enum = " + SmsMessageStatusType.FAILED.getValue() + sqlPlusLimit;
        return this.jdbcTemplate.query(sql, (RowMapper)this.smsRowMapper);
    }

    public Page<SmsData> retrieveSmsByStatus(Long campaignId, SearchParameters searchParameters, Integer status, LocalDate dateFrom, LocalDate dateTo) {
        this.sqlValidator.validate(searchParameters.getOrderBy());
        this.sqlValidator.validate(searchParameters.getSortOrder());
        StringBuilder sqlBuilder = new StringBuilder(200);
        Object[] objectArray = new Object[10];
        int arrayPos = 0;
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.smsRowMapper.schema());
        if (status != null) {
            sqlBuilder.append(" where smo.campaign_id = ? and smo.status_enum= ? ");
            objectArray[arrayPos] = campaignId;
            objectArray[++arrayPos] = status;
            ++arrayPos;
        }
        String fromDateString = null;
        String toDateString = null;
        if (dateFrom != null && dateTo != null) {
            fromDateString = DateUtils.DEFAULT_DATE_FORMATTER.format(dateFrom);
            toDateString = DateUtils.DEFAULT_DATE_FORMATTER.format(dateTo);
            sqlBuilder.append(" and smo.submittedon_date >= ? and smo.submittedon_date <= ? ");
            objectArray[arrayPos] = fromDateString;
            objectArray[++arrayPos] = toDateString;
            ++arrayPos;
        }
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        } else {
            sqlBuilder.append(" order by smo.submittedon_date, smo.id");
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] finalObjectArray = Arrays.copyOf(objectArray, arrayPos);
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.smsRowMapper);
    }

    @Generated
    public SmsReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper, ColumnValidator columnValidator, SqlValidator sqlValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.paginationHelper = paginationHelper;
        this.columnValidator = columnValidator;
        this.sqlValidator = sqlValidator;
    }
}

