/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.EmailDetail;
import org.apache.fineract.infrastructure.core.service.PlatformEmailService;
import org.apache.fineract.infrastructure.security.data.OTPDeliveryMethod;
import org.apache.fineract.infrastructure.security.data.OTPRequest;
import org.apache.fineract.infrastructure.security.domain.OTPRequestRepository;
import org.apache.fineract.infrastructure.security.domain.TFAccessToken;
import org.apache.fineract.infrastructure.security.domain.TFAccessTokenRepository;
import org.apache.fineract.infrastructure.security.exception.AccessTokenInvalidIException;
import org.apache.fineract.infrastructure.security.exception.OTPDeliveryMethodInvalidException;
import org.apache.fineract.infrastructure.security.exception.OTPTokenInvalidException;
import org.apache.fineract.infrastructure.security.service.AccessTokenGenerationService;
import org.apache.fineract.infrastructure.security.service.RandomOTPGenerator;
import org.apache.fineract.infrastructure.security.service.TwoFactorConfigurationService;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobService;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
public class TwoFactorServiceImpl
implements TwoFactorService {
    private final AccessTokenGenerationService accessTokenGenerationService;
    private final PlatformEmailService emailService;
    private final SmsMessageScheduledJobService smsMessageScheduledJobService;
    private final OTPRequestRepository otpRequestRepository;
    private final TFAccessTokenRepository tfAccessTokenRepository;
    private final SmsMessageRepository smsMessageRepository;
    private final TwoFactorConfigurationService configurationService;

    @Autowired
    public TwoFactorServiceImpl(AccessTokenGenerationService accessTokenGenerationService, PlatformEmailService emailService, SmsMessageScheduledJobService smsMessageScheduledJobService, OTPRequestRepository otpRequestRepository, TFAccessTokenRepository tfAccessTokenRepository, SmsMessageRepository smsMessageRepository, TwoFactorConfigurationService configurationService) {
        this.accessTokenGenerationService = accessTokenGenerationService;
        this.emailService = emailService;
        this.smsMessageScheduledJobService = smsMessageScheduledJobService;
        this.otpRequestRepository = otpRequestRepository;
        this.tfAccessTokenRepository = tfAccessTokenRepository;
        this.smsMessageRepository = smsMessageRepository;
        this.configurationService = configurationService;
    }

    public List<OTPDeliveryMethod> getDeliveryMethodsForUser(AppUser user) {
        OTPDeliveryMethod emailDelivery;
        ArrayList<OTPDeliveryMethod> deliveryMethods = new ArrayList<OTPDeliveryMethod>();
        OTPDeliveryMethod smsMethod = this.getSMSDeliveryMethodForUser(user);
        if (smsMethod != null) {
            deliveryMethods.add(smsMethod);
        }
        if ((emailDelivery = this.getEmailDeliveryMethodForUser(user)) != null) {
            deliveryMethods.add(emailDelivery);
        }
        return deliveryMethods;
    }

    public OTPRequest createNewOTPToken(AppUser user, String deliveryMethodName, boolean extendedAccessToken) {
        if ("sms".equalsIgnoreCase(deliveryMethodName)) {
            OTPDeliveryMethod smsDelivery = this.getSMSDeliveryMethodForUser(user);
            if (smsDelivery == null) {
                throw new OTPDeliveryMethodInvalidException();
            }
            OTPRequest request = this.generateNewToken(smsDelivery, extendedAccessToken);
            String smsText = this.configurationService.getFormattedSmsTextFor(user, request);
            SmsMessage smsMessage = SmsMessage.pendingSms(null, null, null, (Staff)user.getStaff(), (String)smsText, (String)user.getStaff().mobileNo(), null, (boolean)false);
            this.smsMessageRepository.save((Object)smsMessage);
            this.smsMessageScheduledJobService.sendTriggeredMessage(Collections.singleton(smsMessage), (long)this.configurationService.getSMSProviderId().intValue());
            this.otpRequestRepository.addOTPRequest(user, request);
            return request;
        }
        if ("email".equalsIgnoreCase(deliveryMethodName)) {
            OTPDeliveryMethod emailDelivery = this.getEmailDeliveryMethodForUser(user);
            if (emailDelivery == null) {
                throw new OTPDeliveryMethodInvalidException();
            }
            OTPRequest request = this.generateNewToken(emailDelivery, extendedAccessToken);
            String emailSubject = this.configurationService.getFormattedEmailSubjectFor(user, request);
            String emailBody = this.configurationService.getFormattedEmailBodyFor(user, request);
            EmailDetail emailData = new EmailDetail(emailSubject, emailBody, user.getEmail(), user.getFirstname() + " " + user.getLastname());
            this.emailService.sendDefinedEmail(emailData);
            this.otpRequestRepository.addOTPRequest(user, request);
            return request;
        }
        throw new OTPDeliveryMethodInvalidException();
    }

    @CachePut(value={"userTFAccessToken"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#user.username).concat(#result.token + 'tok')")
    public TFAccessToken createAccessTokenFromOTP(AppUser user, String otpToken) {
        OTPRequest otpRequest = this.otpRequestRepository.getOTPRequestForUser(user);
        if (otpRequest == null || !otpRequest.isValid() || !otpRequest.getToken().equalsIgnoreCase(otpToken)) {
            throw new OTPTokenInvalidException();
        }
        this.otpRequestRepository.deleteOTPRequestForUser(user);
        String token = this.accessTokenGenerationService.generateRandomToken();
        int liveTime = otpRequest.getMetadata().isExtendedAccessToken() ? this.configurationService.getAccessTokenExtendedLiveTime().intValue() : this.configurationService.getAccessTokenLiveTime().intValue();
        TFAccessToken accessToken = TFAccessToken.create((String)token, (AppUser)user, (int)liveTime);
        this.tfAccessTokenRepository.save((Object)accessToken);
        return accessToken;
    }

    public void validateTwoFactorAccessToken(AppUser user, String token) {
        TFAccessToken accessToken = this.fetchAccessTokenForUser(user, token);
        if (accessToken == null || !accessToken.isValid()) {
            throw new AccessTokenInvalidIException();
        }
    }

    @CacheEvict(value={"userTFAccessToken"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#user.username).concat(#result.token + 'tok')")
    public TFAccessToken invalidateAccessToken(AppUser user, JsonCommand command) {
        String token = command.stringValueOfParameterNamed("token");
        TFAccessToken accessToken = this.fetchAccessTokenForUser(user, token);
        if (accessToken == null || !accessToken.isValid()) {
            throw new AccessTokenInvalidIException();
        }
        accessToken.setEnabled(false);
        this.tfAccessTokenRepository.save((Object)accessToken);
        return accessToken;
    }

    @Cacheable(value={"userTFAccessToken"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#user.username).concat(#token + 'tok')")
    public TFAccessToken fetchAccessTokenForUser(AppUser user, String token) {
        return this.tfAccessTokenRepository.findByUserAndToken(user, token);
    }

    private OTPDeliveryMethod getSMSDeliveryMethodForUser(AppUser user) {
        if (!this.configurationService.isSMSEnabled()) {
            return null;
        }
        if (this.configurationService.getSMSProviderId() == null) {
            return null;
        }
        if (user.getStaff() == null) {
            return null;
        }
        String mobileNo = user.getStaff().mobileNo();
        if (StringUtils.isBlank((CharSequence)mobileNo)) {
            return null;
        }
        return new OTPDeliveryMethod().setName("sms").setTarget(mobileNo);
    }

    private OTPDeliveryMethod getEmailDeliveryMethodForUser(AppUser user) {
        if (!this.configurationService.isEmailEnabled()) {
            return null;
        }
        return new OTPDeliveryMethod().setName("email").setTarget(user.getEmail());
    }

    private OTPRequest generateNewToken(OTPDeliveryMethod deliveryMethod, boolean extendedAccessToken) {
        int tokenLiveTime = this.configurationService.getOTPTokenLiveTime();
        int otpLength = this.configurationService.getOTPTokenLength();
        String token = new RandomOTPGenerator(otpLength).generate();
        return OTPRequest.create((String)token, (int)tokenLiveTime, (boolean)extendedAccessToken, (OTPDeliveryMethod)deliveryMethod);
    }
}

