/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import java.sql.SQLException;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.security.exception.EscapeSqlLiteralException;
import org.apache.fineract.infrastructure.security.service.SqlInjectionPreventerService;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.MySQLCodec;
import org.postgresql.core.Utils;
import org.springframework.stereotype.Service;

@Service
public class SqlInjectionPreventerServiceImpl
implements SqlInjectionPreventerService {
    private static final Codec<?> MYSQL_CODEC = new MySQLCodec(MySQLCodec.Mode.STANDARD);
    private final DatabaseTypeResolver databaseTypeResolver;

    public SqlInjectionPreventerServiceImpl(DatabaseTypeResolver databaseTypeResolver) {
        this.databaseTypeResolver = databaseTypeResolver;
    }

    public String encodeSql(String literal) {
        if (this.databaseTypeResolver.isMySQL()) {
            return ESAPI.encoder().encodeForSQL(MYSQL_CODEC, literal);
        }
        if (this.databaseTypeResolver.isPostgreSQL()) {
            try {
                return Utils.escapeLiteral(null, (String)literal, (boolean)true).toString();
            }
            catch (SQLException e) {
                throw new EscapeSqlLiteralException("Failed to escape an SQL literal. literal: " + literal, e);
            }
        }
        return literal;
    }
}

