/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.gcm.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.gcm.domain.MulticastResult;
import org.apache.fineract.infrastructure.gcm.domain.Result;

public final class MulticastResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int success;
    private int failure;
    private int canonicalIds;
    private long multicastId;
    private List<Result> results;
    private List<Long> retryMulticastIds;

    private MulticastResult(Builder builder) {
        this.success = builder.success;
        this.failure = builder.failure;
        this.canonicalIds = builder.canonicalIds;
        this.multicastId = builder.multicastId;
        this.results = Collections.unmodifiableList(builder.results);
        List tmpList = builder.retryMulticastIds;
        if (tmpList == null) {
            tmpList = Collections.emptyList();
        }
        this.retryMulticastIds = Collections.unmodifiableList(tmpList);
    }

    @Generated
    public int getSuccess() {
        return this.success;
    }

    @Generated
    public int getFailure() {
        return this.failure;
    }

    @Generated
    public int getCanonicalIds() {
        return this.canonicalIds;
    }

    @Generated
    public long getMulticastId() {
        return this.multicastId;
    }

    @Generated
    public List<Result> getResults() {
        return this.results;
    }

    @Generated
    public List<Long> getRetryMulticastIds() {
        return this.retryMulticastIds;
    }

    @Generated
    public MulticastResult setSuccess(int success) {
        this.success = success;
        return this;
    }

    @Generated
    public MulticastResult setFailure(int failure) {
        this.failure = failure;
        return this;
    }

    @Generated
    public MulticastResult setCanonicalIds(int canonicalIds) {
        this.canonicalIds = canonicalIds;
        return this;
    }

    @Generated
    public MulticastResult setMulticastId(long multicastId) {
        this.multicastId = multicastId;
        return this;
    }

    @Generated
    public MulticastResult setResults(List<Result> results) {
        this.results = results;
        return this;
    }

    @Generated
    public MulticastResult setRetryMulticastIds(List<Long> retryMulticastIds) {
        this.retryMulticastIds = retryMulticastIds;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MulticastResult)) {
            return false;
        }
        MulticastResult other = (MulticastResult)o;
        if (this.getSuccess() != other.getSuccess()) {
            return false;
        }
        if (this.getFailure() != other.getFailure()) {
            return false;
        }
        if (this.getCanonicalIds() != other.getCanonicalIds()) {
            return false;
        }
        if (this.getMulticastId() != other.getMulticastId()) {
            return false;
        }
        List this$results = this.getResults();
        List other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        List this$retryMulticastIds = this.getRetryMulticastIds();
        List other$retryMulticastIds = other.getRetryMulticastIds();
        return !(this$retryMulticastIds == null ? other$retryMulticastIds != null : !((Object)this$retryMulticastIds).equals(other$retryMulticastIds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSuccess();
        result = result * 59 + this.getFailure();
        result = result * 59 + this.getCanonicalIds();
        long $multicastId = this.getMulticastId();
        result = result * 59 + (int)($multicastId >>> 32 ^ $multicastId);
        List $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        List $retryMulticastIds = this.getRetryMulticastIds();
        result = result * 59 + ($retryMulticastIds == null ? 43 : ((Object)$retryMulticastIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MulticastResult(success=" + this.getSuccess() + ", failure=" + this.getFailure() + ", canonicalIds=" + this.getCanonicalIds() + ", multicastId=" + this.getMulticastId() + ", results=" + String.valueOf(this.getResults()) + ", retryMulticastIds=" + String.valueOf(this.getRetryMulticastIds()) + ")";
    }

    @Generated
    public MulticastResult() {
    }
}

