/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler;

import com.google.common.base.Splitter;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformException;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ImportHandlerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportHandlerUtils.class);

    private ImportHandlerUtils() {
    }

    public static Integer getNumberOfRows(Sheet sheet, int primaryColumn) {
        Cell cell;
        Row row;
        Integer noOfEntries = 0;
        int maxRows = sheet.getLastRowNum();
        while (noOfEntries < maxRows && (row = sheet.getRow(noOfEntries + 1)) != null && (cell = row.getCell(primaryColumn)) != null && cell.getCellType() != CellType.BLANK) {
            Integer n = noOfEntries;
            noOfEntries = noOfEntries + 1;
        }
        return noOfEntries;
    }

    public static boolean isNotImported(Row row, int statusColumn) {
        if (ImportHandlerUtils.readAsString((int)statusColumn, (Row)row) != null) {
            return !ImportHandlerUtils.readAsString((int)statusColumn, (Row)row).equals("Imported");
        }
        return true;
    }

    public static Long readAsLong(int colIndex, Row row) {
        Cell c = row.getCell(colIndex);
        if (c == null || c.getCellType() == CellType.BLANK) {
            return null;
        }
        FormulaEvaluator eval = row.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        if (c.getCellType() == CellType.FORMULA) {
            if (eval != null) {
                try {
                    CellValue value = eval.evaluate(c);
                    return Double.valueOf(value.getNumberValue()).longValue();
                }
                catch (Exception e) {
                    log.error("Cell evaluation error: ", (Throwable)e);
                }
            }
            return null;
        }
        if (c.getCellType() == CellType.NUMERIC) {
            return Double.valueOf(c.getNumericCellValue()).longValue();
        }
        return Long.parseLong(row.getCell(colIndex).getStringCellValue());
    }

    public static String readAsString(int colIndex, Row row) {
        Cell c = row.getCell(colIndex);
        if (c == null || c.getCellType() == CellType.BLANK) {
            return null;
        }
        FormulaEvaluator eval = row.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        if (c.getCellType() == CellType.FORMULA) {
            if (eval != null) {
                try {
                    CellValue value = eval.evaluate(c);
                    String res = ImportHandlerUtils.trimEmptyDecimalPortion((String)value.getStringValue());
                    if (StringUtils.isNotEmpty((CharSequence)res)) {
                        return res.trim();
                    }
                }
                catch (Exception e) {
                    log.error("Cell evaluation error: ", (Throwable)e);
                }
            }
            return null;
        }
        if (c.getCellType() == CellType.STRING) {
            String res = ImportHandlerUtils.trimEmptyDecimalPortion((String)c.getStringCellValue().trim());
            return res.trim();
        }
        if (c.getCellType() == CellType.NUMERIC) {
            return "" + Double.valueOf(row.getCell(colIndex).getNumericCellValue()).intValue();
        }
        if (c.getCellType() == CellType.BOOLEAN) {
            return "" + c.getBooleanCellValue();
        }
        return null;
    }

    public static String trimEmptyDecimalPortion(String result) {
        if (result != null && result.endsWith(".0")) {
            return (String)Splitter.on((String)"\\.").split((CharSequence)result).iterator().next();
        }
        return result;
    }

    public static LocalDate readAsDate(int colIndex, Row row) {
        Cell c = row.getCell(colIndex);
        if (c == null || c.getCellType() == CellType.BLANK) {
            return null;
        }
        return LocalDate.ofInstant(c.getDateCellValue().toInstant(), DateUtils.getDateTimeZoneOfTenant());
    }

    public static Boolean readAsBoolean(int colIndex, Row row) {
        Cell c = row.getCell(colIndex);
        if (c == null || c.getCellType() == CellType.BLANK) {
            return false;
        }
        FormulaEvaluator eval = row.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        if (c.getCellType() == CellType.FORMULA) {
            if (eval != null) {
                try {
                    CellValue value = eval.evaluate(c);
                    return value.getBooleanValue();
                }
                catch (Exception e) {
                    log.error("Cell evaluation error: ", (Throwable)e);
                }
            }
            return false;
        }
        if (c.getCellType() == CellType.BOOLEAN) {
            return c.getBooleanCellValue();
        }
        String booleanString = row.getCell(colIndex).getStringCellValue().trim();
        if (booleanString.equalsIgnoreCase("TRUE")) {
            return true;
        }
        return false;
    }

    public static Integer readAsInt(int colIndex, Row row) {
        Cell c = row.getCell(colIndex);
        if (c == null || c.getCellType() == CellType.BLANK) {
            return null;
        }
        FormulaEvaluator eval = row.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        if (c.getCellType() == CellType.FORMULA) {
            if (eval != null) {
                try {
                    CellValue value = eval.evaluate(c);
                    return Double.valueOf(value.getNumberValue()).intValue();
                }
                catch (Exception e) {
                    log.error("Cell evaluation error: ", (Throwable)e);
                }
            }
            return null;
        }
        if (c.getCellType() == CellType.NUMERIC) {
            return Double.valueOf(c.getNumericCellValue()).intValue();
        }
        return Integer.parseInt(row.getCell(colIndex).getStringCellValue());
    }

    public static Double readAsDouble(int colIndex, Row row) {
        Cell c = row.getCell(colIndex);
        if (c == null || c.getCellType() == CellType.BLANK) {
            return 0.0;
        }
        FormulaEvaluator eval = row.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        if (c.getCellType() == CellType.FORMULA) {
            if (eval != null) {
                try {
                    CellValue value = eval.evaluate(c);
                    return value.getNumberValue();
                }
                catch (Exception e) {
                    log.error("Cell evaluation error: ", (Throwable)e);
                }
            }
            return 0.0;
        }
        if (c.getCellType() == CellType.NUMERIC) {
            return row.getCell(colIndex).getNumericCellValue();
        }
        return Double.parseDouble(row.getCell(colIndex).getStringCellValue());
    }

    public static void writeString(int colIndex, Row row, String value) {
        if (value != null) {
            row.createCell(colIndex).setCellValue(value);
        }
    }

    public static CellStyle getCellStyle(Workbook workbook, IndexedColors color) {
        CellReference cellReference = new CellReference("A1");
        Sheet predefined = workbook.getSheet(color.toString());
        if (predefined != null) {
            Row row = predefined.getRow(cellReference.getRow());
            Cell cell = row.getCell((int)cellReference.getCol());
            return cell.getCellStyle();
        }
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(color.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Sheet cache = workbook.createSheet(color.toString());
        workbook.setSheetVisibility(workbook.getSheetIndex(cache), SheetVisibility.VERY_HIDDEN);
        Row row = cache.createRow(cellReference.getRow());
        Cell cell = row.createCell((int)cellReference.getCol());
        cell.setCellStyle(style);
        return style;
    }

    public static String getDefaultUserMessages(List<ApiParameterError> ApiParameterErrorList) {
        StringBuilder defaultUserMessages = new StringBuilder();
        for (ApiParameterError error : ApiParameterErrorList) {
            defaultUserMessages = defaultUserMessages.append(error.getDefaultUserMessage() + "\t");
        }
        return defaultUserMessages.toString();
    }

    public static String getErrorList(List<String> errorList) {
        StringBuilder errors = new StringBuilder();
        for (String error : errorList) {
            errors = errors.append(error);
        }
        return errors.toString();
    }

    public static void writeErrorMessage(Sheet sheet, Integer rowIndex, String errorMessage, int statusColumn) {
        Cell statusCell = sheet.getRow(rowIndex.intValue()).createCell(statusColumn);
        statusCell.setCellValue(errorMessage);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)sheet.getWorkbook(), (IndexedColors)IndexedColors.RED));
    }

    public static String getErrorMessage(RuntimeException re) {
        if (re instanceof AbstractPlatformException) {
            AbstractPlatformException abstractPlatformException = (AbstractPlatformException)re;
            return abstractPlatformException.getDefaultUserMessage();
        }
        if (re instanceof UnsupportedParameterException) {
            UnsupportedParameterException unsupportedParameterException = (UnsupportedParameterException)re;
            return ImportHandlerUtils.getErrorList((List)unsupportedParameterException.getUnsupportedParameters());
        }
        if (re.getMessage() != null) {
            return re.getMessage();
        }
        return re.getClass().getCanonicalName();
    }

    public static Long getIdByName(Sheet sheet, String name) {
        String sheetName = sheet.getSheetName();
        if (!sheetName.equals("Products")) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    if (name != null) {
                        if (cell.getCellType() != CellType.STRING || !cell.getRichStringCellValue().getString().trim().equals(name)) continue;
                        if (sheetName.equals("Offices") || sheetName.equals("GlAccounts") || sheetName.equals("Extras") || sheetName.equals("Charges") || sheetName.equals("SharedProducts") || sheetName.equals("Roles")) {
                            if (row.getCell(cell.getColumnIndex() - 1).getCellType() == CellType.NUMERIC) {
                                return Double.valueOf(row.getCell(cell.getColumnIndex() - 1).getNumericCellValue()).longValue();
                            }
                            return 0L;
                        }
                        if ((sheetName.equals("Clients") || sheetName.equals("Centers") || sheetName.equals("Groups") || sheetName.equals("Staff")) && row.getCell(cell.getColumnIndex() + 1).getCellType() == CellType.NUMERIC) {
                            return Double.valueOf(row.getCell(cell.getColumnIndex() + 1).getNumericCellValue()).longValue();
                        }
                        return 0L;
                    }
                    return null;
                }
            }
        } else {
            for (Row row : sheet) {
                for (int i = 0; i < 2; ++i) {
                    if (name != null) {
                        Cell cell = row.getCell(i);
                        if (cell.getCellType() != CellType.STRING || !cell.getRichStringCellValue().getString().trim().equals(name)) continue;
                        return Double.valueOf(row.getCell(cell.getColumnIndex() - 1).getNumericCellValue()).longValue();
                    }
                    return 0L;
                }
            }
        }
        return 0L;
    }

    public static EnumOptionData getChargeTimeTypeEmun(Sheet sheet, String name) {
        String sheetName = sheet.getSheetName();
        String chargeTimeType = "";
        EnumOptionData chargeTimeTypeEnum = null;
        if (sheetName.equals("Charges")) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    if (name == null || cell.getCellType() != CellType.STRING || !cell.getRichStringCellValue().getString().trim().equals(name)) continue;
                    chargeTimeType = row.getCell(cell.getColumnIndex() + 3).getStringCellValue().toString();
                }
            }
        }
        if (!chargeTimeType.equals("")) {
            String chargeTimeTypeId = "";
            if (chargeTimeType.equalsIgnoreCase("Disbursement")) {
                chargeTimeTypeId = "1";
            }
            chargeTimeTypeEnum = new EnumOptionData(null, null, chargeTimeTypeId);
        }
        return chargeTimeTypeEnum;
    }

    public static EnumOptionData getChargeAmountTypeEnum(String chargeAmountType) {
        EnumOptionData chargeAmountTypeEnum = null;
        if (chargeAmountType != null) {
            String chargeAmountTypeId = "";
            chargeAmountTypeId = chargeAmountType.equalsIgnoreCase("Flat") ? "1" : (chargeAmountType.equalsIgnoreCase("% Amount") ? "2" : chargeAmountType);
            chargeAmountTypeEnum = new EnumOptionData(null, null, chargeAmountTypeId);
        }
        return chargeAmountTypeEnum;
    }

    public static String getCodeByName(Sheet sheet, String name) {
        String sheetName = sheet.getSheetName();
        if (sheetName.equals("Extras")) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    if (name == null || cell.getCellType() != CellType.STRING || !cell.getRichStringCellValue().getString().trim().equals(name)) continue;
                    return row.getCell(cell.getColumnIndex() - 1).getStringCellValue().toString();
                }
            }
        }
        return "";
    }

    public static String getFrequencyId(String frequency) {
        if (frequency != null) {
            if (frequency.equalsIgnoreCase("Daily")) {
                frequency = "1";
            } else if (frequency.equalsIgnoreCase("Weekly")) {
                frequency = "2";
            } else if (frequency.equalsIgnoreCase("Monthly")) {
                frequency = "3";
            } else if (frequency.equalsIgnoreCase("Yearly")) {
                frequency = "4";
            }
            return frequency;
        }
        return null;
    }

    public static String getRepeatsOnDayId(String repeatsOnDay) {
        if (repeatsOnDay != null) {
            if (repeatsOnDay.equalsIgnoreCase("Mon")) {
                repeatsOnDay = "1";
            } else if (repeatsOnDay.equalsIgnoreCase("Tue")) {
                repeatsOnDay = "2";
            } else if (repeatsOnDay.equalsIgnoreCase("Wed")) {
                repeatsOnDay = "3";
            } else if (repeatsOnDay.equalsIgnoreCase("Thu")) {
                repeatsOnDay = "4";
            } else if (repeatsOnDay.equalsIgnoreCase("Fri")) {
                repeatsOnDay = "5";
            } else if (repeatsOnDay.equalsIgnoreCase("Sat")) {
                repeatsOnDay = "6";
            } else if (repeatsOnDay.equalsIgnoreCase("Sun")) {
                repeatsOnDay = "7";
            }
            return repeatsOnDay;
        }
        return null;
    }
}

