/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.data.BusinessStepNameAndOrder;
import org.apache.fineract.cob.data.LoanCOBParameter;
import org.apache.fineract.cob.data.LoanCOBPartition;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.springbatch.PropertyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.util.StopWatch;

public class LoanCOBPartitioner
implements Partitioner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanCOBPartitioner.class);
    public static final String PARTITION_PREFIX = "partition_";
    private final PropertyService propertyService;
    private final COBBusinessStepService cobBusinessStepService;
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final JobOperator jobOperator;
    private final JobExplorer jobExplorer;
    private final Long numberOfDays;
    @Value(value="#{stepExecutionContext['BusinessDate']}")
    private LocalDate businessDate;
    @Value(value="#{stepExecutionContext['IS_CATCH_UP']}")
    private Boolean isCatchUp;

    @NonNull
    public Map<String, ExecutionContext> partition(int gridSize) {
        int partitionSize = this.propertyService.getPartitionSize("LOAN_COB");
        Set cobBusinessSteps = this.cobBusinessStepService.getCOBBusinessSteps(LoanCOBBusinessStep.class, "LOAN_CLOSE_OF_BUSINESS");
        return this.getPartitions(partitionSize, cobBusinessSteps);
    }

    private Map<String, ExecutionContext> getPartitions(int partitionSize, Set<BusinessStepNameAndOrder> cobBusinessSteps) {
        if (cobBusinessSteps.isEmpty()) {
            this.stopJobExecution();
            return Map.of();
        }
        StopWatch sw = new StopWatch();
        sw.start();
        ArrayList<LoanCOBPartition> loanCOBPartitions = new ArrayList<LoanCOBPartition>(this.retrieveLoanIdService.retrieveLoanCOBPartitions(this.numberOfDays, this.businessDate, this.isCatchUp != null && this.isCatchUp != false, partitionSize));
        sw.stop();
        if (loanCOBPartitions.size() == 0) {
            loanCOBPartitions.add(new LoanCOBPartition(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(0L)));
        }
        log.info("LoanCOBPartitioner found {} loans to be processed as part of COB. {} partitions were created using partition size {}. RetrieveLoanCOBPartitions was executed in {} ms.", new Object[]{this.getLoanCount(loanCOBPartitions), loanCOBPartitions.size(), partitionSize, sw.getTotalTimeMillis()});
        return loanCOBPartitions.stream().collect(Collectors.toMap(l -> PARTITION_PREFIX + l.getPageNo(), l -> this.createNewPartition(cobBusinessSteps, l)));
    }

    private long getLoanCount(List<LoanCOBPartition> loanCOBPartitions) {
        return loanCOBPartitions.stream().map(LoanCOBPartition::getCount).reduce(0L, Long::sum);
    }

    private ExecutionContext createNewPartition(Set<BusinessStepNameAndOrder> cobBusinessSteps, LoanCOBPartition loanCOBPartition) {
        ExecutionContext executionContext = new ExecutionContext();
        executionContext.put("businessSteps", cobBusinessSteps);
        executionContext.put("loanCobParameter", (Object)new LoanCOBParameter(loanCOBPartition.getMinId(), loanCOBPartition.getMaxId()));
        executionContext.put("partition", (Object)(PARTITION_PREFIX + loanCOBPartition.getPageNo()));
        return executionContext;
    }

    private void stopJobExecution() {
        Set runningJobExecutions = this.jobExplorer.findRunningJobExecutions(JobName.LOAN_COB.name());
        for (JobExecution jobExecution : runningJobExecutions) {
            try {
                this.jobOperator.stop(jobExecution.getId().longValue());
            }
            catch (JobExecutionNotRunningException | NoSuchJobExecutionException e) {
                log.error("There is no running execution for the given execution ID. Execution ID: {}", (Object)jobExecution.getId());
                throw new RuntimeException(e);
            }
        }
    }

    @Generated
    public LoanCOBPartitioner(PropertyService propertyService, COBBusinessStepService cobBusinessStepService, RetrieveLoanIdService retrieveLoanIdService, JobOperator jobOperator, JobExplorer jobExplorer, Long numberOfDays) {
        this.propertyService = propertyService;
        this.cobBusinessStepService = cobBusinessStepService;
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.jobOperator = jobOperator;
        this.jobExplorer = jobExplorer;
        this.numberOfDays = numberOfDays;
    }

    @Generated
    public void setBusinessDate(LocalDate businessDate) {
        this.businessDate = businessDate;
    }

    @Generated
    public void setIsCatchUp(Boolean isCatchUp) {
        this.isCatchUp = isCatchUp;
    }
}

