/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.listener;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.cob.exceptions.LoanReadException;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.serialization.ThrowableSerialization;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.annotation.OnReadError;
import org.springframework.batch.core.annotation.OnSkipInProcess;
import org.springframework.batch.core.annotation.OnSkipInRead;
import org.springframework.batch.core.annotation.OnSkipInWrite;
import org.springframework.batch.core.annotation.OnWriteError;
import org.springframework.batch.item.Chunk;
import org.springframework.lang.NonNull;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractLoanItemListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLoanItemListener.class);
    private final LoanLockingService loanLockingService;
    private final TransactionTemplate transactionTemplate;

    private void updateAccountLockWithError(List<Long> loanIds, String msg, Throwable e) {
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OnReadError
    public void onReadError(Exception e) {
        if (e instanceof LoanReadException) {
            LoanReadException ee = (LoanReadException)e;
            log.warn("Error was triggered during reading of Loan (id={}) due to: {}", (Object)ee.getId(), (Object)ThrowableSerialization.serialize((Throwable)e));
            this.updateAccountLockWithError(List.of(ee.getId()), "Loan (id: %d) reading is failed", (Throwable)e);
        } else {
            log.error("Could not handle read error", (Throwable)e);
        }
    }

    @OnProcessError
    public void onProcessError(@NonNull Loan item, Exception e) {
        log.warn("Error was triggered during processing of Loan (id={}) due to: {}", (Object)item.getId(), (Object)ThrowableSerialization.serialize((Throwable)e));
        this.updateAccountLockWithError(List.of((Long)item.getId()), "Loan (id: %d) processing is failed", (Throwable)e);
    }

    @OnWriteError
    public void onWriteError(Exception e, @NonNull Chunk<? extends Loan> items) {
        List<Long> loanIds = items.getItems().stream().map(AbstractPersistableCustom::getId).toList();
        log.warn("Error was triggered during writing of Loans (ids={}) due to: {}", loanIds, (Object)ThrowableSerialization.serialize((Throwable)e));
        this.updateAccountLockWithError(loanIds, "Loan (id: %d) writing is failed", (Throwable)e);
    }

    @OnSkipInRead
    public void onSkipInRead(@NonNull Throwable e) {
        log.warn("Skipping was triggered during read!");
    }

    @OnSkipInProcess
    public void onSkipInProcess(@NonNull Loan item, @NonNull Throwable e) {
        log.warn("Skipping was triggered during processing of Loan (id={})", (Object)item.getId());
    }

    @OnSkipInWrite
    public void onSkipInWrite(@NonNull Loan item, @NonNull Throwable e) {
        log.warn("Skipping was triggered during writing of Loan (id={})", (Object)item.getId());
    }

    protected abstract LockOwner getLockOwner();

    @Generated
    public AbstractLoanItemListener(LoanLockingService loanLockingService, TransactionTemplate transactionTemplate) {
        this.loanLockingService = loanLockingService;
        this.transactionTemplate = transactionTemplate;
    }
}

